/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.sis.metadata.internal.NameToIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.NameSpace;
import org.opengis.util.ScopedName;

public class NamedIdentifier
extends ImmutableIdentifier
implements GenericName {
    private static final long serialVersionUID = -3982456534858346939L;
    private transient GenericName name;
    private transient boolean isNameSupplied;

    public NamedIdentifier(ReferenceIdentifier identifier) {
        super(identifier);
        if (identifier instanceof GenericName) {
            this.name = (GenericName)((Object)identifier);
            this.isNameSupplied = true;
        }
    }

    public NamedIdentifier(GenericName name) {
        super(name instanceof ReferenceIdentifier ? (ReferenceIdentifier)((Object)name) : new NameToIdentifier(name));
        this.name = name;
        this.isNameSupplied = true;
    }

    public NamedIdentifier(Map<String, ?> properties) throws IllegalArgumentException {
        super(properties);
        this.name = (GenericName)properties.get("name");
        this.isNameSupplied = this.name != null;
    }

    public NamedIdentifier(Citation authority, CharSequence code) {
        super(authority, Citations.toCodeSpace(authority), NamedIdentifier.toString(code));
        if (code instanceof InternationalString) {
            this.name = NamedIdentifier.createName(authority, super.getCodeSpace(), code);
            this.isNameSupplied = true;
        }
    }

    public NamedIdentifier(Citation authority, String codeSpace, CharSequence code, String version, InternationalString description) {
        super(authority, codeSpace, NamedIdentifier.toString(code), version, description);
        if (code instanceof InternationalString) {
            this.name = NamedIdentifier.createName(authority, codeSpace, code);
            this.isNameSupplied = true;
        }
    }

    private static String toString(CharSequence code) {
        ArgumentChecks.ensureNonNull("code", code);
        String c = code instanceof InternationalString ? ((InternationalString)code).toString(Locale.ROOT) : code.toString();
        if (c != null) {
            return c;
        }
        throw new IllegalArgumentException(Errors.format((short)42, "code", code.getClass()));
    }

    private synchronized GenericName getName() {
        if (this.name == null) {
            this.name = NamedIdentifier.createName(super.getAuthority(), super.getCodeSpace(), super.getCode());
        }
        return this.name;
    }

    private static GenericName createName(Citation authority, String codeSpace, CharSequence code) {
        if (codeSpace == null) {
            codeSpace = Citations.toCodeSpace(authority);
        }
        DefaultNameFactory factory = DefaultNameFactory.provider();
        if (codeSpace != null) {
            return factory.createGenericName(null, codeSpace, code);
        }
        return factory.createLocalName(null, code);
    }

    public static NamedIdentifier castOrCopy(ReferenceIdentifier object) {
        if (object == null || object instanceof NamedIdentifier) {
            return (NamedIdentifier)object;
        }
        return new NamedIdentifier(object);
    }

    public static NamedIdentifier castOrCopy(GenericName object) {
        if (object == null || object instanceof NamedIdentifier) {
            return (NamedIdentifier)object;
        }
        return new NamedIdentifier(object);
    }

    @Override
    public LocalName tip() {
        return this.getName().tip();
    }

    @Override
    public LocalName head() {
        return this.getName().head();
    }

    @Override
    public NameSpace scope() {
        return this.getName().scope();
    }

    @Override
    public int depth() {
        return this.getName().depth();
    }

    @Override
    public List<? extends LocalName> getParsedNames() {
        return this.getName().getParsedNames();
    }

    @Override
    public ScopedName push(GenericName scope) {
        return this.getName().push(scope);
    }

    @Override
    public GenericName toFullyQualifiedName() {
        return this.getName().toFullyQualifiedName();
    }

    @Override
    public InternationalString toInternationalString() {
        return this.getName().toInternationalString();
    }

    @Override
    public String toString() {
        return this.getName().toString();
    }

    @Override
    public int compareTo(GenericName object) {
        return this.getName().compareTo(object);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            if (!this.isNameSupplied) {
                return true;
            }
            NamedIdentifier that = (NamedIdentifier)object;
            return Objects.equals(this.getName(), that.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ~super.hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.isNameSupplied ? this.name : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.name = (GenericName)in.readObject();
        this.isNameSupplied = this.name != null;
    }
}

