/*
 * Decompiled with CFR 0.152.
 */
package ucar.httpservices;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.net.ssl.SSLException;
import net.jcip.annotations.NotThreadSafe;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.CustomSSLProtocolSocketFactory;
import ucar.httpservices.HTTPAuthScope;
import ucar.httpservices.HTTPAuthStore;
import ucar.httpservices.HTTPBasicProvider;
import ucar.httpservices.HTTPCachingProvider;
import ucar.httpservices.HTTPConstantProvider;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSSLProvider;
import ucar.httpservices.HTTPUtil;

@NotThreadSafe
public class HTTPSession
implements AutoCloseable {
    public static final String ALLOW_CIRCULAR_REDIRECTS = "http.protocol.allow-circular-redirects";
    public static final String HANDLE_REDIRECTS = "http.protocol.handle-redirects";
    public static final String HANDLE_AUTHENTICATION = "http.protocol.handle-authentication";
    public static final String MAX_REDIRECTS = "http.protocol.max-redirects";
    public static final String SO_TIMEOUT = "http.socket.timeout";
    public static final String CONN_TIMEOUT = "http.connection.timeout";
    public static final String USER_AGENT = "http.useragent";
    public static final String PROXY = "http.route.default-proxy";
    public static final String COMPRESSION = "COMPRESSION";
    public static final String HEADER_USERAGENT = "User-Agent";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String BASIC = "Basic";
    public static final String DIGEST = "Digest";
    public static final String NTLM = "NTLM";
    public static final String SSL = "SSL";
    static final int DFALTTHREADCOUNT = 50;
    static final int DFALTREDIRECTS = 25;
    static final int DFALTCONNTIMEOUT = 60000;
    static final int DFALTSOTIMEOUT = 300000;
    static final String DFALTUSERAGENT = "/NetcdfJava/HttpClient4.3";
    public static Logger log = LoggerFactory.getLogger(HTTPSession.class);
    static PoolingClientConnectionManager connmgr;
    static Settings globalsettings;
    static List<HttpRequestInterceptor> reqintercepts;
    static List<HttpResponseInterceptor> rspintercepts;
    protected AbstractHttpClient sessionClient = null;
    protected List<HTTPMethod> methodList = new Vector<HTTPMethod>();
    protected HttpContext execcontext = null;
    protected String identifier = "Session";
    protected String legalurl = null;
    protected boolean closed = false;
    protected Settings localsettings = new Settings();
    protected HTTPAuthStore authlocal = new HTTPAuthStore();
    protected List<Object> intercepts = new ArrayList<Object>();
    static List<HTTPSession> sessionList;
    public static boolean TESTING;

    static void setDefaults(Settings props) {
        props.setParameter(ALLOW_CIRCULAR_REDIRECTS, Boolean.TRUE);
        props.setParameter(MAX_REDIRECTS, 25);
        props.setParameter(SO_TIMEOUT, 300000);
        props.setParameter(CONN_TIMEOUT, 60000);
        props.setParameter(USER_AGENT, DFALTUSERAGENT);
    }

    public static synchronized Settings getGlobalSettings() {
        return globalsettings;
    }

    public static synchronized void setGlobalUserAgent(String userAgent) {
        globalsettings.setParameter(USER_AGENT, userAgent);
    }

    public static synchronized String getGlobalUserAgent() {
        return (String)globalsettings.getParameter(USER_AGENT);
    }

    public static synchronized void setGlobalThreadCount(int nthreads) {
        connmgr.setMaxTotal(nthreads);
        connmgr.setDefaultMaxPerRoute(nthreads);
    }

    public static void setGlobalMaxConnections(int nthreads) {
        HTTPSession.setGlobalThreadCount(nthreads);
    }

    public static synchronized int getGlobalThreadCount() {
        return connmgr.getMaxTotal();
    }

    public static synchronized List<Cookie> getGlobalCookies() {
        DefaultHttpClient client = new DefaultHttpClient(connmgr);
        List<Cookie> cookies = client.getCookieStore().getCookies();
        return cookies;
    }

    public static synchronized void setGlobalConnectionTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.setParameter(CONN_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalSoTimeout(int timeout) {
        if (timeout >= 0) {
            globalsettings.setParameter(SO_TIMEOUT, timeout);
        }
    }

    public static synchronized void setGlobalProxy(String host, int port) {
        Proxy proxy = new Proxy();
        proxy.host = host;
        proxy.port = port;
        globalsettings.setParameter(PROXY, proxy);
    }

    public static synchronized void setGlobalCompression() {
        globalsettings.setParameter(COMPRESSION, "gzip,deflate");
        HttpResponseInterceptor hrsi = new GZIPResponseInterceptor();
        rspintercepts.add(hrsi);
        hrsi = new DeflateResponseInterceptor();
        rspintercepts.add(hrsi);
    }

    protected static synchronized void defineCredentialsProvider(String principal, AuthScope scope, CredentialsProvider provider, HTTPAuthStore store) {
        try {
            if (provider == null) {
                store.remove(new HTTPAuthStore.Entry(principal, scope, provider));
            } else {
                store.insert(new HTTPAuthStore.Entry(principal, scope, provider));
            }
        }
        catch (HTTPException he) {
            log.error("HTTPSession.setCredentialsProvider failed");
        }
    }

    public static void setGlobalCredentialsProvider(AuthScope scope, CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(HTTPAuthScope.ANY_PRINCIPAL, scope, provider, HTTPAuthStore.getDefault());
    }

    public static void setGlobalCredentialsProvider(CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(HTTPAuthScope.ANY_PRINCIPAL, HTTPAuthScope.ANY, provider, HTTPAuthStore.getDefault());
    }

    public static void setGlobalCredentials(AuthScope scope, Credentials creds) {
        HTTPConstantProvider provider = new HTTPConstantProvider(creds);
        HTTPSession.setGlobalCredentialsProvider(scope, provider);
    }

    public static int getRetryCount() {
        return RetryHandler.getRetries();
    }

    public static void setRetryCount(int count) {
        RetryHandler.setRetries(count);
    }

    public static String getCanonicalURL(String legalurl) {
        if (legalurl == null) {
            return null;
        }
        int index = legalurl.indexOf(63);
        if (index >= 0) {
            legalurl = legalurl.substring(0, index);
        }
        return HTTPSession.canonicalpath(legalurl);
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.replace('\\', '/')).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String removeprincipal(String u) {
        String newurl = null;
        try {
            URL url = new URL(u);
            String protocol = url.getProtocol() + "://";
            String host = url.getHost();
            int port = url.getPort();
            String path = url.getPath();
            String query = url.getQuery();
            String ref = url.getRef();
            String sport = port <= 0 ? "" : ":" + port;
            path = path == null ? "" : path;
            query = query == null ? "" : "?" + query;
            ref = ref == null ? "" : "#" + ref;
            newurl = protocol + host + sport + path + query + ref;
        }
        catch (MalformedURLException use) {
            newurl = u;
        }
        return newurl;
    }

    /*
     * Exception decompiling
     */
    public static String getUrlAsString(String url) throws HTTPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int putUrlAsString(String content, String url) throws HTTPException {
        int status = 0;
        try (HTTPMethod m4 = HTTPFactory.Put(url);){
            m4.setRequestContent(new StringEntity(content, "application/text", "UTF-8"));
            status = m4.execute();
        }
        catch (UnsupportedEncodingException uee) {
            throw new HTTPException(uee);
        }
        return status;
    }

    static String getstorepath(String prefix) {
        String path = System.getProperty(prefix + "store");
        if (path != null && (path = path.trim()).length() == 0) {
            path = null;
        }
        return path;
    }

    static String getpassword(String prefix) {
        String password = System.getProperty(prefix + "storepassword");
        if (password != null && (password = password.trim()).length() == 0) {
            password = null;
        }
        return password;
    }

    static String cleanproperty(String property) {
        String value = System.getProperty(property);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    static synchronized void setGlobalKeyStore() {
        String keypassword = HTTPSession.cleanproperty("keystorepassword");
        String keypath = HTTPSession.cleanproperty("keystore");
        String trustpassword = HTTPSession.cleanproperty("truststorepassword");
        String trustpath = HTTPSession.cleanproperty("truststore");
        if (keypath != null || trustpath != null) {
            HTTPSSLProvider sslprovider = new HTTPSSLProvider(keypath, keypassword, trustpath, trustpassword);
            HTTPSession.setGlobalCredentialsProvider(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, SSL), sslprovider);
        }
    }

    static void getGlobalProxyD() {
        String host = System.getProperty("http.proxyHost");
        String port = System.getProperty("http.proxyPort");
        int portno = -1;
        if (host != null && (host = host.trim()).length() == 0) {
            host = null;
        }
        if (port != null && (port = port.trim()).length() > 0) {
            try {
                portno = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                portno = -1;
            }
        }
        if (host != null) {
            HTTPSession.setGlobalProxy(host, portno);
        }
    }

    public HTTPSession() throws HTTPException {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPSession(String url) throws HTTPException {
        try {
            new URL(url);
        }
        catch (MalformedURLException mue) {
            throw new HTTPException("Malformed URL: " + url, mue);
        }
        this.legalurl = url;
        try {
            Class<HTTPSession> mue = HTTPSession.class;
            synchronized (HTTPSession.class) {
                this.sessionClient = new DefaultHttpClient(connmgr);
                // ** MonitorExit[mue] (shouldn't be in output)
                if (TESTING) {
                    HTTPSession.track(this);
                }
                this.setInterceptors();
            }
        }
        catch (Exception e) {
            throw new HTTPException("url=" + url, e);
        }
        {
            this.execcontext = new BasicHttpContext();
            return;
        }
    }

    synchronized void setInterceptors() {
        for (HttpRequestInterceptor hrq : reqintercepts) {
            this.sessionClient.addRequestInterceptor(hrq);
        }
        for (HttpResponseInterceptor hrs : rspintercepts) {
            this.sessionClient.addResponseInterceptor(hrs);
        }
    }

    synchronized void clearInterceptors() {
        for (HttpRequestInterceptor hrq : reqintercepts) {
            this.clearInterceptor(hrq);
        }
        for (HttpResponseInterceptor hrs : rspintercepts) {
            this.clearInterceptor(hrs);
        }
    }

    synchronized void clearInterceptor(Object o) {
        if (o instanceof HttpResponseInterceptor) {
            this.sessionClient.removeResponseInterceptorByClass(((HttpResponseInterceptor)o).getClass());
        }
        if (o instanceof HttpRequestInterceptor) {
            this.sessionClient.removeRequestInterceptorByClass(((HttpRequestInterceptor)o).getClass());
        }
    }

    public HTTPAuthStore getAuthStore() {
        return this.authlocal;
    }

    public Settings getSettings() {
        return this.localsettings;
    }

    public String getURL() {
        return this.legalurl;
    }

    public void setUserAgent(String agent) {
        if (agent != null) {
            this.localsettings.setParameter(USER_AGENT, agent);
        }
    }

    public void setSoTimeout(int timeout) {
        if (timeout >= 0) {
            this.localsettings.setParameter(SO_TIMEOUT, timeout);
        }
    }

    public void setConnectionTimeout(int timeout) {
        if (timeout >= 0) {
            this.localsettings.setParameter(CONN_TIMEOUT, timeout);
        }
    }

    public void setMaxRedirects(int n) {
        this.localsettings.setParameter(MAX_REDIRECTS, n);
    }

    HttpContext getContext() {
        return this.execcontext;
    }

    HttpClient getClient() {
        return this.sessionClient;
    }

    HttpContext getExecutionContext() {
        return this.execcontext;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        while (this.methodList.size() > 0) {
            HTTPMethod m4 = this.methodList.get(0);
            m4.close();
        }
        this.closed = true;
    }

    public List<Cookie> getCookies() {
        if (this.sessionClient == null) {
            return null;
        }
        List<Cookie> cookies = this.sessionClient.getCookieStore().getCookies();
        return cookies;
    }

    synchronized void addMethod(HTTPMethod m4) {
        if (!this.methodList.contains(m4)) {
            this.methodList.add(m4);
        }
    }

    synchronized void removeMethod(HTTPMethod m4) {
        this.methodList.remove(m4);
    }

    public void clearState() {
        this.sessionClient.getCredentialsProvider().clear();
        this.sessionClient.getCookieStore().clear();
        this.execcontext = new BasicHttpContext();
        this.localsettings.clear();
        this.authlocal.clear();
    }

    void setProxy(Proxy proxy) {
        if (this.sessionClient == null) {
            return;
        }
        if (proxy != null && proxy.host != null) {
            this.localsettings.setParameter(PROXY, proxy);
        }
    }

    public void setProxy(String host, int port) {
        Proxy proxy = new Proxy();
        proxy.host = host;
        proxy.port = port;
        this.setProxy(proxy);
    }

    public void setCredentialsProvider(AuthScope scope, CredentialsProvider provider) {
        HTTPSession.defineCredentialsProvider(HTTPAuthScope.ANY_PRINCIPAL, scope, provider, this.authlocal);
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.setCredentialsProvider(HTTPAuthScope.ANY, provider);
    }

    public void setCredentialsProvider(String scheme, CredentialsProvider provider) {
        AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, scheme);
        this.setCredentialsProvider(scope, provider);
    }

    public void setCredentials(String scheme, Credentials creds) {
        HTTPConstantProvider provider = new HTTPConstantProvider(creds);
        this.setCredentialsProvider(scheme, (CredentialsProvider)provider);
    }

    public void setCredentialsProvider(String surl) throws HTTPException {
        URI uri = HTTPAuthScope.decompose(surl);
        String userinfo = uri.getUserInfo();
        if (userinfo != null) {
            int index = userinfo.indexOf(58);
            String user = userinfo.substring(index);
            String pwd = userinfo.substring(index + 1, userinfo.length());
            if (user != null && pwd != null) {
                HTTPBasicProvider bp = new HTTPBasicProvider(user, pwd);
                this.setCredentialsProvider(BASIC, (CredentialsProvider)bp);
            }
        }
    }

    protected synchronized void setAuthentication(HTTPCachingProvider hap) {
        this.sessionClient.setCredentialsProvider(hap);
    }

    protected HttpResponse execute(HttpRequestBase request) throws IOException {
        HttpResponse response = this.sessionClient.execute((HttpUriRequest)request, this.execcontext);
        return response;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized int getMethodcount() {
        return this.methodList.size();
    }

    protected static synchronized void kill() {
        if (sessionList != null) {
            for (HTTPSession session : sessionList) {
                session.close();
            }
            sessionList.clear();
            connmgr.shutdown();
            connmgr = new PoolingClientConnectionManager();
            HTTPSession.setGlobalThreadCount(50);
        }
    }

    protected static synchronized void track(HTTPSession session) {
        if (sessionList == null) {
            sessionList = new ArrayList<HTTPSession>();
        }
        sessionList.add(session);
    }

    public static synchronized void debugHeaders(boolean print) {
        Object hr;
        int i;
        HTTPUtil.InterceptRequest rq = new HTTPUtil.InterceptRequest();
        HTTPUtil.InterceptResponse rs = new HTTPUtil.InterceptResponse();
        rq.setPrint(print);
        rs.setPrint(print);
        for (i = reqintercepts.size() - 1; i >= 0; --i) {
            hr = reqintercepts.get(i);
            if (!(hr instanceof HTTPUtil.InterceptCommon)) continue;
            reqintercepts.remove(i);
        }
        for (i = rspintercepts.size() - 1; i >= 0; --i) {
            hr = rspintercepts.get(i);
            if (!(hr instanceof HTTPUtil.InterceptCommon)) continue;
            rspintercepts.remove(i);
        }
        reqintercepts.add(rq);
        rspintercepts.add(rs);
    }

    public static void debugReset() {
        for (HttpRequestInterceptor hri : reqintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptCommon)) continue;
            ((HTTPUtil.InterceptCommon)((Object)hri)).clear();
        }
    }

    public static HTTPUtil.InterceptRequest debugRequestInterceptor() {
        for (HttpRequestInterceptor hri : reqintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptRequest)) continue;
            return (HTTPUtil.InterceptRequest)hri;
        }
        return null;
    }

    public static HTTPUtil.InterceptResponse debugResponseInterceptor() {
        for (HttpResponseInterceptor hri : rspintercepts) {
            if (!(hri instanceof HTTPUtil.InterceptResponse)) continue;
            return (HTTPUtil.InterceptResponse)hri;
        }
        return null;
    }

    static {
        reqintercepts = new ArrayList<HttpRequestInterceptor>();
        rspintercepts = new ArrayList<HttpResponseInterceptor>();
        connmgr = new PoolingClientConnectionManager();
        connmgr.getSchemeRegistry().register(new Scheme("https", 8443, new CustomSSLProtocolSocketFactory()));
        connmgr.getSchemeRegistry().register(new Scheme("https", 443, new CustomSSLProtocolSocketFactory()));
        globalsettings = new Settings();
        HTTPSession.setDefaults(globalsettings);
        HTTPSession.setGlobalUserAgent(DFALTUSERAGENT);
        HTTPSession.setGlobalThreadCount(50);
        HTTPSession.setGlobalConnectionTimeout(60000);
        HTTPSession.setGlobalSoTimeout(300000);
        HTTPSession.getGlobalProxyD();
        HTTPSession.setGlobalKeyStore();
        sessionList = null;
        TESTING = false;
    }

    static class DeflateResponseInterceptor
    implements HttpResponseInterceptor {
        DeflateResponseInterceptor() {
        }

        @Override
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h2 : codecs = ceheader.getElements()) {
                    if (!h2.getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    static class GZIPResponseInterceptor
    implements HttpResponseInterceptor {
        GZIPResponseInterceptor() {
        }

        @Override
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs;
                for (HeaderElement h2 : codecs = ceheader.getElements()) {
                    if (!h2.getName().equalsIgnoreCase("gzip")) continue;
                    response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }

    public static class RetryHandler
    implements HttpRequestRetryHandler {
        static final int DFALTRETRIES = 5;
        static int retries = 5;
        static boolean verbose = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (RetryHandler.getVerbose()) {
                log.debug(String.format("Retry: count=%d exception=%s", executionCount, exception.toString()));
            }
            Class<RetryHandler> clazz = RetryHandler.class;
            synchronized (RetryHandler.class) {
                boolean idempotent;
                if (executionCount >= retries) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return false;
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                if (exception instanceof InterruptedIOException || exception instanceof UnknownHostException || exception instanceof ConnectException || exception instanceof SSLException) {
                    return false;
                }
                HttpRequest request = (HttpRequest)context.getAttribute("http.request");
                boolean bl = idempotent = !(request instanceof HttpEntityEnclosingRequest);
                return idempotent;
            }
        }

        public static synchronized int getRetries() {
            return retries;
        }

        public static synchronized void setRetries(int retries) {
            RetryHandler.retries = retries;
        }

        public static synchronized boolean getVerbose() {
            return verbose;
        }

        public static synchronized void setVerbose(boolean tf) {
            verbose = tf;
        }
    }

    static enum Methods {
        Get("get"),
        Head("head"),
        Put("put"),
        Post("post"),
        Options("options");

        private final String name;

        private Methods(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    static class Proxy {
        public String host = null;
        public int port = -1;

        Proxy() {
        }
    }

    static class Settings
    extends SyncBasicHttpParams {
        Settings() {
        }
    }
}

