/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.quartz.Calendar;
import org.quartz.spi.OperableTrigger;

public class TriggerUtils {
    private TriggerUtils() {
    }

    public static List<Date> computeFireTimes(OperableTrigger trigger, Calendar cal, int numTimes) {
        Date d;
        LinkedList<Date> lst = new LinkedList<Date>();
        OperableTrigger t2 = (OperableTrigger)trigger.clone();
        if (t2.getNextFireTime() == null) {
            t2.computeFirstFireTime(cal);
        }
        for (int i = 0; i < numTimes && (d = t2.getNextFireTime()) != null; ++i) {
            lst.add(d);
            t2.triggered(cal);
        }
        return Collections.unmodifiableList(lst);
    }

    public static Date computeEndTimeToAllowParticularNumberOfFirings(OperableTrigger trigger, Calendar cal, int numTimes) {
        Date d;
        OperableTrigger t2 = (OperableTrigger)trigger.clone();
        if (t2.getNextFireTime() == null) {
            t2.computeFirstFireTime(cal);
        }
        int c = 0;
        Date endTime = null;
        for (int i = 0; i < numTimes && (d = t2.getNextFireTime()) != null; ++i) {
            t2.triggered(cal);
            if (++c != numTimes) continue;
            endTime = d;
        }
        if (endTime == null) {
            return null;
        }
        endTime = new Date(endTime.getTime() + 1000L);
        return endTime;
    }

    public static List<Date> computeFireTimesBetween(OperableTrigger trigger, Calendar cal, Date from, Date to) {
        Date d;
        LinkedList<Date> lst = new LinkedList<Date>();
        OperableTrigger t2 = (OperableTrigger)trigger.clone();
        if (t2.getNextFireTime() == null) {
            t2.setStartTime(from);
            t2.setEndTime(to);
            t2.computeFirstFireTime(cal);
        }
        while ((d = t2.getNextFireTime()) != null) {
            if (d.before(from)) {
                t2.triggered(cal);
                continue;
            }
            if (d.after(to)) break;
            lst.add(d);
            t2.triggered(cal);
        }
        return Collections.unmodifiableList(lst);
    }
}

