/*
 * Decompiled with CFR 0.152.
 */
package org.quartz;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.TreeSet;
import org.quartz.ValueSet;

public final class CronExpression
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 12423409423L;
    protected static final int SECOND = 0;
    protected static final int MINUTE = 1;
    protected static final int HOUR = 2;
    protected static final int DAY_OF_MONTH = 3;
    protected static final int MONTH = 4;
    protected static final int DAY_OF_WEEK = 5;
    protected static final int YEAR = 6;
    protected static final int ALL_SPEC_INT = 99;
    protected static final int NO_SPEC_INT = 98;
    protected static final int MAX_LAST_DAY_OFFSET = 30;
    protected static final int LAST_DAY_OFFSET_START = 32;
    protected static final int LAST_DAY_OFFSET_END = 62;
    protected static final Integer ALL_SPEC = 99;
    protected static final Integer NO_SPEC = 98;
    protected static final Map<String, Integer> monthMap = new HashMap<String, Integer>(20);
    protected static final Map<String, Integer> dayMap = new HashMap<String, Integer>(60);
    private final String cronExpression;
    private TimeZone timeZone = null;
    protected transient TreeSet<Integer> seconds;
    protected transient TreeSet<Integer> minutes;
    protected transient TreeSet<Integer> hours;
    protected transient TreeSet<Integer> daysOfMonth;
    protected transient TreeSet<Integer> nearestWeekdays;
    protected transient TreeSet<Integer> months;
    protected transient TreeSet<Integer> daysOfWeek;
    protected transient TreeSet<Integer> years;
    protected transient boolean lastDayOfWeek = false;
    protected transient int nthDayOfWeek = 0;
    protected transient boolean expressionParsed = false;
    public static final int MAX_YEAR;

    public CronExpression(String cronExpression) throws ParseException {
        if (cronExpression == null) {
            throw new IllegalArgumentException("cronExpression cannot be null");
        }
        this.cronExpression = cronExpression.toUpperCase(Locale.US);
        this.buildExpression(this.cronExpression);
    }

    public CronExpression(CronExpression expression) {
        this.cronExpression = expression.getCronExpression();
        try {
            this.buildExpression(this.cronExpression);
        }
        catch (ParseException ex) {
            throw new AssertionError("Could not parse expression!", ex);
        }
        if (expression.getTimeZone() != null) {
            this.setTimeZone((TimeZone)expression.getTimeZone().clone());
        }
    }

    public boolean isSatisfiedBy(Date date) {
        Calendar testDateCal = Calendar.getInstance(this.getTimeZone());
        testDateCal.setTime(date);
        testDateCal.set(14, 0);
        Date originalDate = testDateCal.getTime();
        testDateCal.add(13, -1);
        Date timeAfter = this.getTimeAfter(testDateCal.getTime());
        return timeAfter != null && timeAfter.equals(originalDate);
    }

    public Date getNextValidTimeAfter(Date date) {
        return this.getTimeAfter(date);
    }

    public Date getNextInvalidTimeAfter(Date date) {
        Date newDate;
        long difference = 1000L;
        Calendar adjustCal = Calendar.getInstance(this.getTimeZone());
        adjustCal.setTime(date);
        adjustCal.set(14, 0);
        Date lastDate = adjustCal.getTime();
        while (difference == 1000L && (newDate = this.getTimeAfter(lastDate)) != null) {
            difference = newDate.getTime() - lastDate.getTime();
            if (difference != 1000L) continue;
            lastDate = newDate;
        }
        return new Date(lastDate.getTime() + 1000L);
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        return this.cronExpression;
    }

    public static boolean isValidExpression(String cronExpression) {
        try {
            new CronExpression(cronExpression);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    public static void validateExpression(String cronExpression) throws ParseException {
        new CronExpression(cronExpression);
    }

    protected void buildExpression(String expression) throws ParseException {
        this.expressionParsed = true;
        try {
            boolean dayOfWSpec;
            int exprOn;
            StringTokenizer exprsTok;
            if (this.seconds == null) {
                this.seconds = new TreeSet();
            }
            if (this.minutes == null) {
                this.minutes = new TreeSet();
            }
            if (this.hours == null) {
                this.hours = new TreeSet();
            }
            if (this.daysOfMonth == null) {
                this.daysOfMonth = new TreeSet();
            }
            if (this.nearestWeekdays == null) {
                this.nearestWeekdays = new TreeSet();
            }
            if (this.months == null) {
                this.months = new TreeSet();
            }
            if (this.daysOfWeek == null) {
                this.daysOfWeek = new TreeSet();
            }
            if (this.years == null) {
                this.years = new TreeSet();
            }
            if ((exprsTok = new StringTokenizer(expression, " \t", false)).countTokens() > 7) {
                throw new ParseException("Invalid expression has too many terms: " + expression, -1);
            }
            for (exprOn = 0; exprsTok.hasMoreTokens() && exprOn <= 6; ++exprOn) {
                String expr = exprsTok.nextToken().trim();
                if (exprOn == 5 && expr.indexOf(76) != -1 && expr.length() > 1 && expr.contains(",")) {
                    throw new ParseException("Support for specifying 'L' with other days of the week is not implemented", -1);
                }
                if (exprOn == 5 && expr.indexOf(35) != -1 && expr.indexOf(35, expr.indexOf(35) + 1) != -1) {
                    throw new ParseException("Support for specifying multiple \"nth\" days is not implemented.", -1);
                }
                StringTokenizer vTok = new StringTokenizer(expr, ",");
                while (vTok.hasMoreTokens()) {
                    String v = vTok.nextToken();
                    this.storeExpressionVals(0, v, exprOn);
                }
            }
            if (exprOn <= 5) {
                throw new ParseException("Unexpected end of expression.", expression.length());
            }
            if (exprOn <= 6) {
                this.storeExpressionVals(0, "*", 6);
            }
            TreeSet<Integer> dow = this.getSet(5);
            TreeSet<Integer> dom = this.getSet(3);
            boolean dayOfMSpec = !dom.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !dow.contains(NO_SPEC);
            if (!(dayOfMSpec && !dayOfWSpec || dayOfWSpec && !dayOfMSpec)) {
                throw new ParseException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.", 0);
            }
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParseException("Illegal cron expression format (" + e + ")", 0);
        }
    }

    protected int storeExpressionVals(int pos, String s2, int type) throws ParseException {
        int val;
        int incr = 0;
        int i = this.skipWhiteSpace(pos, s2);
        if (i >= s2.length()) {
            return i;
        }
        char c = s2.charAt(i);
        if (!(c < 'A' || c > 'Z' || s2.equals("L") || s2.equals("LW") || s2.matches("^L-[0-9]*[W]?"))) {
            int eval;
            int sval;
            block44: {
                String sub = s2.substring(i, i + 3);
                sval = -1;
                eval = -1;
                if (type == 4) {
                    sval = this.getMonthNumber(sub) + 1;
                    if (sval <= 0) {
                        throw new ParseException("Invalid Month value: '" + sub + "'", i);
                    }
                    if (s2.length() > i + 3 && (c = s2.charAt(i + 3)) == '-' && (eval = this.getMonthNumber(sub = s2.substring(i += 4, i + 3)) + 1) <= 0) {
                        throw new ParseException("Invalid Month value: '" + sub + "'", i);
                    }
                } else if (type == 5) {
                    sval = this.getDayOfWeekNumber(sub);
                    if (sval < 0) {
                        throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                    }
                    if (s2.length() > i + 3) {
                        c = s2.charAt(i + 3);
                        if (c == '-') {
                            if ((eval = this.getDayOfWeekNumber(sub = s2.substring(i += 4, i + 3))) < 0) {
                                throw new ParseException("Invalid Day-of-Week value: '" + sub + "'", i);
                            }
                        } else {
                            if (c == '#') {
                                try {
                                    this.nthDayOfWeek = Integer.parseInt(s2.substring(i += 4));
                                    if (this.nthDayOfWeek < 1 || this.nthDayOfWeek > 5) {
                                        throw new Exception();
                                    }
                                    break block44;
                                }
                                catch (Exception e) {
                                    throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
                                }
                            }
                            if (c == 'L') {
                                this.lastDayOfWeek = true;
                                ++i;
                            }
                        }
                    }
                } else {
                    throw new ParseException("Illegal characters for this position: '" + sub + "'", i);
                }
            }
            if (eval != -1) {
                incr = 1;
            }
            this.addToSet(sval, eval, incr, type);
            return i + 3;
        }
        if (c == '?') {
            if (++i + 1 < s2.length() && s2.charAt(i) != ' ' && s2.charAt(i + 1) != '\t') {
                throw new ParseException("Illegal character after '?': " + s2.charAt(i), i);
            }
            if (type != 5 && type != 3) {
                throw new ParseException("'?' can only be specified for Day-of-Month or Day-of-Week.", i);
            }
            if (type == 5 && !this.daysOfMonth.isEmpty() && this.daysOfMonth.last() == 98) {
                throw new ParseException("'?' can only be specified for Day-of-Month -OR- Day-of-Week.", i);
            }
            this.addToSet(98, -1, 0, type);
            return i;
        }
        if (c == '*' || c == '/') {
            if (c == '*' && i + 1 >= s2.length()) {
                this.addToSet(99, -1, incr, type);
                return i + 1;
            }
            if (c == '/' && (i + 1 >= s2.length() || s2.charAt(i + 1) == ' ' || s2.charAt(i + 1) == '\t')) {
                throw new ParseException("'/' must be followed by an integer.", i);
            }
            if (c == '*') {
                ++i;
            }
            if ((c = s2.charAt(i)) == '/') {
                if (++i >= s2.length()) {
                    throw new ParseException("Unexpected end of string.", i);
                }
                incr = this.getNumericValue(s2, i);
                ++i;
                if (incr > 10) {
                    ++i;
                }
                this.checkIncrementRange(incr, type, i);
            } else {
                incr = 1;
            }
            this.addToSet(99, -1, incr, type);
            return i;
        }
        if (c == 'L') {
            ++i;
            if (type == 5) {
                this.addToSet(7, 7, 0, type);
            }
            if (type == 3) {
                int dom = 62;
                boolean nearestWeekday = false;
                if (s2.length() > i) {
                    c = s2.charAt(i);
                    if (c == '-') {
                        ValueSet vs = this.getValue(0, s2, i + 1);
                        int offset = vs.value;
                        if (offset > 30) {
                            throw new ParseException("Offset from last day must be <= 30", i + 1);
                        }
                        dom -= offset;
                        i = vs.pos;
                    }
                    if (s2.length() > i && (c = s2.charAt(i)) == 'W') {
                        nearestWeekday = true;
                        ++i;
                    }
                }
                if (nearestWeekday) {
                    this.nearestWeekdays.add(dom);
                } else {
                    this.daysOfMonth.add(dom);
                }
            }
            return i;
        }
        if (c >= '0' && c <= '9') {
            val = Integer.parseInt(String.valueOf(c));
            if (++i < s2.length()) {
                c = s2.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(val, s2, i);
                    val = vs.value;
                    i = vs.pos;
                }
                i = this.checkNext(i, s2, val, type);
                return i;
            }
        } else {
            throw new ParseException("Unexpected character: " + c, i);
        }
        this.addToSet(val, -1, -1, type);
        return i;
    }

    private void checkIncrementRange(int incr, int type, int idxPos) throws ParseException {
        if (incr > 59 && (type == 0 || type == 1)) {
            throw new ParseException("Increment > 60 : " + incr, idxPos);
        }
        if (incr > 23 && type == 2) {
            throw new ParseException("Increment > 24 : " + incr, idxPos);
        }
        if (incr > 31 && type == 3) {
            throw new ParseException("Increment > 31 : " + incr, idxPos);
        }
        if (incr > 7 && type == 5) {
            throw new ParseException("Increment > 7 : " + incr, idxPos);
        }
        if (incr > 12 && type == 4) {
            throw new ParseException("Increment > 12 : " + incr, idxPos);
        }
    }

    protected int checkNext(int pos, String s2, int val, int type) throws ParseException {
        int end = -1;
        int i = pos;
        if (i >= s2.length()) {
            this.addToSet(val, end, -1, type);
            return i;
        }
        char c = s2.charAt(pos);
        if (c == 'L') {
            if (type == 5) {
                if (val < 1 || val > 7) {
                    throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
                }
            } else {
                throw new ParseException("'L' option is not valid here. (pos=" + i + ")", i);
            }
            this.lastDayOfWeek = true;
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == 'W') {
            if (type != 3) {
                throw new ParseException("'W' option is not valid here. (pos=" + i + ")", i);
            }
            if (val > 31) {
                throw new ParseException("The 'W' option does not make sense with values larger than 31 (max number of days in a month)", i);
            }
            this.nearestWeekdays.add(val);
            return ++i;
        }
        if (c == '#') {
            if (type != 5) {
                throw new ParseException("'#' option is not valid here. (pos=" + i + ")", i);
            }
            ++i;
            try {
                this.nthDayOfWeek = Integer.parseInt(s2.substring(i));
                if (this.nthDayOfWeek < 1 || this.nthDayOfWeek > 5) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                throw new ParseException("A numeric value between 1 and 5 must follow the '#' option", i);
            }
            TreeSet<Integer> set = this.getSet(type);
            set.add(val);
            return ++i;
        }
        if (c == '-') {
            int v;
            c = s2.charAt(++i);
            end = v = Integer.parseInt(String.valueOf(c));
            if (++i >= s2.length()) {
                this.addToSet(val, end, 1, type);
                return i;
            }
            c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v, s2, i);
                end = vs.value;
                i = vs.pos;
            }
            if (i < s2.length() && (c = s2.charAt(i)) == '/') {
                c = s2.charAt(++i);
                int v2 = Integer.parseInt(String.valueOf(c));
                if (++i >= s2.length()) {
                    this.addToSet(val, end, v2, type);
                    return i;
                }
                c = s2.charAt(i);
                if (c >= '0' && c <= '9') {
                    ValueSet vs = this.getValue(v2, s2, i);
                    int v3 = vs.value;
                    this.addToSet(val, end, v3, type);
                    i = vs.pos;
                    return i;
                }
                this.addToSet(val, end, v2, type);
                return i;
            }
            this.addToSet(val, end, 1, type);
            return i;
        }
        if (c == '/') {
            if (i + 1 >= s2.length() || s2.charAt(i + 1) == ' ' || s2.charAt(i + 1) == '\t') {
                throw new ParseException("'/' must be followed by an integer.", i);
            }
            c = s2.charAt(++i);
            int v2 = Integer.parseInt(String.valueOf(c));
            if (++i >= s2.length()) {
                this.checkIncrementRange(v2, type, i);
                this.addToSet(val, end, v2, type);
                return i;
            }
            c = s2.charAt(i);
            if (c >= '0' && c <= '9') {
                ValueSet vs = this.getValue(v2, s2, i);
                int v3 = vs.value;
                this.checkIncrementRange(v3, type, i);
                this.addToSet(val, end, v3, type);
                i = vs.pos;
                return i;
            }
            throw new ParseException("Unexpected character '" + c + "' after '/'", i);
        }
        this.addToSet(val, end, 0, type);
        return ++i;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getExpressionSummary() {
        StringBuilder buf = new StringBuilder();
        buf.append("seconds: ");
        buf.append(this.getExpressionSetSummary(this.seconds));
        buf.append("\n");
        buf.append("minutes: ");
        buf.append(this.getExpressionSetSummary(this.minutes));
        buf.append("\n");
        buf.append("hours: ");
        buf.append(this.getExpressionSetSummary(this.hours));
        buf.append("\n");
        buf.append("daysOfMonth: ");
        buf.append(this.getExpressionSetSummary(this.daysOfMonth));
        buf.append("\n");
        buf.append("nearestWeekdays: ");
        buf.append(this.getExpressionSetSummary(this.nearestWeekdays));
        buf.append("\n");
        buf.append("months: ");
        buf.append(this.getExpressionSetSummary(this.months));
        buf.append("\n");
        buf.append("daysOfWeek: ");
        buf.append(this.getExpressionSetSummary(this.daysOfWeek));
        buf.append("\n");
        buf.append("lastDayOfWeek: ");
        buf.append(this.lastDayOfWeek);
        buf.append("\n");
        buf.append("NthDayOfWeek: ");
        buf.append(this.nthDayOfWeek);
        buf.append("\n");
        buf.append("years: ");
        buf.append(this.getExpressionSetSummary(this.years));
        buf.append("\n");
        return buf.toString();
    }

    protected String getExpressionSetSummary(Set<Integer> set) {
        if (set.contains(NO_SPEC)) {
            return "?";
        }
        if (set.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = set.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected String getExpressionSetSummary(ArrayList<Integer> list) {
        if (list.contains(NO_SPEC)) {
            return "?";
        }
        if (list.contains(ALL_SPEC)) {
            return "*";
        }
        StringBuilder buf = new StringBuilder();
        Iterator<Integer> itr = list.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            Integer iVal = itr.next();
            String val = iVal.toString();
            if (!first) {
                buf.append(",");
            }
            buf.append(val);
            first = false;
        }
        return buf.toString();
    }

    protected int skipWhiteSpace(int i, String s2) {
        while (i < s2.length() && (s2.charAt(i) == ' ' || s2.charAt(i) == '\t')) {
            ++i;
        }
        return i;
    }

    protected int findNextWhiteSpace(int i, String s2) {
        while (i < s2.length() && (s2.charAt(i) != ' ' || s2.charAt(i) != '\t')) {
            ++i;
        }
        return i;
    }

    protected void addToSet(int val, int end, int incr, int type) throws ParseException {
        TreeSet<Integer> set = this.getSet(type);
        if (type == 0 || type == 1) {
            if ((val < 0 || val > 59 || end > 59) && val != 99) {
                throw new ParseException("Minute and Second values must be between 0 and 59", -1);
            }
        } else if (type == 2) {
            if ((val < 0 || val > 23 || end > 23) && val != 99) {
                throw new ParseException("Hour values must be between 0 and 23", -1);
            }
        } else if (type == 3) {
            if ((val < 1 || val > 31 || end > 31) && val != 99 && val != 98) {
                throw new ParseException("Day of month values must be between 1 and 31", -1);
            }
        } else if (type == 4) {
            if ((val < 1 || val > 12 || end > 12) && val != 99) {
                throw new ParseException("Month values must be between 1 and 12", -1);
            }
        } else if (type == 5 && (val == 0 || val > 7 || end > 7) && val != 99 && val != 98) {
            throw new ParseException("Day-of-Week values must be between 1 and 7", -1);
        }
        if ((incr == 0 || incr == -1) && val != 99) {
            if (val != -1) {
                set.add(val);
            } else {
                set.add(NO_SPEC);
            }
            return;
        }
        int startAt = val;
        int stopAt = end;
        if (val == 99 && incr <= 0) {
            incr = 1;
            set.add(ALL_SPEC);
        }
        if (type == 0 || type == 1) {
            if (stopAt == -1) {
                stopAt = 59;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 2) {
            if (stopAt == -1) {
                stopAt = 23;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 0;
            }
        } else if (type == 3) {
            if (stopAt == -1) {
                stopAt = 31;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 4) {
            if (stopAt == -1) {
                stopAt = 12;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 5) {
            if (stopAt == -1) {
                stopAt = 7;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1;
            }
        } else if (type == 6) {
            if (stopAt == -1) {
                stopAt = MAX_YEAR;
            }
            if (startAt == -1 || startAt == 99) {
                startAt = 1970;
            }
        }
        int max = -1;
        if (stopAt < startAt) {
            switch (type) {
                case 0: {
                    max = 60;
                    break;
                }
                case 1: {
                    max = 60;
                    break;
                }
                case 2: {
                    max = 24;
                    break;
                }
                case 4: {
                    max = 12;
                    break;
                }
                case 5: {
                    max = 7;
                    break;
                }
                case 3: {
                    max = 31;
                    break;
                }
                case 6: {
                    throw new IllegalArgumentException("Start year must be less than stop year");
                }
                default: {
                    throw new IllegalArgumentException("Unexpected type encountered");
                }
            }
            stopAt += max;
        }
        for (int i = startAt; i <= stopAt; i += incr) {
            if (max == -1) {
                set.add(i);
                continue;
            }
            int i2 = i % max;
            if (i2 == 0 && (type == 4 || type == 5 || type == 3)) {
                i2 = max;
            }
            set.add(i2);
        }
    }

    TreeSet<Integer> getSet(int type) {
        switch (type) {
            case 0: {
                return this.seconds;
            }
            case 1: {
                return this.minutes;
            }
            case 2: {
                return this.hours;
            }
            case 3: {
                return this.daysOfMonth;
            }
            case 4: {
                return this.months;
            }
            case 5: {
                return this.daysOfWeek;
            }
            case 6: {
                return this.years;
            }
        }
        return null;
    }

    protected ValueSet getValue(int v, String s2, int i) {
        char c = s2.charAt(i);
        StringBuilder s1 = new StringBuilder(String.valueOf(v));
        while (c >= '0' && c <= '9') {
            s1.append(c);
            if (++i >= s2.length()) break;
            c = s2.charAt(i);
        }
        ValueSet val = new ValueSet();
        val.pos = i < s2.length() ? i : i + 1;
        val.value = Integer.parseInt(s1.toString());
        return val;
    }

    protected int getNumericValue(String s2, int i) {
        int endOfVal = this.findNextWhiteSpace(i, s2);
        String val = s2.substring(i, endOfVal);
        return Integer.parseInt(val);
    }

    protected int getMonthNumber(String s2) {
        Integer integer = monthMap.get(s2);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    protected int getDayOfWeekNumber(String s2) {
        Integer integer = dayMap.get(s2);
        if (integer == null) {
            return -1;
        }
        return integer;
    }

    public Date getTimeAfter(Date afterTime) {
        GregorianCalendar cl = new GregorianCalendar(this.getTimeZone());
        afterTime = new Date(afterTime.getTime() + 1000L);
        cl.setTime(afterTime);
        cl.set(14, 0);
        boolean gotOne = false;
        while (!gotOne) {
            boolean dayOfWSpec;
            if (cl.get(1) > 2999) {
                return null;
            }
            SortedSet<Integer> st = null;
            int t2 = 0;
            int sec = cl.get(13);
            int min2 = cl.get(12);
            st = this.seconds.tailSet(sec);
            if (st != null && !st.isEmpty()) {
                sec = st.first();
            } else {
                sec = this.seconds.first();
                cl.set(12, ++min2);
            }
            cl.set(13, sec);
            min2 = cl.get(12);
            int hr = cl.get(11);
            t2 = -1;
            st = this.minutes.tailSet(min2);
            if (st != null && !st.isEmpty()) {
                t2 = min2;
                min2 = st.first();
            } else {
                min2 = this.minutes.first();
                ++hr;
            }
            if (min2 != t2) {
                cl.set(13, 0);
                cl.set(12, min2);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(12, min2);
            hr = cl.get(11);
            int day = cl.get(5);
            t2 = -1;
            st = this.hours.tailSet(hr);
            if (st != null && !st.isEmpty()) {
                t2 = hr;
                hr = st.first();
            } else {
                hr = this.hours.first();
                ++day;
            }
            if (hr != t2) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(5, day);
                this.setCalendarHour(cl, hr);
                continue;
            }
            cl.set(11, hr);
            day = cl.get(5);
            int mon = cl.get(2) + 1;
            t2 = -1;
            int tmon = mon;
            boolean dayOfMSpec = !this.daysOfMonth.contains(NO_SPEC);
            boolean bl = dayOfWSpec = !this.daysOfWeek.contains(NO_SPEC);
            if (dayOfMSpec && !dayOfWSpec) {
                Optional<Integer> smallestDay = this.findSmallestDay(day, mon, cl.get(1), this.daysOfMonth);
                Optional<Integer> smallestDayForWeekday = this.findSmallestDay(day, mon, cl.get(1), this.nearestWeekdays);
                t2 = day;
                day = -1;
                if (smallestDayForWeekday.isPresent()) {
                    day = smallestDayForWeekday.get();
                    Calendar tcal = Calendar.getInstance(this.getTimeZone());
                    tcal.set(13, 0);
                    tcal.set(12, 0);
                    tcal.set(11, 0);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    tcal.set(1, cl.get(1));
                    int ldom = this.getLastDayOfMonth(mon, cl.get(1));
                    int dow = tcal.get(7);
                    if (dow == 7 && day == 1) {
                        day += 2;
                    } else if (dow == 7) {
                        --day;
                    } else if (dow == 1 && day == ldom) {
                        day -= 2;
                    } else if (dow == 1) {
                        ++day;
                    }
                    tcal.set(13, sec);
                    tcal.set(12, min2);
                    tcal.set(11, hr);
                    tcal.set(5, day);
                    tcal.set(2, mon - 1);
                    Date nTime = tcal.getTime();
                    if (nTime.before(afterTime)) {
                        day = -1;
                    }
                }
                if (smallestDay.isPresent()) {
                    if (day == -1 || smallestDay.get() < day) {
                        day = smallestDay.get();
                    }
                } else if (day == -1) {
                    day = 1;
                    ++mon;
                }
                if (day != t2 || mon != tmon) {
                    cl.set(13, 0);
                    cl.set(12, 0);
                    cl.set(11, 0);
                    cl.set(5, day);
                    cl.set(2, mon - 1);
                    continue;
                }
            } else if (dayOfWSpec && !dayOfMSpec) {
                int lDay;
                if (this.lastDayOfWeek) {
                    int dow = this.daysOfWeek.first();
                    int cDow = cl.get(7);
                    int daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    while (day + daysToAdd + 7 <= lDay) {
                        daysToAdd += 7;
                    }
                    day += daysToAdd;
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else if (this.nthDayOfWeek != 0) {
                    int dow = this.daysOfWeek.first();
                    int cDow = cl.get(7);
                    int daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    } else if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    boolean dayShifted = daysToAdd > 0;
                    int weekOfMonth = (day += daysToAdd) / 7;
                    if (day % 7 > 0) {
                        ++weekOfMonth;
                    }
                    if ((daysToAdd = (this.nthDayOfWeek - weekOfMonth) * 7) < 0 || (day += daysToAdd) > this.getLastDayOfMonth(mon, cl.get(1))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0 || dayShifted) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day);
                        cl.set(2, mon - 1);
                        continue;
                    }
                } else {
                    int cDow = cl.get(7);
                    int dow = this.daysOfWeek.first();
                    st = this.daysOfWeek.tailSet(cDow);
                    if (st != null && !st.isEmpty()) {
                        dow = st.first();
                    }
                    int daysToAdd = 0;
                    if (cDow < dow) {
                        daysToAdd = dow - cDow;
                    }
                    if (cDow > dow) {
                        daysToAdd = dow + (7 - cDow);
                    }
                    if (day + daysToAdd > (lDay = this.getLastDayOfMonth(mon, cl.get(1)))) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, 1);
                        cl.set(2, mon);
                        continue;
                    }
                    if (daysToAdd > 0) {
                        cl.set(13, 0);
                        cl.set(12, 0);
                        cl.set(11, 0);
                        cl.set(5, day + daysToAdd);
                        cl.set(2, mon - 1);
                        continue;
                    }
                }
            } else {
                throw new UnsupportedOperationException("Support for specifying both a day-of-week AND a day-of-month parameter is not implemented.");
            }
            cl.set(5, day);
            mon = cl.get(2) + 1;
            int year = cl.get(1);
            t2 = -1;
            if (year > MAX_YEAR) {
                return null;
            }
            st = this.months.tailSet(mon);
            if (st != null && !st.isEmpty()) {
                t2 = mon;
                mon = st.first();
            } else {
                mon = this.months.first();
                ++year;
            }
            if (mon != t2) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, mon - 1);
                cl.set(1, year);
                continue;
            }
            cl.set(2, mon - 1);
            year = cl.get(1);
            t2 = -1;
            st = this.years.tailSet(year);
            if (st == null || st.isEmpty()) {
                return null;
            }
            t2 = year;
            year = st.first();
            if (year != t2) {
                cl.set(13, 0);
                cl.set(12, 0);
                cl.set(11, 0);
                cl.set(5, 1);
                cl.set(2, 0);
                cl.set(1, year);
                continue;
            }
            cl.set(1, year);
            gotOne = true;
        }
        return cl.getTime();
    }

    protected void setCalendarHour(Calendar cal, int hour) {
        cal.set(11, hour);
        if (cal.get(11) != hour && hour != 24) {
            cal.set(11, hour + 1);
        }
    }

    public Date getTimeBefore(Date endTime) {
        return null;
    }

    public Date getFinalFireTime() {
        return null;
    }

    protected boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    protected int getLastDayOfMonth(int monthNum, int year) {
        switch (monthNum) {
            case 1: {
                return 31;
            }
            case 2: {
                return this.isLeapYear(year) ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Illegal month number: " + monthNum);
    }

    private Optional<Integer> findSmallestDay(int day, int mon, int year, TreeSet<Integer> set) {
        if (set.isEmpty()) {
            return Optional.empty();
        }
        int lastDay = this.getLastDayOfMonth(mon, year);
        int smallestDay = Optional.ofNullable(set.ceiling(62 - (lastDay - day))).map(d -> d - 32 + 1).orElse(Integer.MAX_VALUE);
        SortedSet<Integer> st = set.subSet(day, 32);
        if (!st.isEmpty() && st.first() < smallestDay && st.first() <= lastDay) {
            smallestDay = st.first();
        }
        return smallestDay == Integer.MAX_VALUE ? Optional.empty() : Optional.of(smallestDay);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.buildExpression(this.cronExpression);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Deprecated
    public Object clone() {
        return new CronExpression(this);
    }

    static {
        monthMap.put("JAN", 0);
        monthMap.put("FEB", 1);
        monthMap.put("MAR", 2);
        monthMap.put("APR", 3);
        monthMap.put("MAY", 4);
        monthMap.put("JUN", 5);
        monthMap.put("JUL", 6);
        monthMap.put("AUG", 7);
        monthMap.put("SEP", 8);
        monthMap.put("OCT", 9);
        monthMap.put("NOV", 10);
        monthMap.put("DEC", 11);
        dayMap.put("SUN", 1);
        dayMap.put("MON", 2);
        dayMap.put("TUE", 3);
        dayMap.put("WED", 4);
        dayMap.put("THU", 5);
        dayMap.put("FRI", 6);
        dayMap.put("SAT", 7);
        MAX_YEAR = Calendar.getInstance().get(1) + 100;
    }
}

