/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.sis.system.DelayedExecutor;
import org.apache.sis.system.DelayedRunnable;
import org.apache.sis.system.Reflect;
import org.apache.sis.system.SystemListener;

public abstract class TypeRegistration {
    public static final String ROOT_ADAPTERS = "org.apache.sis.xml.rootAdapters";
    private static Reference<JAXBContext> context;
    private static UnaryOperator<Object>[] converters;
    private static ServiceLoader<TypeRegistration> services;

    protected TypeRegistration() {
    }

    protected abstract void getTypes(Collection<Class<?>> var1);

    protected UnaryOperator<Object> beforeMarshal() {
        return null;
    }

    protected Optional<InputStream> getRenameDefinitionsFile(boolean export, String filename) {
        return Optional.empty();
    }

    public static synchronized Supplier<InputStream> getRenameDefinitionsFiles(boolean export, String filename) {
        Iterator<TypeRegistration> services = TypeRegistration.services().iterator();
        return () -> {
            Class<TypeRegistration> clazz = TypeRegistration.class;
            synchronized (TypeRegistration.class) {
                while (services.hasNext()) {
                    Optional<InputStream> next = ((TypeRegistration)services.next()).getRenameDefinitionsFile(export, filename);
                    if (!next.isPresent()) continue;
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return next.get();
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
        };
    }

    private static ServiceLoader<TypeRegistration> services() {
        ServiceLoader<TypeRegistration> s2 = services;
        if (s2 == null) {
            services = s2 = ServiceLoader.load(TypeRegistration.class, Reflect.getContextClassLoader());
            DelayedExecutor.schedule(new DelayedRunnable(1, TimeUnit.MINUTES){

                @Override
                public void run() {
                    services = null;
                }
            });
        }
        return s2;
    }

    private static Class<?>[] load(boolean getTypes) {
        ArrayList types = new ArrayList();
        ArrayList<UnaryOperator<Object>> toImpl = new ArrayList<UnaryOperator<Object>>();
        for (TypeRegistration t2 : TypeRegistration.services()) {
            UnaryOperator<Object> c;
            if (getTypes) {
                t2.getTypes(types);
            }
            if ((c = t2.beforeMarshal()) == null) continue;
            toImpl.add(c);
        }
        converters = (UnaryOperator[])toImpl.toArray(UnaryOperator[]::new);
        return (Class[])types.toArray(Class[]::new);
    }

    public static synchronized JAXBContext getSharedContext() throws JAXBException {
        JAXBContext instance;
        Reference<JAXBContext> c = context;
        if (c != null && (instance = c.get()) != null) {
            return instance;
        }
        instance = JAXBContext.newInstance(TypeRegistration.load(true));
        context = new WeakReference<JAXBContext>(instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ?> getPrivateInfo(Map<String, ?> properties) {
        if (properties != null && properties.containsKey(ROOT_ADAPTERS)) {
            return properties;
        }
        Class<TypeRegistration> clazz = TypeRegistration.class;
        synchronized (TypeRegistration.class) {
            UnaryOperator<Object>[] c = converters;
            if (c == null) {
                TypeRegistration.load(false);
                c = converters;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (properties == null) {
                return Map.of(ROOT_ADAPTERS, c);
            }
            HashMap copy = new HashMap(properties);
            copy.put(ROOT_ADAPTERS, c);
            return copy;
        }
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.util"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void classpathChanged() {
                Class<TypeRegistration> clazz = TypeRegistration.class;
                synchronized (TypeRegistration.class) {
                    context = null;
                    converters = null;
                    services = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }
}

