/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.ucar;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Set;
import org.apache.sis.setup.GeometryLibrary;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.netcdf.base.Convention;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.DiscreteSampling;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.Variable;
import org.apache.sis.storage.netcdf.ucar.DimensionWrapper;
import org.apache.sis.storage.netcdf.ucar.FeaturesWrapper;
import org.apache.sis.storage.netcdf.ucar.GridWrapper;
import org.apache.sis.storage.netcdf.ucar.GroupWrapper;
import org.apache.sis.storage.netcdf.ucar.LogAdapter;
import org.apache.sis.storage.netcdf.ucar.Utils;
import org.apache.sis.storage.netcdf.ucar.VariableWrapper;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.units.UnitException;

public final class DecoderWrapper
extends Decoder
implements CancelTask {
    private final NetcdfFile file;
    private Group[] groups;
    private transient VariableWrapper[] variables;
    private transient FeatureDataset features;
    private transient Grid[] geometries;
    private boolean done;

    public DecoderWrapper(NetcdfFile file, GeometryLibrary geomlib, StoreListeners listeners) {
        super(geomlib, listeners);
        this.file = file;
        this.groups = new Group[1];
        this.initialize();
    }

    public DecoderWrapper(String filename, GeometryLibrary geomlib, StoreListeners listeners) throws IOException {
        super(geomlib, listeners);
        DatasetUrl url = DatasetUrl.findDatasetUrl((String)filename);
        this.file = NetcdfDatasets.openDataset((DatasetUrl)url, Set.of(NetcdfDataset.Enhance.CoordSystems), (int)-1, (CancelTask)this, null);
        this.groups = new Group[1];
        this.initialize();
    }

    @Override
    public String getFilename() {
        String filename = Utils.nonEmpty(this.file.getLocation());
        if (filename != null) {
            int s2 = filename.lastIndexOf(File.separatorChar);
            if (s2 < 0 && File.separatorChar != '/') {
                s2 = filename.lastIndexOf(47);
            }
            if (s2 >= 0) {
                filename = filename.substring(s2 + 1);
            }
        }
        return filename;
    }

    @Override
    public String[] getFormatDescription() {
        String version = Utils.nonEmpty(this.file.getFileTypeVersion());
        String[] format = new String[version != null ? 3 : 2];
        switch (format.length) {
            default: {
                format[2] = version;
            }
            case 2: {
                format[1] = this.file.getFileTypeDescription();
            }
            case 1: {
                format[0] = this.file.getFileTypeId();
            }
            case 0: 
        }
        return format;
    }

    @Override
    public void setSearchPath(String ... groupNames) {
        Group[] groups = new Group[groupNames.length];
        int count = 0;
        for (String name : groupNames) {
            if (name != null) {
                Group group = this.file.findGroup(name);
                if (group == null) continue;
                groups[count] = group;
            }
            ++count;
        }
        this.groups = ArraysExt.resize(groups, count);
    }

    @Override
    public String[] getSearchPath() {
        String[] path = new String[this.groups.length];
        for (int i = 0; i < path.length; ++i) {
            Group group = this.groups[i];
            if (group == null) continue;
            path[i] = group.getShortName();
        }
        return path;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return VariableWrapper.toNames(this.file.getGlobalAttributes());
    }

    private Attribute findAttribute(Group group, String name) {
        String mappedName;
        int index = 0;
        Convention convention = this.convention();
        while ((mappedName = convention.mapAttributeName(name, index++)) != null) {
            Attribute value = group != null ? group.attributes().findAttributeIgnoreCase(mappedName) : this.file.findGlobalAttributeIgnoreCase(mappedName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public String stringValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null || !attribute.isString()) continue;
                return Utils.nonEmpty(attribute.getStringValue());
            }
        }
        return null;
    }

    @Override
    public Number numericValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null) continue;
                Number value = attribute.getNumericValue();
                if (value != null) {
                    return Utils.fixSign(value, attribute.getDataType().isUnsigned());
                }
                String asString = Utils.nonEmpty(attribute.getStringValue());
                if (asString == null) continue;
                return this.parseNumber(name, asString);
            }
        }
        return null;
    }

    @Override
    public Date dateValue(String name) {
        if (name != null) {
            for (Group group : this.groups) {
                CalendarDate date;
                String value;
                Attribute attribute = this.findAttribute(group, name);
                if (attribute == null || !attribute.isString() || (value = Utils.nonEmpty(attribute.getStringValue())) == null) continue;
                try {
                    date = CalendarDateFormatter.isoStringToCalendarDate(Calendar.proleptic_gregorian, value);
                }
                catch (IllegalArgumentException e) {
                    this.listeners.warning(e);
                    continue;
                }
                return new Date(date.getMillis());
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String symbol, Number ... values) {
        DateUnit unit;
        Date[] dates = new Date[values.length];
        try {
            unit = new DateUnit(symbol);
        }
        catch (UnitException e) {
            this.listeners.warning(e);
            return dates;
        }
        for (int i = 0; i < values.length; ++i) {
            Number value = values[i];
            if (value == null) continue;
            dates[i] = unit.makeDate(value.doubleValue());
        }
        return dates;
    }

    @Override
    public String getId() {
        return Utils.nonEmpty(this.file.getId());
    }

    @Override
    public String getTitle() {
        return Utils.nonEmpty(this.file.getTitle());
    }

    @Override
    public Variable[] getVariables() {
        if (this.variables == null) {
            ImmutableList all = this.file.getVariables();
            this.variables = new VariableWrapper[all != null ? all.size() : 0];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = new VariableWrapper(this, (ucar.nc2.Variable)all.get(i));
            }
        }
        return this.variables;
    }

    final VariableWrapper getWrapperFor(ucar.nc2.Variable variable) {
        for (VariableWrapper c : (VariableWrapper[])this.getVariables()) {
            if (!c.isWrapperFor(variable)) continue;
            return c;
        }
        return new VariableWrapper(this, variable);
    }

    private FeatureDataset getFeatureDataSet() throws IOException {
        if (this.features == null && this.file instanceof NetcdfDataset) {
            this.features = FeatureDatasetFactoryManager.wrap(null, (NetcdfDataset)this.file, this, new Formatter(new LogAdapter(this.listeners), this.listeners.getLocale()));
        }
        return this.features;
    }

    @Override
    public DiscreteSampling[] getDiscreteSampling(DataStore lock) throws IOException, DataStoreException {
        List<FeatureCollection> fc;
        FeatureDataset features = this.getFeatureDataSet();
        if (features instanceof FeatureDatasetPoint && (fc = ((FeatureDatasetPoint)features).getPointFeatureCollectionList()) != null && !fc.isEmpty()) {
            DiscreteSampling[] wrappers = new FeaturesWrapper[fc.size()];
            try {
                for (int i = 0; i < wrappers.length; ++i) {
                    wrappers[i] = new FeaturesWrapper((DsgFeatureCollection)fc.get(i), this.geomlib, this.listeners, lock);
                }
            }
            catch (IllegalArgumentException e) {
                throw new DataStoreException(e.getLocalizedMessage(), e);
            }
            return wrappers;
        }
        return super.getDiscreteSampling(lock);
    }

    @Override
    public Grid[] getGridCandidates() throws IOException {
        if (this.geometries == null) {
            ImmutableList systems = List.of();
            if (this.file instanceof NetcdfDataset) {
                NetcdfDataset ds = (NetcdfDataset)this.file;
                systems = ds.getCoordinateSystems();
            }
            this.geometries = (Grid[])systems.stream().map(GridWrapper::new).toArray(Grid[]::new);
        }
        return this.geometries;
    }

    @Override
    protected Dimension findDimension(String dimName) {
        ucar.nc2.Dimension dimension = this.file.findDimension(dimName);
        return dimension != null ? new DimensionWrapper(dimension, -1) : null;
    }

    @Override
    protected Variable findVariable(String name) {
        ucar.nc2.Variable v = this.file.findVariable(name);
        return v != null ? this.getWrapperFor(v) : null;
    }

    @Override
    protected Node findNode(String name) {
        ucar.nc2.Variable v = this.file.findVariable(name);
        if (v != null) {
            return this.getWrapperFor(v);
        }
        Group group = this.file.findGroup(name);
        return group != null ? new GroupWrapper(this, group) : null;
    }

    @Override
    public void addAttributesTo(TreeTable.Node root) {
        this.addAttributesTo(root, this.file.getRootGroup());
    }

    private void addAttributesTo(TreeTable.Node branch, Group group) {
        TreeTable.Node node;
        for (Group sub : group.getGroups()) {
            node = branch.newChild();
            node.setValue(TableColumn.NAME, sub.getShortName());
            this.addAttributesTo(node, sub);
        }
        for (ucar.nc2.Variable variable : group.getVariables()) {
            node = branch.newChild();
            node.setValue(TableColumn.NAME, variable.getShortName());
            DecoderWrapper.addAttributesTo(node, (Iterable<Attribute>)((Object)variable.attributes()));
        }
        DecoderWrapper.addAttributesTo(branch, (Iterable<Attribute>)((Object)group.attributes()));
    }

    private static void addAttributesTo(TreeTable.Node branch, Iterable<Attribute> attributes) {
        if (attributes != null) {
            block4: for (Attribute attribute : attributes) {
                Object[] value;
                TreeTable.Node node = branch.newChild();
                node.setValue(TableColumn.NAME, attribute.getShortName());
                int length = attribute.getLength();
                switch (length) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        value = attribute.getValue(0);
                        break;
                    }
                    default: {
                        Object[] values = new Object[length];
                        for (int i = 0; i < length; ++i) {
                            values[i] = attribute.getValue(i);
                        }
                        value = values;
                        break;
                    }
                }
                node.setValue(TableColumn.VALUE, value);
            }
        }
    }

    @Override
    public boolean isCancel() {
        return this.canceled;
    }

    @Override
    public void setProgress(String message, int progress) {
    }

    @Override
    public void setError(String message) {
        this.listeners.warning(message);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(DataStore lock) throws IOException {
        DataStore dataStore = lock;
        synchronized (dataStore) {
            if (this.features != null) {
                this.features.close();
                this.features = null;
            }
            this.file.close();
        }
    }

    public String toString() {
        return "UCAR driver: \u201c" + this.getFilename() + "\u201d";
    }
}

