/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.netcdf.base;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.TransferFunction;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.InternalDataStoreException;
import org.apache.sis.storage.netcdf.base.Convention;
import org.apache.sis.storage.netcdf.base.DataType;
import org.apache.sis.storage.netcdf.base.Decoder;
import org.apache.sis.storage.netcdf.base.Dimension;
import org.apache.sis.storage.netcdf.base.Grid;
import org.apache.sis.storage.netcdf.base.GridAdjustment;
import org.apache.sis.storage.netcdf.base.GridMapping;
import org.apache.sis.storage.netcdf.base.Node;
import org.apache.sis.storage.netcdf.base.VariableRole;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.opengis.referencing.operation.Matrix;

public abstract class Variable
extends Node {
    private static final WeakHashSet<Vector> SHARED_VECTORS = new WeakHashSet<Vector>(Vector.class);
    public static final Pattern TIME_UNIT_PATTERN = Pattern.compile("(.+)\\Wsince\\W(.+)", 2);
    protected static final int STRING_DIMENSION = 2;
    private VariableRole role;
    private Unit<?> unit;
    protected Instant epoch;
    private boolean unitParsed;
    private Map<Number, Object> nodataValues;
    private Map<Integer, String> enumeration;
    private GridGeometry gridGeometry;
    private boolean gridDetermined;
    int bandDimension;
    private transient Vector values;
    private transient List<?> valuesAnyType;

    protected Variable(Decoder decoder) {
        super(decoder);
    }

    protected final void setEnumeration(Map<Integer, String> enumeration) {
        if (enumeration == null) {
            String srcLabels = "flag_names";
            CharSequence[] labels = this.getAttributeAsStrings("flag_names", ' ');
            if (labels == null) {
                srcLabels = "flag_meanings";
                labels = this.getAttributeAsStrings("flag_meanings", ' ');
                if (labels == null) {
                    return;
                }
            }
            String srcNumbers = "flag_values";
            Vector numbers = this.getAttributeAsVector("flag_values");
            if (numbers == null) {
                srcNumbers = "flag_masks";
                numbers = this.getAttributeAsVector("flag_masks");
            }
            int count = labels.length;
            if (numbers != null) {
                int n2 = numbers.size();
                if (n2 != count) {
                    this.warning(Variable.class, "setEnumeration", (short)24, this.getName(), srcNumbers, srcLabels, n2, count);
                    if (n2 < count) {
                        count = n2;
                    }
                }
            } else {
                numbers = Vector.createSequence(0, 1, count);
                this.warning(Variable.class, "setEnumeration", (short)23, this.getFilename(), this.getName(), "flag_values");
            }
            RuntimeException error = null;
            StringBuilder invalids = null;
            enumeration = new HashMap<Integer, String>(Containers.hashMapCapacity(count));
            for (int i = 0; i < count; ++i) {
                try {
                    CharSequence label = labels[i];
                    if (label == null) continue;
                    enumeration.merge(numbers.intValue(i), label.toString(), (o, n) -> o.equals(n) ? o : o + " | " + n);
                    continue;
                }
                catch (ArithmeticException | NumberFormatException e) {
                    if (error == null) {
                        error = e;
                        invalids = new StringBuilder();
                    } else {
                        boolean tooManyErrors;
                        int length = invalids.length();
                        boolean bl = tooManyErrors = length > 100;
                        if (tooManyErrors && invalids.charAt(length - 1) == '\u2026') continue;
                        error.addSuppressed(e);
                        invalids.append(", ");
                        if (tooManyErrors) {
                            invalids.append('\u2026');
                            continue;
                        }
                    }
                    invalids.append(numbers.stringValue(i));
                }
            }
            if (invalids != null) {
                this.error(Variable.class, "setEnumeration", error, (short)8, invalids, numbers.getElementType());
            }
        }
        if (!enumeration.isEmpty()) {
            this.enumeration = enumeration;
        }
    }

    public String getFilename() {
        return this.decoder.getFilename();
    }

    @Override
    public abstract String getName();

    public final String getStandardName() {
        String name = this.getAttributeAsString("standard_name");
        return name != null ? name : this.getName();
    }

    public abstract String getDescription();

    protected abstract String getUnitsString();

    protected abstract Unit<?> parseUnit(String var1) throws Exception;

    final Instant setUnit(Variable other, Unit<?> overwrite) {
        if (other != null) {
            this.unit = other.getUnit();
            this.epoch = other.epoch;
        }
        if (overwrite != null) {
            this.unit = overwrite;
        }
        this.unitParsed = true;
        return this.epoch;
    }

    public final Unit<?> getUnit() {
        if (!this.unitParsed) {
            Exception error;
            String symbols;
            block10: {
                this.unitParsed = true;
                symbols = this.getUnitsString();
                error = null;
                if (symbols != null) {
                    try {
                        this.unit = this.parseUnit(symbols);
                    }
                    catch (Exception ex) {
                        error = ex;
                    }
                }
                if (this.unit == null) {
                    try {
                        this.unit = this.decoder.convention().getUnitFallback(this);
                    }
                    catch (MeasurementParseException ex) {
                        if (error == null) {
                            error = ex;
                        } else {
                            error.addSuppressed(ex);
                        }
                        if (symbols != null) break block10;
                        symbols = ex.getParsedString();
                    }
                }
            }
            if (error != null) {
                this.error(Variable.class, "getUnit", error, (short)183, this.getName(), symbols);
            }
        }
        return this.unit;
    }

    final boolean hasRealValues() {
        byte n = this.getDataType().number;
        if (n == 8 | n == 9) {
            Convention convention = this.decoder.convention();
            if (convention != Convention.DEFAULT) {
                return convention.transferFunction(this).isIdentity();
            }
            Number c = this.getAttributeAsNumber("scale_factor");
            if (c == null || c.doubleValue() == 1.0) {
                c = this.getAttributeAsNumber("add_offset");
                return c == null || c.doubleValue() == 0.0;
            }
        }
        return false;
    }

    public abstract DataType getDataType();

    public final VariableRole getRole() {
        if (this.role == null) {
            String name = this.getName();
            for (Variable variable : this.decoder.getVariables()) {
                if (!name.equalsIgnoreCase(variable.getAttributeAsString("bounds"))) continue;
                this.role = VariableRole.BOUNDS;
                return this.role;
            }
            this.role = this.decoder.convention().roleOf(this);
        }
        return this.role;
    }

    final boolean isString() {
        return this.getDataType() == DataType.CHAR && this.getNumDimensions() >= 2;
    }

    protected abstract boolean isUnlimited();

    protected abstract boolean isCoordinateSystemAxis();

    protected abstract String getAxisType();

    protected Grid findGrid(GridAdjustment adjustment) throws IOException, DataStoreException {
        int i;
        Convention convention = this.decoder.convention();
        ArrayList<Variable> axes = new ArrayList<Variable>();
        HashMap<Object, Dimension> domain = new HashMap<Object, Dimension>();
        for (Variable candidate : this.decoder.getVariables()) {
            if (candidate.getRole() != VariableRole.AXIS) continue;
            axes.add(candidate);
            for (Dimension dim : candidate.getGridDimensions()) {
                domain.put(dim, dim);
            }
        }
        boolean isIncomplete = false;
        List<Dimension> fromVariable = this.getGridDimensions();
        Dimension[] dimensions = (Dimension[])fromVariable.toArray(Dimension[]::new);
        for (i = 0; i < dimensions.length; ++i) {
            dimensions[i] = (Dimension)domain.remove(dimensions[i]);
            isIncomplete |= dimensions[i] == null;
        }
        if (isIncomplete) {
            for (i = 0; i < dimensions.length; ++i) {
                Dimension gridDimension;
                if (dimensions[i] != null) continue;
                String label = convention.nameOfDimension(this, i);
                if (label == null) {
                    return null;
                }
                if (isIncomplete) {
                    isIncomplete = false;
                    if (adjustment.mapLabelToGridDimensions(this, axes, domain, convention)) {
                        return null;
                    }
                }
                Dimension varDimension = fromVariable.get(i);
                dimensions[i] = gridDimension = (Dimension)domain.remove(label);
                if (gridDimension == null) {
                    this.warning(Variable.class, "getGridGeometry", (short)15, this.getFilename(), this.getName(), label);
                    return null;
                }
                if (adjustment.gridToVariable.put(gridDimension, varDimension) == null) continue;
                throw new InternalDataStoreException(this.errors().getString((short)27, gridDimension));
            }
        }
        Grid fallback = null;
        boolean fallbackMatches = false;
        String[] axisNames = convention.namesOfAxisVariables(this);
        for (Grid candidate : this.decoder.getGridCandidates()) {
            Grid grid = candidate.forDimensions(dimensions);
            if (grid == null) continue;
            int gridDimension = grid.getSourceDimensions();
            boolean gridMatches = grid.containsAllNamedAxes(axisNames);
            if (gridMatches && gridDimension == dimensions.length) {
                return grid;
            }
            if (!(gridMatches | !fallbackMatches) || gridMatches == fallbackMatches && fallback != null && gridDimension <= fallback.getSourceDimensions()) continue;
            fallbackMatches = gridMatches;
            fallback = grid;
        }
        return fallback;
    }

    public final GridGeometry getGridGeometry() throws IOException, DataStoreException {
        if (!this.gridDetermined) {
            this.gridDetermined = true;
            GridMapping gridMapping = GridMapping.forVariable(this);
            GridAdjustment adjustment = new GridAdjustment();
            Grid info = this.findGrid(adjustment);
            if (info != null) {
                GridGeometry grid;
                List<Dimension> dimensions = this.getGridDimensions();
                int dataDimension = dimensions.size();
                if (dataDimension > info.getSourceDimensions()) {
                    boolean copied = false;
                    List<Dimension> toKeep = info.getDimensions();
                    int numToKeep = toKeep.size();
                    for (int i = 0; i < numToKeep; ++i) {
                        Dimension expected = toKeep.get(i);
                        expected = adjustment.gridToVariable.getOrDefault(expected, expected);
                        while (!expected.equals(dimensions.get(i))) {
                            if (!copied) {
                                copied = true;
                                dimensions = new ArrayList<Dimension>(dimensions);
                            }
                            this.bandDimension = dataDimension - 1 - i;
                            dimensions.remove(i);
                            int j = dimensions.size();
                            while (--j >= i) {
                                dimensions.set(j, dimensions.get(j).decrementIndex());
                            }
                            if (dimensions.size() >= numToKeep) continue;
                            throw new InternalDataStoreException();
                        }
                    }
                }
                if ((grid = info.getGridGeometry(this.decoder)) != null) {
                    if (grid.isDefined(4)) {
                        GridExtent extent = grid.getExtent();
                        long[] sizes = new long[extent.getDimension()];
                        boolean needsResize = false;
                        int i = sizes.length;
                        while (--i >= 0) {
                            int d = sizes.length - 1 - i;
                            sizes[i] = dimensions.get(d).length();
                            if (needsResize) continue;
                            needsResize = sizes[i] != extent.getSize(i);
                        }
                        if (needsResize) {
                            double[] dataToGridIndices = adjustment.dataToGridIndices();
                            if (dataToGridIndices == null || dataToGridIndices.length < sizes.length) {
                                this.warning(Variable.class, "getGridGeometry", (short)17, this.getFilename(), this.getName());
                                return null;
                            }
                            extent = extent.resize(sizes);
                            grid = GridAdjustment.scale(grid, extent, info.getAnchor(), dataToGridIndices);
                        }
                    }
                    if (gridMapping != null) {
                        grid = gridMapping.adaptGridCRS(this, grid, info.getAnchor());
                    }
                }
                this.gridGeometry = grid;
            } else if (gridMapping != null) {
                this.gridGeometry = gridMapping.createGridCRS(this);
            }
        }
        return this.gridGeometry;
    }

    final long getBandStride() throws IOException, DataStoreException {
        long length = 1L;
        GridExtent extent = this.getGridGeometry().getExtent();
        int i = this.bandDimension;
        while (--i >= 0) {
            length = Math.multiplyExact(length, extent.getSize(i));
        }
        return length;
    }

    public abstract int getNumDimensions();

    public abstract List<Dimension> getGridDimensions();

    final NumberRange<?> getValidRange() {
        NumberRange<?> range = this.decoder.convention().validRange(this);
        if (range == null) {
            range = this.getRangeFallback();
        }
        return range;
    }

    protected NumberRange<?> getRangeFallback() {
        int size;
        DataType dataType = this.getDataType();
        if (dataType.isInteger && (size = dataType.size() * 8) > 0 && size <= 64) {
            long min2 = 0L;
            long max = Numerics.bitmask(size) - 1L;
            if (!dataType.isUnsigned) {
                min2 = (max >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            for (Number value : this.getNodataValues().keySet()) {
                long n = value.longValue();
                long \u0394min = n - min2;
                long \u0394max = max - n;
                if (\u0394min < 0L || \u0394max < 0L) continue;
                if (\u0394min < \u0394max) {
                    min2 = n + 1L;
                    continue;
                }
                max = n - 1L;
            }
            if (max > min2) {
                if (min2 >= Integer.MIN_VALUE && max <= Integer.MAX_VALUE) {
                    return NumberRange.create((int)min2, true, (int)max, true);
                }
                return NumberRange.create(min2, true, max, true);
            }
        }
        return null;
    }

    final Map<Integer, String> getEnumeration() {
        return this.enumeration;
    }

    final Map<Number, Object> getNodataValues() {
        if (this.nodataValues == null) {
            this.nodataValues = CollectionsExt.unmodifiableOrCopy(this.decoder.convention().nodataValues(this));
        }
        return this.nodataValues;
    }

    final TransferFunction getTransferFunction() {
        return this.decoder.convention().transferFunction(this);
    }

    protected boolean isExternallyCached() {
        return false;
    }

    public final Vector read() throws IOException, DataStoreException {
        if (this.values == null) {
            this.setValues(this.readFully());
        }
        return this.values;
    }

    public final List<?> readAnyType() throws IOException, DataStoreException {
        if (this.valuesAnyType == null) {
            this.setValues(this.readFully());
        }
        return this.valuesAnyType;
    }

    public abstract Vector read(GridExtent var1, int[] var2) throws IOException, DataStoreException;

    public abstract List<?> readAnyType(GridExtent var1, int[] var2) throws IOException, DataStoreException;

    protected abstract Object readFully() throws IOException, DataStoreException;

    final void setValues(Object array) {
        int n;
        DataType dataType = this.getDataType();
        if (dataType == DataType.CHAR && (n = this.getNumDimensions()) >= 2) {
            List<Dimension> dimensions = this.getGridDimensions();
            int length = Math.toIntExact(dimensions.get(--n).length());
            long count = dimensions.get(--n).length();
            while (n > 0) {
                count = Math.multiplyExact(count, dimensions.get(--n).length());
            }
            String[] strings = this.createStringArray(array, Math.toIntExact(count), length);
            this.values = Vector.create(strings, false);
            this.valuesAnyType = UnmodifiableArrayList.wrap(strings);
            return;
        }
        Vector data = Variable.createDecimalVector(array, dataType.isUnsigned);
        if (!this.isExternallyCached()) {
            int n2;
            double tolerance = 0.0;
            if (Numbers.isFloat(data.getElementType()) && (n2 = data.size() - 1) >= 0) {
                double first = data.doubleValue(0);
                double last = data.doubleValue(n2);
                double inc = Math.abs((last - first) / (double)n2);
                if (!Double.isNaN(inc)) {
                    double ulp = Math.ulp(Math.max(Math.abs(first), Math.abs(last)));
                    tolerance = Math.min(inc, ulp);
                }
            }
            data = data.compress(tolerance);
        }
        this.valuesAnyType = this.values = SHARED_VECTORS.unique(data);
    }

    protected abstract String[] createStringArray(Object var1, int var2, int var3);

    protected final List<String> createStringList(Object chars, GridExtent area) {
        int length = Math.toIntExact(area.getSize(0));
        long count = area.getSize(1);
        int i = area.getDimension();
        while (--i >= 2) {
            count = Math.multiplyExact(count, area.getSize(i));
        }
        return UnmodifiableArrayList.wrap(this.createStringArray(chars, Math.toIntExact(count), length));
    }

    protected static Vector createDecimalVector(Object data, boolean isUnsigned) {
        if (data instanceof float[]) {
            return Vector.createForDecimal((float[])data);
        }
        return Vector.create(data, isUnsigned);
    }

    protected final void replaceNaN(Object array) {
        if (this.hasRealValues()) {
            int ordinal = 0;
            for (Number value : this.getNodataValues().keySet()) {
                float pad = MathFunctions.toNanFloat(ordinal++);
                if (array instanceof float[]) {
                    ArraysExt.replace((float[])array, value.floatValue(), pad);
                    continue;
                }
                if (!(array instanceof double[])) continue;
                ArraysExt.replace((double[])array, value.doubleValue(), (double)pad);
            }
        }
    }

    protected abstract double coordinateForAxis(int var1, int var2) throws IOException, DataStoreException;

    protected boolean trySetTransform(Matrix gridToCRS, int srcDim, int tgtDim, Vector data) throws IOException, DataStoreException {
        int n = data.size() - 1;
        if (n >= 0) {
            Number increment;
            double first = data.doubleValue(0);
            if (n >= 1) {
                double last = data.doubleValue(n);
                double error = this.getDataType() == DataType.FLOAT ? (double)Math.max(Math.ulp((float)first), Math.ulp((float)last)) : Math.max(Math.ulp(first), Math.ulp(last));
                error = Math.max(Math.ulp(last - first), error) / (double)n;
                increment = data.increment(error);
            } else {
                increment = Double.NaN;
            }
            if (increment != null) {
                gridToCRS.setElement(tgtDim, srcDim, (double)increment);
                gridToCRS.setElement(tgtDim, gridToCRS.getNumCol() - 1, first);
                return true;
            }
        }
        return false;
    }

    protected final DataStoreContentException canNotComputePosition(ArithmeticException cause) {
        return new DataStoreContentException(this.resources().getString((short)6, this.getFilename(), this.getName()), cause);
    }

    public final void writeDataTypeName(StringBuilder buffer) {
        buffer.append(this.getDataType().name().toLowerCase(Locale.US));
        List<Dimension> dimensions = this.getGridDimensions();
        int i = dimensions.size();
        while (--i >= 0) {
            dimensions.get(i).writeLength(buffer);
        }
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getName()).append(" : ");
        this.writeDataTypeName(buffer);
        if (this.isUnlimited()) {
            buffer.append(" (unlimited)");
        }
        return buffer.toString();
    }
}

