/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.provider.ObliqueMercator;
import org.opengis.parameter.ParameterDescriptor;

@XmlTransient
public class ObliqueMercatorTwoPoints
extends ObliqueMercator {
    private static final long serialVersionUID = 7202109026784761711L;
    public static final ParameterDescriptor<Double> LAT_OF_1ST_POINT;
    public static final ParameterDescriptor<Double> LONG_OF_1ST_POINT;
    public static final ParameterDescriptor<Double> LAT_OF_2ND_POINT;
    public static final ParameterDescriptor<Double> LONG_OF_2ND_POINT;

    private static ParameterDescriptor<Double> create(ParameterBuilder builder, double min2, double max) {
        return builder.createBounded(MeasurementRange.create(min2, false, max, false, Units.DEGREE), null);
    }

    public ObliqueMercatorTwoPoints() {
        this("Hotine_Oblique_Mercator_Two_Point_Natural_Origin", FALSE_EASTING, FALSE_NORTHING);
    }

    ObliqueMercatorTwoPoints(String name, ParameterDescriptor<Double> easting, ParameterDescriptor<Double> northing) {
        super(((ParameterBuilder)((ParameterBuilder)ObliqueMercatorTwoPoints.builder().setCodeSpace(Citations.ESRI, "ESRI")).addName(name)).createGroupForMapProjection(LAT_OF_1ST_POINT, LONG_OF_1ST_POINT, LAT_OF_2ND_POINT, LONG_OF_2ND_POINT, LATITUDE_OF_CENTRE, SCALE_FACTOR, easting, northing));
    }

    static {
        ParameterBuilder builder = (ParameterBuilder)ObliqueMercatorTwoPoints.builder().setCodeSpace(Citations.ESRI, "ESRI");
        LAT_OF_1ST_POINT = ObliqueMercatorTwoPoints.create((ParameterBuilder)builder.addName("Latitude_Of_1st_Point"), -90.0, 90.0);
        LAT_OF_2ND_POINT = ObliqueMercatorTwoPoints.create((ParameterBuilder)builder.addName("Latitude_Of_2nd_Point"), -90.0, 90.0);
        LONG_OF_1ST_POINT = ObliqueMercatorTwoPoints.create((ParameterBuilder)builder.addName("Longitude_Of_1st_Point"), -180.0, 180.0);
        LONG_OF_2ND_POINT = ObliqueMercatorTwoPoints.create((ParameterBuilder)builder.addName("Longitude_Of_2nd_Point"), -180.0, 180.0);
    }
}

