/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.LongitudeWraparound;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.projection.ProjectionVariant;
import org.apache.sis.referencing.operation.provider.MapProjection;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.DefaultMathTransformFactory;
import org.apache.sis.referencing.operation.transform.MathTransformProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class NormalizedProjection
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = -4010883312927645853L;
    static final double ANGULAR_TOLERANCE = 1.5706706731410455E-9;
    static final double ITERATION_TOLERANCE = 3.926676682852614E-10;
    static final int MAXIMUM_ITERATIONS = 18;
    static final double POLAR_AREA_LIMIT = 1.4660765716752369;
    static final double LARGE_LONGITUDE_LIMIT = 314.1592653589793;
    private static final Map<Class<?>, ParameterDescriptorGroup> DESCRIPTORS = new HashMap();
    final ContextualParameters context;
    protected final double eccentricity;
    protected final double eccentricitySquared;
    private final Inverse inverse;

    protected NormalizedProjection(OperationMethod method, Parameters parameters, Map<ParameterRole, ? extends ParameterDescriptor<? extends Number>> roles) {
        this(new Initializer(method, parameters, roles, null), null);
    }

    NormalizedProjection(Initializer initializer, NormalizedProjection other) {
        if (initializer != null) {
            this.context = initializer.context;
            this.eccentricitySquared = initializer.eccentricitySquared.doubleValue();
            this.eccentricity = Math.sqrt(this.eccentricitySquared);
        } else {
            this.context = other.context;
            this.eccentricity = other.eccentricity;
            this.eccentricitySquared = other.eccentricitySquared;
        }
        this.inverse = new Inverse(this);
    }

    static <V extends ProjectionVariant> V variant(OperationMethod method, V[] variants, V defaultValue) {
        for (V variant : variants) {
            String identifier = variant.getIdentifier();
            if (identifier == null) continue;
            for (ReferenceIdentifier id : method.getIdentifiers()) {
                if (!"EPSG".equals(id.getCodeSpace()) || !identifier.equals(id.getCode())) continue;
                return variant;
            }
        }
        String name = method.getName().getCode().replace('_', ' ');
        for (V variant : variants) {
            Pattern regex = variant.getOperationNamePattern();
            if (regex == null || !regex.matcher(name).matches()) continue;
            return variant;
        }
        return defaultValue;
    }

    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        return this.context.completeTransform(factory, this);
    }

    final MathTransform completeWithWraparound(MathTransformFactory factory) throws FactoryException {
        AbstractMathTransform2D kernel = this;
        MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
        double rotation = normalize.getElement(0, 2);
        if (rotation != 0.0 && Double.isFinite(rotation)) {
            kernel = new LongitudeWraparound(this, LongitudeWraparound.boundOfScaledLongitude(normalize, rotation < 0.0), rotation);
        }
        return this.context.completeTransform(factory, kernel);
    }

    final MathTransform delegate(MathTransformFactory factory, String name) throws FactoryException {
        OperationMethod method = factory instanceof DefaultMathTransformFactory ? ((DefaultMathTransformFactory)factory).getOperationMethod(name) : CoordinateOperations.getOperationMethod(factory.getAvailableMethods(SingleOperation.class), name);
        if (method instanceof MathTransformProvider) {
            return ((MathTransformProvider)((Object)method)).createMathTransform(factory, this.context);
        }
        throw new FactoryException(Errors.format((short)160, (method != null ? method : factory).getClass()));
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup group = this.getParameterDescriptors().createValue();
        group.parameter("eccentricity").setValue(this.eccentricity);
        String[] names = this.getInternalParameterNames();
        double[] values = this.getInternalParameterValues();
        for (int i = 0; i < names.length; ++i) {
            group.parameter(names[i]).setValue(values[i]);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ParameterDescriptorGroup group;
        Class<?> type = this.getClass();
        while (!Modifier.isPublic(type.getModifiers())) {
            type = type.getSuperclass();
        }
        Map<Class<?>, ParameterDescriptorGroup> map = DESCRIPTORS;
        synchronized (map) {
            group = DESCRIPTORS.get(type);
            if (group == null) {
                ParameterBuilder builder = new ParameterBuilder().setRequired(true);
                if (type.getName().startsWith("org.apache.sis.")) {
                    builder.setCodeSpace(Citations.SIS, "SIS");
                }
                String[] names = this.getInternalParameterNames();
                GeneralParameterDescriptor[] parameters = new ParameterDescriptor[names.length + 1];
                parameters[0] = MapProjection.ECCENTRICITY;
                for (int i = 1; i < parameters.length; ++i) {
                    parameters[i] = ((ParameterBuilder)builder.addName(names[i - 1])).create(Double.class, null);
                }
                group = ((ParameterBuilder)builder.addName(CharSequences.camelCaseToSentence(type.getSimpleName()) + " (radians domain)")).createGroup(1, 1, parameters);
                DESCRIPTORS.put(type, group);
            }
        }
        return group;
    }

    String[] getInternalParameterNames() {
        return CharSequences.EMPTY_ARRAY;
    }

    double[] getInternalParameterValues() {
        return null;
    }

    final double getWraparoundLongitude() {
        return LongitudeWraparound.boundOfScaledLongitude(this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION), false);
    }

    @Override
    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws ProjectionException;

    protected abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        Matrix m4 = NormalizedProjection.getMiddleMatrix(this, other, applyOtherFirst);
        if (m4 != null) {
            return this.tryConcatenate(!applyOtherFirst, m4, factory);
        }
        return super.tryConcatenate(applyOtherFirst, other, factory);
    }

    MathTransform tryConcatenate(boolean projectedSpace, Matrix affine, MathTransformFactory factory) throws FactoryException {
        return null;
    }

    private static Matrix getMiddleMatrix(AbstractMathTransform projection, MathTransform other, boolean applyOtherFirst) {
        int oi;
        MathTransform inverse;
        List<MathTransform> steps = MathTransforms.getSteps(other);
        if (steps.size() == 2 && ((inverse = steps.get(oi = applyOtherFirst ? 0 : 1)) instanceof Inverse || inverse instanceof NormalizedProjection)) {
            try {
                Matrix m4;
                if (projection.equals(inverse.inverse(), ComparisonMode.IGNORE_METADATA) && Matrices.isAffine(m4 = MathTransforms.getMatrix(steps.get(oi ^ 1))) && m4.getNumRow() == 3 && m4.getNumCol() == 3) {
                    return m4;
                }
            }
            catch (NoninvertibleTransformException e) {
                Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.operation");
                Class caller = projection instanceof NormalizedProjection ? NormalizedProjection.class : projection.getClass();
                Logging.recoverableException(LOGGER, caller, "tryConcatenate", e);
            }
        }
        return null;
    }

    @Override
    protected int computeHashCode() {
        long c = Double.doubleToLongBits(this.eccentricity);
        double[] parameters = this.getInternalParameterValues();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                c = c * 31L + Double.doubleToLongBits(parameters[i]);
            }
        }
        return super.computeHashCode() ^ Long.hashCode(c);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        Object[] names;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, mode)) {
            return false;
        }
        NormalizedProjection that = (NormalizedProjection)object;
        switch (mode) {
            case STRICT: 
            case BY_CONTRACT: {
                if (!Objects.equals(this.context, that.context)) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals(this.eccentricitySquared, that.eccentricitySquared)) break;
                return false;
            }
            default: {
                double e = Math.max(this.eccentricity, that.eccentricity);
                if (Numerics.epsilonEqual(this.eccentricity, that.eccentricity, 1.5706706731410455E-9 * (1.0 / e - e))) break;
                assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference("eccentricity", this.eccentricity, that.eccentricity);
                return false;
            }
        }
        double[] values = this.getInternalParameterValues();
        double[] others = that.getInternalParameterValues();
        if (values == null) {
            return others == null;
        }
        if (others != null && values.length == others.length && Arrays.equals(names = this.getInternalParameterNames(), that.getInternalParameterNames())) {
            for (int i = 0; i < values.length; ++i) {
                if (Numerics.epsilonEqual(values[i], others[i], mode)) continue;
                assert (mode != ComparisonMode.DEBUG) : Numerics.messageForDifference((String)names[i], values[i], others[i]);
                return false;
            }
            return true;
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform2D.Inverse
    implements Serializable {
        private static final long serialVersionUID = 6014176098150309651L;
        private final NormalizedProjection forward;

        Inverse(NormalizedProjection forward) {
            this.forward = forward;
        }

        @Override
        public MathTransform2D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            if (!derivate) {
                this.forward.inverseTransform(srcPts, srcOff, dstPts, dstOff);
                return null;
            }
            if (dstPts == null) {
                dstPts = new double[2];
                dstOff = 0;
            }
            this.forward.inverseTransform(srcPts, srcOff, dstPts, dstOff);
            return Matrices.inverse(this.forward.transform(dstPts, dstOff, null, 0, true));
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
            if (srcPts == dstPts && srcOff < dstOff) {
                super.transform(srcPts, srcOff, dstPts, dstOff, numPts);
            } else {
                while (--numPts >= 0) {
                    this.forward.inverseTransform(srcPts, srcOff, dstPts, dstOff);
                    srcOff += 2;
                    dstOff += 2;
                }
            }
        }

        @Override
        protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
            Matrix m4 = NormalizedProjection.getMiddleMatrix(this, other, applyOtherFirst);
            if (m4 != null) {
                return this.forward.tryConcatenate(applyOtherFirst, m4, factory);
            }
            return super.tryConcatenate(applyOtherFirst, other, factory);
        }
    }

    protected static enum ParameterRole {
        SEMI_MAJOR,
        SEMI_MINOR,
        LATITUDE_OF_CONFORMAL_SPHERE_RADIUS,
        CENTRAL_MERIDIAN,
        SCALE_FACTOR,
        FALSE_EASTING,
        FALSE_WESTING,
        FALSE_NORTHING,
        FALSE_SOUTHING;

    }
}

