/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.matrix;

import org.apache.sis.referencing.internal.Arithmetic;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.GeneralMatrix;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.matrix.NoninvertibleMatrixException;
import org.apache.sis.referencing.util.ExtendedPrecisionMatrix;
import org.apache.sis.util.ArraysExt;
import org.opengis.referencing.operation.Matrix;

final class Solver
implements ExtendedPrecisionMatrix {
    private static final int TUPLE_SIZE = 3;
    private static final ExtendedPrecisionMatrix IDENTITY = new Solver();

    private Solver() {
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    @Override
    public Number getElementOrNull(int j, int i) {
        return j == i ? Integer.valueOf(1) : null;
    }

    @Override
    public double getElement(int j, int i) {
        return j == i ? 1.0 : 0.0;
    }

    @Override
    public Matrix clone() {
        return this;
    }

    @Override
    public int getNumRow() {
        return 0;
    }

    @Override
    public int getNumCol() {
        return 0;
    }

    static GeneralMatrix inverse(Matrix X) throws NoninvertibleMatrixException {
        int size = X.getNumRow();
        int numCol = X.getNumCol();
        if (numCol != size) {
            throw new NoninvertibleMatrixException(Resources.format((short)51, size, numCol));
        }
        return Solver.solve(MatrixSIS.asExtendedPrecision(X), IDENTITY, size, size);
    }

    static GeneralMatrix solve(Matrix X, Matrix Y) throws NoninvertibleMatrixException {
        int size = X.getNumRow();
        int numCol = X.getNumCol();
        if (numCol != size) {
            throw new NoninvertibleMatrixException(Resources.format((short)51, size, numCol));
        }
        int innerSize = Y.getNumCol();
        GeneralMatrix.ensureNumRowMatch(size, Y.getNumRow(), innerSize);
        return Solver.solve(MatrixSIS.asExtendedPrecision(X), MatrixSIS.asExtendedPrecision(Y), size, innerSize);
    }

    private static GeneralMatrix solve(ExtendedPrecisionMatrix X, ExtendedPrecisionMatrix Y, int size, int innerSize) throws NoninvertibleMatrixException {
        int i;
        assert (X.getNumRow() == size && X.getNumCol() == size) : size;
        assert (Y.getNumRow() == size && Y.getNumCol() == innerSize || Y instanceof Solver);
        Number[] LU = X.getElementAsNumbers(true);
        int lastRowOrColumn = size - 1;
        int[] indexOfNaN = null;
        int indexCount = 0;
        if (X instanceof MatrixSIS ? ((MatrixSIS)((Object)X)).isAffine() : MatrixSIS.isAffine(X)) {
            int flatIndex = (size - 1) * size;
            block0: while (--flatIndex >= 0) {
                int k;
                if (!Double.isNaN(Solver.doubleValue(LU[flatIndex]))) continue;
                int j = flatIndex / size;
                i = flatIndex % size;
                int columnOfScale = -1;
                if (i != lastRowOrColumn) {
                    columnOfScale = i;
                    k = lastRowOrColumn;
                    while (--k >= 0) {
                        if (k == j || LU[k * size + i] == null) continue;
                        indexOfNaN = null;
                        indexCount = 0;
                        break block0;
                    }
                }
                k = lastRowOrColumn;
                while (--k >= 0) {
                    if (k == i || LU[j * size + k] == null) continue;
                    if (columnOfScale >= 0) {
                        indexOfNaN = null;
                        indexCount = 0;
                        break block0;
                    }
                    columnOfScale = k;
                }
                if (indexOfNaN == null) {
                    indexOfNaN = new int[lastRowOrColumn * 6];
                }
                indexOfNaN[indexCount++] = i;
                indexOfNaN[indexCount++] = j;
                indexOfNaN[indexCount++] = columnOfScale;
                assert (indexCount % 3 == 0);
            }
            for (int k = 0; k < indexCount; k += 3) {
                void i2 = indexOfNaN[k];
                void j = indexOfNaN[k + 1];
                LU[j * size + i2] = i2 == lastRowOrColumn ? null : Integer.valueOf(1);
            }
        }
        GeneralMatrix matrix = Solver.solve(LU, Y, size, innerSize);
        int k = 0;
        while (k < indexCount) {
            assert (k % 3 == 0);
            i = indexOfNaN[k++];
            void j = indexOfNaN[k++];
            void s2 = indexOfNaN[k++];
            if (i != lastRowOrColumn) {
                matrix.setElement(i, (int)j, Double.NaN);
                if (matrix.getElementOrNull(i, lastRowOrColumn) == null) continue;
                matrix.setElement(i, lastRowOrColumn, Double.NaN);
                continue;
            }
            if (s2 < 0) continue;
            matrix.setElement((int)s2, lastRowOrColumn, Double.NaN);
        }
        return matrix;
    }

    private static GeneralMatrix solve(Number[] LU, ExtendedPrecisionMatrix Y, int size, int innerSize) throws NoninvertibleMatrixException {
        int t2;
        int i;
        int rowOffset;
        int i2;
        int j;
        int[] pivot = ArraysExt.range(0, size);
        Number[] column = new Number[size];
        for (int i3 = 0; i3 < size; ++i3) {
            Number sum;
            int j2;
            for (j2 = 0; j2 < size; ++j2) {
                column[j2] = LU[j2 * size + i3];
            }
            for (j2 = 0; j2 < size; ++j2) {
                int rowOffset2 = j2 * size;
                int kmax = Math.min(j2, i3);
                Number sum2 = null;
                for (int k = 0; k < kmax; ++k) {
                    sum2 = Arithmetic.add(sum2, Arithmetic.multiply(LU[rowOffset2 + k], column[k]));
                }
                LU[rowOffset2 + i3] = column[j2] = Arithmetic.subtract(column[j2], sum2);
            }
            int p = i3;
            int j3 = i3;
            while (++j3 < size) {
                if (!(Math.abs(Solver.doubleValue(column[j3])) > Math.abs(Solver.doubleValue(column[p])))) continue;
                p = j3;
            }
            if (p != i3) {
                int pRow = p * size;
                int iRow = i3 * size;
                for (int k = 0; k < size; ++k) {
                    ArraysExt.swap(LU, pRow + k, iRow + k);
                }
                ArraysExt.swap(pivot, p, i3);
            }
            if ((sum = LU[i3 * size + i3]) == null) continue;
            j = i3;
            while (++j < size) {
                int t3 = j * size + i3;
                LU[t3] = Arithmetic.divide(LU[t3], sum);
            }
        }
        for (int j4 = 0; j4 < size; ++j4) {
            if (LU[j4 * size + j4] != null) continue;
            throw new NoninvertibleMatrixException(Resources.format((short)63));
        }
        GeneralMatrix result = GeneralMatrix.create(size, innerSize, false);
        Number[] elements = result.elements;
        int k = 0;
        for (j = 0; j < size; ++j) {
            int p = pivot[j];
            for (i2 = 0; i2 < innerSize; ++i2) {
                elements[k++] = Y.getElementOrNull(p, i2);
            }
        }
        for (k = 0; k < size; ++k) {
            rowOffset = k * innerSize;
            int j5 = k;
            while (++j5 < size) {
                int loRowOffset = j5 * innerSize;
                int luRowOffset = j5 * size;
                for (i = 0; i < innerSize; ++i) {
                    t2 = loRowOffset + i;
                    elements[t2] = Arithmetic.subtract(elements[t2], Arithmetic.multiply(elements[rowOffset + i], LU[luRowOffset + k]));
                }
            }
        }
        k = size;
        while (--k >= 0) {
            rowOffset = k * innerSize;
            Number sum = LU[k * size + k];
            for (i2 = 0; i2 < innerSize; ++i2) {
                int t4 = rowOffset + i2;
                elements[t4] = Arithmetic.divide(elements[t4], sum);
            }
            for (int j6 = 0; j6 < k; ++j6) {
                int upRowOffset = j6 * innerSize;
                sum = LU[j6 * size + k];
                for (i = 0; i < innerSize; ++i) {
                    t2 = upRowOffset + i;
                    elements[t2] = Arithmetic.subtract(elements[t2], Arithmetic.multiply(elements[rowOffset + i], sum));
                }
            }
        }
        return result;
    }

    private static double doubleValue(Number value) {
        return value != null ? value.doubleValue() : 0.0;
    }
}

