/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.builder;

import java.util.Arrays;
import java.util.function.Function;
import javax.measure.quantity.Dimensionless;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Statistics;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.Units;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.datum.DatumShiftGrid;
import org.apache.sis.referencing.operation.builder.ProjectedTransformTry;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.internal.Numerics;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class ResidualGrid
extends DatumShiftGrid<Dimensionless, Dimensionless> {
    private static final long serialVersionUID = -3668228260650927123L;
    static final int SOURCE_DIMENSION = 2;
    private static final ParameterDescriptorGroup PARAMETERS;
    private final int scanlineStride;
    private final float[] offsets;
    final LinearTransform gridToTarget;
    private final double accuracy;
    private final double[] periodVector;

    @Override
    public void getParameterValues(Parameters parameters) {
        Matrix denormalization = this.gridToTarget.getMatrix();
        if (parameters instanceof ContextualParameters) {
            MatrixSIS m4 = ((ContextualParameters)parameters).getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
            m4.setMatrix(denormalization);
        }
        parameters.parameter("num_row").setValue(this.getGridSize(1));
        parameters.parameter("num_col").setValue(this.getGridSize(0));
        parameters.parameter("grid_x").setValue(new Data(0, denormalization));
        parameters.parameter("grid_y").setValue(new Data(1, denormalization));
    }

    ResidualGrid(LinearTransform sourceToGrid, LinearTransform gridToTarget, int nx, int ny, float[] residuals, double precision, double[] periods, ProjectedTransformTry linearizer) throws TransformException {
        super(Units.UNITY, sourceToGrid, new int[]{nx, ny}, true, Units.UNITY);
        this.gridToTarget = gridToTarget;
        this.offsets = residuals;
        this.accuracy = precision;
        this.scanlineStride = nx;
        if (periods != null && linearizer == null && gridToTarget.isAffine()) {
            MatrixSIS m4 = MatrixSIS.castOrCopy(gridToTarget.inverse().derivative(null));
            this.periodVector = m4.multiply(periods);
        } else {
            this.periodVector = null;
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return PARAMETERS;
    }

    @Override
    public int getTranslationDimensions() {
        return 2;
    }

    @Override
    public double getCellPrecision() {
        return this.accuracy;
    }

    @Override
    public double getCellValue(int dim, int gridX, int gridY) {
        return this.offsets[(gridX + gridY * this.scanlineStride) * 2 + dim];
    }

    @Override
    protected void replaceOutsideGridCoordinates(double[] gridCoordinates) {
        if (this.periodVector != null) {
            double min2 = Double.NEGATIVE_INFINITY;
            double max = Double.POSITIVE_INFINITY;
            for (int i = 0; i < gridCoordinates.length; ++i) {
                double period = this.periodVector[i];
                double toLower = gridCoordinates[i];
                double toUpper = toLower - (double)(this.getGridSize(i) - 1);
                toLower = Math.floor(toLower / period);
                toUpper = Math.ceil(toUpper / period);
                if (toLower < max) {
                    max = toLower;
                }
                if (!(toUpper > min2)) continue;
                min2 = toUpper;
            }
            if (min2 <= max) {
                double n;
                double d = n = min2 >= 0.0 ? min2 : max;
                if (Double.isFinite(n)) {
                    for (int i = 0; i < gridCoordinates.length; ++i) {
                        int n2 = i;
                        gridCoordinates[n2] = gridCoordinates[n2] - this.periodVector[i] * n;
                    }
                }
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (super.equals(other)) {
            ResidualGrid that = (ResidualGrid)other;
            return Numerics.equals(this.accuracy, that.accuracy) && this.gridToTarget.equals(that.gridToTarget) && Arrays.equals(this.offsets, that.offsets);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Arrays.hashCode(this.offsets) + 37 * this.gridToTarget.hashCode();
    }

    static {
        ParameterBuilder builder = new ParameterBuilder().setRequired(true);
        GeneralParameterDescriptor[] grids = new ParameterDescriptor[]{((ParameterBuilder)builder.addName("num_row")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)builder.addName("num_col")).createBounded(Integer.class, Integer.valueOf(2), null, null), ((ParameterBuilder)builder.addName("grid_x")).create(Matrix.class, null), ((ParameterBuilder)builder.addName("grid_y")).create(Matrix.class, null)};
        PARAMETERS = ((ParameterBuilder)builder.addName("Localization grid")).createGroup(grids);
    }

    private final class Data
    extends FormattableObject
    implements Matrix,
    Function<int[], Number> {
        private final double c0;
        private final double c1;
        private final double c2;

        Data(int dim, Matrix denormalization) {
            this.c0 = denormalization.getElement(dim, 0);
            this.c1 = denormalization.getElement(dim, 1);
            this.c2 = denormalization.getElement(dim, 2);
        }

        @Override
        public Matrix clone() {
            return this;
        }

        @Override
        public boolean isIdentity() {
            return false;
        }

        @Override
        public int getNumCol() {
            return ResidualGrid.this.getGridSize(0);
        }

        @Override
        public int getNumRow() {
            return ResidualGrid.this.getGridSize(1);
        }

        @Override
        public Number apply(int[] p) {
            return this.getElement(p[1], p[0]);
        }

        @Override
        public void setElement(int y, int x, double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getElement(int y, int x) {
            if ((x | y) < 0 || x >= ResidualGrid.this.scanlineStride) {
                throw new IndexOutOfBoundsException();
            }
            return Math.fma((double)x + ResidualGrid.this.getCellValue(0, x, y), this.c0, Math.fma((double)y + ResidualGrid.this.getCellValue(1, x, y), this.c1, this.c2));
        }

        @Override
        public String toString() {
            return new StringBuilder(80).append('[').append(this.getElement(0, 0)).append(", \u2026, ").append(this.getElement(ResidualGrid.this.getGridSize(1) - 1, ResidualGrid.this.getGridSize(0) - 1)).append(']').toString();
        }

        @Override
        protected String formatTo(Formatter formatter) {
            Object[] numbers = WKTUtilities.cornersAndCenter(this, ResidualGrid.this.getGridSize(), 3);
            Vector[] rows = new Vector[numbers.length];
            Statistics stats = new Statistics(null);
            Vector before = null;
            for (int j = 0; j < rows.length; ++j) {
                Vector row = Vector.create(numbers[j], false);
                Number right = null;
                int i = row.size();
                while (--i >= 0) {
                    Number n = row.get(i);
                    if (n != null) {
                        Number up;
                        double value = n.doubleValue();
                        if (right != null) {
                            stats.accept(Math.abs(right.doubleValue() - value));
                        }
                        if (before != null && (up = before.get(i)) != null) {
                            stats.accept(Math.abs(up.doubleValue() - value));
                        }
                    }
                    right = n;
                }
                before = row;
                rows[j] = row;
            }
            int accuracy = Numerics.suggestFractionDigits(stats);
            formatter.newLine();
            formatter.append(rows, Math.max(0, accuracy));
            formatter.setInvalidWKT(Matrix.class, null);
            return "Matrix";
        }
    }
}

