/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.List;
import org.apache.sis.referencing.crs.DefaultParametricCRS;
import org.apache.sis.referencing.operation.CoordinateOperationContext;
import org.apache.sis.referencing.operation.CoordinateOperationFinder;
import org.apache.sis.referencing.operation.CoordinateOperationRegistry;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

final class SubOperationInfo {
    private static final Class<?>[][] COMPATIBLE_TYPES = new Class[][]{{GeodeticCRS.class}, {VerticalCRS.class, GeodeticCRS.class}, {TemporalCRS.class}, {DefaultParametricCRS.class}, {EngineeringCRS.class}, {ImageCRS.class}};
    final CoordinateOperation operation;
    private final double[] constants;
    private final int startAtDimension;
    private final int endAtDimension;
    final int targetComponentIndex;

    private static Class<?> type(SingleCRS crs) {
        while (crs instanceof GeneralDerivedCRS) {
            crs = (SingleCRS)((GeneralDerivedCRS)crs).getBaseCRS();
        }
        return crs.getClass();
    }

    private SubOperationInfo(int targetComponentIndex, CoordinateOperation operation, double[] constants, int startAtDimension, int endAtDimension) {
        this.operation = operation;
        this.constants = constants;
        this.startAtDimension = startAtDimension;
        this.endAtDimension = endAtDimension;
        this.targetComponentIndex = targetComponentIndex;
        assert (operation == null != (constants == null));
    }

    static SubOperationInfo[] createSteps(CoordinateOperationFinder caller, List<? extends SingleCRS> sources, List<? extends SingleCRS> targets) throws FactoryException, TransformException {
        SubOperationInfo[] infos = new SubOperationInfo[targets.size()];
        boolean[] sourceComponentIsUsed = new boolean[sources.size()];
        int targetEndAtDimension = 0;
        block2: for (int targetComponentIndex = 0; targetComponentIndex < infos.length; ++targetComponentIndex) {
            SingleCRS target = targets.get(targetComponentIndex);
            int targetStartAtDimension = targetEndAtDimension;
            targetEndAtDimension += target.getCoordinateSystem().getDimension();
            Class<?> targetType = SubOperationInfo.type(target);
            OperationNotFoundException failure = null;
            int sourceEndAtDimension = 0;
            for (int sourceComponentIndex = 0; sourceComponentIndex < sourceComponentIsUsed.length; ++sourceComponentIndex) {
                SingleCRS source = sources.get(sourceComponentIndex);
                int sourceStartAtDimension = sourceEndAtDimension;
                sourceEndAtDimension += source.getCoordinateSystem().getDimension();
                if (sourceComponentIsUsed[sourceComponentIndex]) continue;
                for (Class<?>[] sourceTypes : COMPATIBLE_TYPES) {
                    if (!sourceTypes[0].isAssignableFrom(targetType)) continue;
                    for (Class<?> sourceType : sourceTypes) {
                        CoordinateOperation operation;
                        if (!sourceType.isAssignableFrom(SubOperationInfo.type(source))) continue;
                        try {
                            operation = caller.createOperation(source, target);
                        }
                        catch (OperationNotFoundException exception) {
                            if (failure == null) {
                                failure = exception;
                                continue;
                            }
                            failure.addSuppressed(exception);
                            continue;
                        }
                        sourceComponentIsUsed[sourceComponentIndex] = true;
                        infos[targetComponentIndex] = new SubOperationInfo(targetComponentIndex, operation, null, sourceStartAtDimension, sourceEndAtDimension);
                        if (failure == null) continue block2;
                        CoordinateOperationRegistry.recoverableException("decompose", failure);
                        continue block2;
                    }
                }
            }
            if (failure != null) {
                throw failure;
            }
            double[] constants = CoordinateOperationContext.getConstantCoordinates();
            if (constants == null || constants.length < targetEndAtDimension) {
                return null;
            }
            for (int i = targetStartAtDimension; i < targetEndAtDimension; ++i) {
                if (!Double.isNaN(constants[i])) continue;
                return null;
            }
            infos[targetComponentIndex] = new SubOperationInfo(targetComponentIndex, null, constants, targetStartAtDimension, targetEndAtDimension);
        }
        return infos;
    }

    static CoordinateReferenceSystem[] getSourceCRS(SubOperationInfo[] selected) {
        int n = selected.length;
        int last = n - 1;
        for (int i = 0; i < n; ++i) {
            SubOperationInfo component = selected[i];
            if (component.operation != null) continue;
            System.arraycopy(selected, i + 1, selected, i, last - i);
            selected[last] = component;
            --n;
        }
        CoordinateReferenceSystem[] stepComponents = new CoordinateReferenceSystem[n];
        for (int i = 0; i < n; ++i) {
            stepComponents[i] = selected[i].operation.getSourceCRS();
        }
        return stepComponents;
    }

    static int indexOfFinal(SubOperationInfo[] selected) {
        int n = selected.length;
        while (n != 0 && selected[--n].isIdentity()) {
        }
        return n;
    }

    static MatrixSIS sourceToSelected(int sourceDimensions, SubOperationInfo[] selected) {
        int selectedDimensions = 0;
        for (SubOperationInfo component : selected) {
            if (component.operation == null) break;
            selectedDimensions += component.endAtDimension - component.startAtDimension;
        }
        MatrixSIS select = Matrices.createZero(selectedDimensions + 1, sourceDimensions + 1);
        select.setElement(selectedDimensions, sourceDimensions, 1.0);
        int j = 0;
        for (SubOperationInfo component : selected) {
            for (int i = component.startAtDimension; i < component.endAtDimension; ++i) {
                select.setElement(j++, i, 1.0);
            }
        }
        return select;
    }

    final boolean isIdentity() {
        return this.operation != null && this.operation.getMathTransform().isIdentity();
    }

    static MatrixSIS createConstantOperation(SubOperationInfo[] selected, int n, int srcDim, int tgtDim) {
        int j;
        boolean[] targetDimensionIsUsed = new boolean[tgtDim];
        MatrixSIS m4 = Matrices.createZero(tgtDim + 1, srcDim + 1);
        m4.setElement(tgtDim, srcDim, 1.0);
        do {
            SubOperationInfo component = selected[n];
            for (j = component.startAtDimension; j < component.endAtDimension; ++j) {
                m4.setElement(j, srcDim, component.constants[j]);
                targetDimensionIsUsed[j] = true;
            }
        } while (++n < selected.length);
        int i = 0;
        for (j = 0; j < tgtDim; ++j) {
            if (targetDimensionIsUsed[j]) continue;
            m4.setElement(j, i++, 1.0);
        }
        return m4;
    }
}

