/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.metadata.sql.util.SQLUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;

public class SQLTranslator
implements Function<String, String> {
    private static final String[] SENTINEL = new String[]{"Coordinate Reference System", "coordinatereferencesystem", "epsg_coordinatereferencesystem"};
    private static final int MIXED_CASE = 0;
    static final String TABLE_PREFIX = "epsg_";
    private static final String[] BOOLEAN_COLUMNS = new String[]{"SHOW_CRS", "SHOW_OPERATION", "DEPRECATED"};
    private static final String ENUMERATION_COLUMN = "OBJECT_TABLE_NAME";
    private String catalog;
    private String schema;
    private boolean isPrefixed;
    private final Map<String, String> accessToAnsi;
    private boolean quoteTableNames;
    private final String quote;
    private String tableNameEnum;
    private boolean useBoolean;
    private boolean isTableFound;

    public SQLTranslator(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        ArgumentChecks.ensureNonNull("md", md);
        this.quote = md.getIdentifierQuoteString().trim();
        this.accessToAnsi = new HashMap<String, String>(4);
        this.catalog = catalog;
        this.schema = schema;
        this.setup(md);
    }

    final void setup(DatabaseMetaData md) throws SQLException {
        boolean toUpperCase = md.storesUpperCaseIdentifiers();
        String escape = md.getSearchStringEscape();
        String schemaPattern = SQLUtilities.escape(this.schema, escape);
        int i = SENTINEL.length;
        while (--i >= 0) {
            String table = SENTINEL[i];
            if (toUpperCase && i != 0) {
                table = table.toUpperCase(Locale.US);
            }
            ResultSet result = md.getTables(this.catalog, schemaPattern, table, null);
            try {
                if (!result.next()) continue;
                this.isTableFound = true;
                this.isPrefixed = table.startsWith(TABLE_PREFIX);
                this.quoteTableNames = i == 0;
                do {
                    this.catalog = result.getString("TABLE_CAT");
                    this.schema = result.getString("TABLE_SCHEM");
                } while (!"EPSG".equalsIgnoreCase(this.schema) && result.next());
                if (this.schema == null) {
                    this.schema = "";
                }
                schemaPattern = SQLUtilities.escape(this.schema, escape);
                break;
            }
            finally {
                if (result == null) continue;
                result.close();
            }
        }
        boolean translateColumns = true;
        this.accessToAnsi.clear();
        if (this.quoteTableNames) {
            try (ResultSet result = md.getColumns(this.catalog, schemaPattern, "Coordinate Axis", "ORDER");){
                translateColumns = !result.next();
            }
        } else {
            this.accessToAnsi.put("Coordinate_Operation", "coordoperation");
            this.accessToAnsi.put("Parameter", "param");
        }
        if (translateColumns) {
            this.accessToAnsi.put("ORDER", "coord_axis_order");
        }
        String deprecated = "DEPRECATED";
        String objectTable = ENUMERATION_COLUMN;
        if (md.storesLowerCaseIdentifiers()) {
            deprecated = deprecated.toLowerCase(Locale.US);
            objectTable = objectTable.toLowerCase(Locale.US);
        }
        String tablePattern = this.isPrefixed ? SQLUtilities.escape(TABLE_PREFIX, escape) + "%" : null;
        try (ResultSet result = md.getColumns(this.catalog, schemaPattern, tablePattern, deprecated);){
            while (result.next()) {
                if (!CharSequences.endsWith(result.getString("TABLE_NAME"), "Datum", true)) continue;
                int type = result.getInt("DATA_TYPE");
                this.useBoolean = type == 16 || type == -7;
                break;
            }
        }
        result = md.getColumns(this.catalog, schemaPattern, tablePattern, objectTable);
        try {
            while (result.next()) {
                if (!CharSequences.endsWith(result.getString("TABLE_NAME"), "Alias", true)) continue;
                String type = result.getString("TYPE_NAME");
                if (!CharSequences.startsWith(type, "VARCHAR", true)) {
                    this.tableNameEnum = type;
                }
                break;
            }
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    final boolean isTableFound() {
        return this.isTableFound;
    }

    static String tableNotFound(Locale locale) {
        return Errors.getResources(locale).getString((short)126, SENTINEL[0]);
    }

    final boolean useBoolean() {
        return this.useBoolean;
    }

    private static boolean isEmpty(String s2) {
        return s2 == null || s2.isEmpty();
    }

    @Override
    public String apply(String sql) {
        int w;
        int start;
        if (this.quote.isEmpty() && this.accessToAnsi.isEmpty() && SQLTranslator.isEmpty(this.schema) && SQLTranslator.isEmpty(this.catalog)) {
            return sql;
        }
        StringBuilder ansi = new StringBuilder(sql.length() + 16);
        int end = 0;
        while ((start = sql.indexOf(91, end)) >= 0) {
            String name;
            ansi.append(sql, end, start);
            end = sql.indexOf(93, ++start);
            if (end < 0) {
                throw new IllegalArgumentException(Errors.format((short)84, sql.substring(start), Character.valueOf(']')));
            }
            if (CharSequences.isUpperCase(name = sql.substring(start, end++))) {
                ansi.append(this.accessToAnsi.getOrDefault(name, name));
                continue;
            }
            this.appendIdentifier(ansi, name);
        }
        ansi.append(sql, end, sql.length());
        if (this.useBoolean && (w = ansi.indexOf("WHERE")) >= 0) {
            w += 5;
            for (String field : BOOLEAN_COLUMNS) {
                int p = ansi.indexOf(field, w);
                if (p < 0 || SQLTranslator.replaceIfEquals(ansi, p += field.length(), "=0", "=FALSE") || SQLTranslator.replaceIfEquals(ansi, p, "<>0", "=TRUE") || (p = ansi.lastIndexOf("(", p)) <= w) continue;
                SQLTranslator.replaceIfEquals(ansi, p - 3, "ABS", "");
            }
        }
        if (this.tableNameEnum != null && (w = ansi.lastIndexOf("OBJECT_TABLE_NAME=?")) >= 0) {
            ansi.replace(w += ENUMERATION_COLUMN.length() + 1, w + 1, "CAST(? AS " + this.tableNameEnum + ")");
        }
        return ansi.toString();
    }

    private void appendIdentifier(StringBuilder buffer, String identifier) {
        if (!SQLTranslator.isEmpty(this.catalog)) {
            buffer.append(this.quote).append(this.catalog).append(this.quote).append('.');
        }
        if (!SQLTranslator.isEmpty(this.schema)) {
            buffer.append(this.quote).append(this.schema).append(this.quote).append('.');
        }
        if (this.quoteTableNames) {
            buffer.append(this.quote);
        }
        if (this.isPrefixed) {
            buffer.append(TABLE_PREFIX);
        }
        if (this.quoteTableNames) {
            buffer.append(this.accessToAnsi.getOrDefault(identifier, identifier)).append(this.quote);
        } else {
            for (String word : identifier.split("\\s")) {
                buffer.append(this.accessToAnsi.getOrDefault(word, word));
            }
        }
    }

    private static boolean replaceIfEquals(StringBuilder ansi, int pos, String expected, String replacement) {
        if (CharSequences.regionMatches(ansi, pos, expected)) {
            ansi.replace(pos, pos + expected.length(), replacement);
            return true;
        }
        return false;
    }
}

