/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.pending.jdk;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Stream;
import org.apache.sis.util.internal.UnmodifiableArrayList;

public final class JDK17 {
    private JDK17() {
    }

    public static void get(ByteBuffer b, int index, byte[] dst) {
        JDK17.get(b, index, dst, 0, dst.length);
    }

    public static void get(ByteBuffer b, int index, byte[] dst, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = b.get(index + i);
        }
    }

    public static void skipNBytes(InputStream s2, long n) throws IOException {
        while (n > 0L) {
            long c = s2.skip(n);
            if (c <= 0L) {
                if (c < 0L || s2.read() < 0) {
                    throw new EOFException();
                }
                c = 1L;
            }
            n -= c;
        }
    }

    public static <T> List<T> toList(Stream<T> s2) {
        return UnmodifiableArrayList.wrap(s2.toArray());
    }
}

