/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Filter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.sql.DataSource;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.sql.CacheKey;
import org.apache.sis.metadata.sql.CachedStatement;
import org.apache.sis.metadata.sql.Dispatcher;
import org.apache.sis.metadata.sql.Installer;
import org.apache.sis.metadata.sql.LookupInfo;
import org.apache.sis.metadata.sql.MetadataFallback;
import org.apache.sis.metadata.sql.MetadataProxy;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.metadata.sql.TableHierarchy;
import org.apache.sis.metadata.sql.util.Initializer;
import org.apache.sis.metadata.sql.util.SQLBuilder;
import org.apache.sis.pending.geoapi.evolution.Interim;
import org.apache.sis.system.DelayedExecutor;
import org.apache.sis.system.DelayedRunnable;
import org.apache.sis.system.SystemListener;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.CodeListSet;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.annotation.UML;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.util.CodeList;
import org.opengis.util.FactoryException;

public class MetadataSource
implements AutoCloseable {
    static final KeyNamePolicy NAME_POLICY = KeyNamePolicy.UML_IDENTIFIER;
    static final String ID_COLUMN = "ID";
    private static final long TIMEOUT = 2000000000L;
    private static final int EXTRA_DELAY = 500000000;
    protected final MetadataStandard standard;
    private final DataSource dataSource;
    private Connection connection;
    private final CachedStatement[] statements;
    final String catalog;
    private String schema;
    private boolean quoteSchema;
    private transient SQLBuilder helper;
    private final Map<String, Set<String>> tableColumns;
    private final ClassLoader classloader;
    private final WeakValueHashMap<CacheKey, Object> pool;
    private final ThreadLocal<LookupInfo> lastUsed;
    private volatile Filter logFilter;
    private boolean isCloseScheduled;
    private static MetadataSource instance;

    public static synchronized MetadataSource getProvided() {
        MetadataSource ms = instance;
        if (ms == null) {
            LogRecord warning = null;
            boolean isTransient = false;
            try {
                DataSource dataSource = Initializer.getDataSource();
                if (dataSource != null) {
                    ms = new MetadataSource(MetadataStandard.ISO_19115, dataSource, "metadata", null);
                    ms.install();
                } else {
                    warning = (LogRecord)Initializer.unspecified(null, true);
                    ms = MetadataFallback.INSTANCE;
                }
            }
            catch (Exception e) {
                ms = MetadataFallback.INSTANCE;
                warning = Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)6, "jdbc/SpatialMetadata");
                warning.setThrown(Exceptions.unwrap(e));
                if (e instanceof ClassNotFoundException) {
                    warning.setLevel(Level.CONFIG);
                }
                for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof SQLTransientException)) continue;
                    isTransient = true;
                    break;
                }
            }
            if (warning != null) {
                Logging.completeAndLog(SystemListener.LOGGER, MetadataSource.class, "getProvided", warning);
            }
            if (!isTransient) {
                instance = ms;
            }
        }
        return ms;
    }

    public MetadataSource(MetadataStandard standard, DataSource dataSource, String schema, Map<String, ?> properties) {
        ArgumentChecks.ensureNonNull("standard", standard);
        ArgumentChecks.ensureNonNull("dataSource", dataSource);
        this.catalog = Containers.property(properties, "catalog", String.class);
        ClassLoader classloader = Containers.property(properties, "classloader", ClassLoader.class);
        Integer maxStatements = Containers.property(properties, "maxStatements", Integer.class);
        if (classloader == null) {
            classloader = this.getClass().getClassLoader();
        }
        if (maxStatements == null) {
            maxStatements = 10;
        } else {
            ArgumentChecks.ensureBetween("maxStatements", 2, 255, maxStatements);
        }
        this.standard = standard;
        this.dataSource = dataSource;
        this.schema = schema;
        this.quoteSchema = true;
        this.classloader = classloader;
        this.statements = new CachedStatement[maxStatements - 1];
        this.tableColumns = new HashMap<String, Set<String>>();
        this.pool = new WeakValueHashMap(CacheKey.class);
        this.lastUsed = ThreadLocal.withInitial(LookupInfo::new);
    }

    public MetadataSource(MetadataSource source) {
        ArgumentChecks.ensureNonNull("source", source);
        this.standard = source.standard;
        this.dataSource = source.dataSource;
        this.catalog = source.catalog;
        this.schema = source.schema;
        this.quoteSchema = source.quoteSchema;
        this.statements = new CachedStatement[source.statements.length];
        this.tableColumns = new HashMap<String, Set<String>>();
        this.classloader = source.classloader;
        this.pool = source.pool;
        this.lastUsed = source.lastUsed;
        this.logFilter = source.logFilter;
    }

    MetadataSource() {
        this.standard = MetadataStandard.ISO_19115;
        this.dataSource = null;
        this.catalog = null;
        this.statements = null;
        this.tableColumns = null;
        this.classloader = this.getClass().getClassLoader();
        this.pool = null;
        this.lastUsed = null;
    }

    final synchronized void install() throws IOException, SQLException {
        Connection connection = this.connection();
        DatabaseMetaData md = connection.getMetaData();
        if (md.storesUpperCaseIdentifiers()) {
            this.schema = this.schema.toUpperCase(Locale.US);
        } else if (md.storesLowerCaseIdentifiers()) {
            this.schema = this.schema.toLowerCase(Locale.US);
        }
        this.quoteSchema = false;
        try (ResultSet result = md.getTables(this.catalog, this.schema, "Citation", null);){
            if (result.next()) {
                return;
            }
        }
        Installer installer = new Installer(connection);
        installer.run();
    }

    final Connection connection() throws SQLException {
        assert (Thread.holdsLock(this));
        Connection c = this.connection;
        if (c == null) {
            this.connection = c = this.dataSource.getConnection();
            Initializer.connected(c.getMetaData(), MetadataSource.class, "lookup");
            this.scheduleCloseTask();
        }
        return c;
    }

    final String schema() {
        return this.schema;
    }

    final SQLBuilder helper() throws SQLException {
        assert (Thread.holdsLock(this));
        if (this.helper == null) {
            this.helper = new SQLBuilder(this.connection().getMetaData(), this.quoteSchema);
        }
        return this.helper;
    }

    private CachedStatement prepareStatement(Class<?> type, String tableName, int preferredIndex) throws SQLException {
        CachedStatement statement;
        assert (Thread.holdsLock(this));
        if (preferredIndex >= 0 && preferredIndex < this.statements.length && (statement = this.statements[preferredIndex]) != null && statement.type == type) {
            this.statements[preferredIndex] = null;
            return statement;
        }
        for (int i = 0; i < this.statements.length; ++i) {
            CachedStatement statement2 = this.statements[i];
            if (statement2 == null || statement2.type != type) continue;
            this.statements[i] = null;
            return statement2;
        }
        if (tableName == null) {
            tableName = MetadataSource.getTableName(type);
        }
        SQLBuilder helper = this.helper();
        String query = helper.clear().append("SELECT * FROM ").appendIdentifier(this.schema, tableName).append(" WHERE ").appendIdentifier(ID_COLUMN).append("=?").toString();
        return new CachedStatement(type, this.connection().prepareStatement(query), this.logFilter);
    }

    private int recycle(CachedStatement statement, int preferredIndex) throws SQLException {
        assert (Thread.holdsLock(this));
        long currentTime = System.nanoTime();
        if (preferredIndex < 0 || preferredIndex >= this.statements.length || this.statements[preferredIndex] != null) {
            preferredIndex = 0;
            while (this.statements[preferredIndex] != null) {
                if (++preferredIndex < this.statements.length) continue;
                long oldest = Long.MIN_VALUE;
                for (int i = 0; i < this.statements.length; ++i) {
                    long age = currentTime - this.statements[i].expireTime;
                    if (age < oldest) continue;
                    oldest = age;
                    preferredIndex = i;
                }
                this.statements[preferredIndex].close();
                break;
            }
        }
        this.statements[preferredIndex] = statement;
        statement.expireTime = currentTime + 2000000000L;
        this.scheduleCloseTask();
        return preferredIndex;
    }

    static String getTableName(Class<?> type) {
        UML annotation = type.getAnnotation(UML.class);
        if (annotation == null) {
            return type.getSimpleName();
        }
        String name = annotation.identifier();
        int s2 = name.lastIndexOf(46) + 1;
        if (name.length() > s2 + 3 && name.charAt(s2 + 2) == '_' && Character.isUpperCase(name.charAt(1))) {
            s2 += 3;
        }
        return name.substring(s2);
    }

    final String proxy(Object metadata) {
        return metadata instanceof MetadataProxy ? ((MetadataProxy)metadata).identifier(this) : null;
    }

    final Map<String, Object> asValueMap(Object metadata) throws ClassCastException {
        return this.standard.asValueMap(metadata, null, NAME_POLICY, ValueExistencePolicy.ALL);
    }

    static Object extractFromCollection(Object value) {
        while (value instanceof Iterable) {
            Iterator it = ((Iterable)value).iterator();
            if (!it.hasNext()) {
                return null;
            }
            if (value != (value = it.next())) continue;
            break;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String search(Object metadata) throws MetadataStoreException {
        ArgumentChecks.ensureNonNull("metadata", metadata);
        String identifier = this.proxy(metadata);
        if (identifier == null) {
            if (metadata instanceof CodeList) {
                identifier = Types.getCodeName((CodeList)metadata);
            } else if (metadata instanceof Enum) {
                identifier = ((Enum)metadata).name();
            } else {
                Map<String, Object> asMap;
                String table;
                try {
                    table = MetadataSource.getTableName(this.standard.getInterface(metadata.getClass()));
                    asMap = this.asValueMap(metadata);
                }
                catch (ClassCastException e) {
                    throw new MetadataStoreException(Errors.format((short)42, "metadata", metadata.getClass()));
                }
                MetadataSource metadataSource = this;
                synchronized (metadataSource) {
                    try (Statement stmt = this.connection().createStatement();){
                        identifier = this.search(table, null, asMap, stmt, this.helper());
                    }
                    catch (SQLException e) {
                        throw new MetadataStoreException(e.getLocalizedMessage(), Exceptions.unwrap(e));
                    }
                    catch (FactoryException e) {
                        throw new MetadataStoreException(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return identifier;
    }

    final String search(String table, Set<String> columns, Map<String, Object> metadata, Statement stmt, SQLBuilder helper) throws SQLException, FactoryException {
        assert (Thread.holdsLock(this));
        helper.clear();
        for (Map.Entry<String, Object> entry : metadata.entrySet()) {
            Object value = MetadataSource.extractFromCollection(entry.getValue());
            String column = entry.getKey();
            if (columns == null) {
                columns = this.getExistingColumns(table);
            }
            if (!columns.contains(column)) {
                if (value == null) continue;
                return null;
            }
            if (value != null) {
                if (value instanceof CodeList) {
                    value = Types.getCodeName((CodeList)value);
                } else if (value instanceof Enum) {
                    value = ((Enum)value).name();
                } else {
                    String dependency = this.proxy(value);
                    if (dependency != null) {
                        value = dependency;
                    } else {
                        Class<?> type = value.getClass();
                        if (this.standard.isMetadata(type)) {
                            dependency = this.search(MetadataSource.getTableName(this.standard.getInterface(type)), null, this.asValueMap(value), stmt, new SQLBuilder(helper));
                            if (dependency == null) {
                                return null;
                            }
                            value = dependency;
                        }
                    }
                }
            }
            if (helper.isEmpty()) {
                helper.append("SELECT ").appendIdentifier(ID_COLUMN).append(" FROM ").appendIdentifier(this.schema, table).append(" WHERE ");
            } else {
                helper.append(" AND ");
            }
            helper.appendIdentifier(column).appendEqualsValue(MetadataSource.toStorableValue(value));
        }
        String identifier = null;
        try (ResultSet rs = stmt.executeQuery(helper.toString());){
            while (rs.next()) {
                String candidate = rs.getString(1);
                if (candidate == null) continue;
                if (identifier == null) {
                    identifier = candidate;
                    continue;
                }
                if (identifier.equals(candidate)) continue;
                this.warning(MetadataSource.class, "search", Errors.getResources((Locale)null).getLogRecord(Level.WARNING, (short)24, candidate));
                break;
            }
        }
        return identifier;
    }

    static Object toStorableValue(Object value) throws FactoryException {
        if (value instanceof IdentifiedObject) {
            value = ReferencingServices.getInstance().getPreferredIdentifier((IdentifiedObject)value);
        }
        return value;
    }

    final Set<String> getExistingColumns(String table) throws SQLException {
        assert (Thread.holdsLock(this));
        Set<String> columns = this.tableColumns.get(table);
        if (columns == null) {
            columns = new HashSet<String>();
            DatabaseMetaData md = this.connection().getMetaData();
            try (ResultSet rs = md.getColumns(this.catalog, this.schema, table, null);){
                while (rs.next()) {
                    if (columns.add(rs.getString("COLUMN_NAME"))) continue;
                    throw new SQLNonTransientException(table);
                }
            }
            this.tableColumns.put(table, columns);
        }
        return columns;
    }

    public <T> T lookup(Class<T> type, String identifier) throws MetadataStoreException {
        ArgumentChecks.ensureNonNull("type", type);
        ArgumentChecks.ensureNonEmpty("identifier", identifier);
        return type.cast(this.lookup(type, identifier, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object lookup(Class<?> type, String identifier, boolean verify) throws MetadataStoreException {
        Object value;
        if (CodeList.class.isAssignableFrom(type)) {
            value = MetadataSource.getCodeList(type, identifier);
        } else {
            CacheKey key = new CacheKey(type, identifier);
            value = this.pool.get(key);
            if (value == null && type.isInterface()) {
                Object replacement;
                Dispatcher toSearch = new Dispatcher(identifier, this);
                value = Proxy.newProxyInstance(this.classloader, new Class[]{type, MetadataProxy.class}, (InvocationHandler)toSearch);
                if (verify) {
                    try {
                        MetadataSource metadataSource = this;
                        synchronized (metadataSource) {
                            Class<?> subType = TableHierarchy.subType(type, identifier);
                            CachedStatement result = this.prepareStatement(subType, null, toSearch.preferredIndex);
                            result.getValue(identifier, ID_COLUMN);
                            toSearch.preferredIndex = this.recycle(result, toSearch.preferredIndex);
                        }
                    }
                    catch (SQLException e) {
                        throw new MetadataStoreException(Errors.format((short)21, type, identifier), e);
                    }
                }
                if ((replacement = this.pool.putIfAbsent(key, value)) != null) {
                    value = replacement;
                }
            }
            if (value == null) {
                Method method = null;
                Class<?> subType = TableHierarchy.subType(type, identifier);
                Dispatcher toSearch = new Dispatcher(identifier, this);
                try {
                    value = subType.getConstructor(new Class[0]).newInstance(new Object[0]);
                    LookupInfo info = this.getLookupInfo(subType);
                    Map<String, Object> map = this.asValueMap(value);
                    Map<String, String> methods = this.standard.asNameMap(subType, NAME_POLICY, KeyNamePolicy.METHOD_NAME);
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        method = subType.getMethod(methods.get(entry.getKey()), new Class[0]);
                        info.setMetadataType(subType);
                        Object p = this.readColumn(info, method, toSearch);
                        if (p == null) continue;
                        entry.setValue(p);
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new MetadataStoreException(Errors.format((short)160, subType), e);
                }
                catch (SQLException e) {
                    throw new MetadataStoreException(toSearch.error(method), e);
                }
            }
        }
        return type.cast(value);
    }

    final LookupInfo getLookupInfo(Class<?> type) {
        LookupInfo info = this.lastUsed.get();
        info.setMetadataType(type);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Object readColumn(LookupInfo info, Method method, Dispatcher toSearch) throws SQLException, MetadataStoreException {
        boolean isArray;
        Object value;
        Class<?> type = TableHierarchy.subType(info.getMetadataType(), toSearch.identifier);
        Class<?> returnType = Interim.getReturnType(method);
        boolean wantCollection = Collection.class.isAssignableFrom(returnType);
        Class<?> elementType = wantCollection ? Classes.boundOfParameterizedProperty(method) : returnType;
        boolean isMetadata = this.standard.isMetadata(elementType);
        String tableName = MetadataSource.getTableName(type);
        String columnName = info.asNameMap(this.standard).get(method.getName());
        MetadataSource metadataSource = this;
        synchronized (metadataSource) {
            if (!this.getExistingColumns(tableName).contains(columnName)) {
                value = null;
                isArray = false;
            } else {
                CachedStatement result = this.prepareStatement(type, tableName, toSearch.preferredIndex);
                value = result.getValue(toSearch.identifier, columnName);
                isArray = value instanceof java.sql.Array;
                if (isArray) {
                    java.sql.Array array = (java.sql.Array)value;
                    value = array.getArray();
                    array.free();
                }
                toSearch.preferredIndex = this.recycle(result, toSearch.preferredIndex);
            }
        }
        if (isArray && (wantCollection || !elementType.isPrimitive())) {
            Object[] values = new Object[Array.getLength(value)];
            for (int i = 0; i < values.length; ++i) {
                Object element = Array.get(value, i);
                if (element != null) {
                    if (isMetadata) {
                        element = this.lookup(elementType, element.toString(), false);
                    } else {
                        try {
                            element = info.convert(elementType, element);
                        }
                        catch (UnconvertibleObjectException e) {
                            throw new MetadataStoreException(Errors.format((short)59, Strings.toIndexed(columnName, i), elementType, element.getClass()), e);
                        }
                    }
                }
                values[i] = element;
            }
            value = values;
            if (wantCollection) {
                value = MetadataSource.specialize(UnmodifiableArrayList.wrap(values), returnType, elementType);
            }
        }
        if (value != null) {
            if (isMetadata) {
                value = this.lookup(elementType, value.toString(), false);
            } else {
                try {
                    value = info.convert(elementType, value);
                }
                catch (UnconvertibleObjectException e) {
                    throw new MetadataStoreException(Errors.format((short)59, columnName, elementType, value.getClass()), e);
                }
            }
            if (wantCollection) {
                if (Set.class.isAssignableFrom(returnType)) {
                    return Collections.singleton(value);
                }
                return Collections.singletonList(value);
            }
        }
        return value;
    }

    static CodeList<?> getCodeList(Class<?> type, String name) {
        return Types.forCodeName(type.asSubclass(CodeList.class), name, true);
    }

    private static <E> Collection<?> specialize(Collection<?> collection, Class<?> returnType, Class<E> elementType) {
        AbstractSet enumeration;
        if (!returnType.isAssignableFrom(Set.class)) {
            return collection;
        }
        if (CodeList.class.isAssignableFrom(elementType)) {
            enumeration = new CodeListSet<E>(elementType);
        } else if (Enum.class.isAssignableFrom(elementType)) {
            enumeration = EnumSet.noneOf(elementType);
        } else {
            if (Set.class.isAssignableFrom(returnType)) {
                if (SortedSet.class.isAssignableFrom(returnType)) {
                    collection = collection.isEmpty() ? Collections.emptySortedSet() : Collections.unmodifiableSortedSet(new TreeSet(collection));
                } else {
                    switch (collection.size()) {
                        case 0: {
                            collection = Collections.emptySet();
                            break;
                        }
                        case 1: {
                            collection = Collections.singleton(CollectionsExt.first(collection));
                            break;
                        }
                        default: {
                            collection = Collections.unmodifiableSet(new LinkedHashSet(collection));
                        }
                    }
                }
            }
            return collection;
        }
        for (Object e : collection) {
            enumeration.add(elementType.cast(e));
        }
        return Collections.unmodifiableSet(enumeration);
    }

    final void warning(Class<? extends MetadataSource> source, String method, LogRecord record) {
        record.setSourceClassName(source.getCanonicalName());
        record.setSourceMethodName(method);
        record.setLoggerName("org.apache.sis.sql");
        Filter filter = this.logFilter;
        if (filter == null || filter.isLoggable(record)) {
            CachedStatement.LOGGER.log(record);
        }
    }

    public Filter setWarningFilter(Filter filter) {
        Filter p = this.logFilter;
        this.logFilter = filter;
        return p;
    }

    public Filter getWarningFilter() {
        return this.logFilter;
    }

    private void scheduleCloseTask() {
        if (!this.isCloseScheduled) {
            DelayedExecutor.schedule(new CloseTask(System.nanoTime() + 2500000000L));
            this.isCloseScheduled = true;
        }
    }

    final synchronized void closeExpired() {
        this.isCloseScheduled = false;
        long delay = 0L;
        long currentTime = System.nanoTime();
        for (int i = 0; i < this.statements.length; ++i) {
            CachedStatement statement = this.statements[i];
            if (statement == null) continue;
            long wait = statement.expireTime - currentTime;
            if (wait > delay) {
                delay = wait;
                continue;
            }
            this.statements[i] = null;
            this.closeQuietly(statement);
        }
        if (delay > 0L) {
            DelayedExecutor.schedule(new CloseTask(currentTime + delay + 500000000L));
            this.isCloseScheduled = true;
        } else {
            Connection c = this.connection;
            this.connection = null;
            this.helper = null;
            this.closeQuietly(c);
        }
    }

    private void closeQuietly(AutoCloseable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (Exception e) {
                LogRecord record = new LogRecord(Level.WARNING, e.toString());
                record.setThrown(e);
                this.warning(MetadataSource.class, "closeExpired", record);
            }
        }
    }

    @Override
    public synchronized void close() throws MetadataStoreException {
        try {
            for (int i = 0; i < this.statements.length; ++i) {
                CachedStatement statement = this.statements[i];
                if (statement == null) continue;
                statement.close();
                this.statements[i] = null;
            }
            if (this.connection != null) {
                this.connection.close();
                this.connection = null;
            }
            this.helper = null;
        }
        catch (SQLException e) {
            throw new MetadataStoreException(e.getLocalizedMessage(), Exceptions.unwrap(e));
        }
    }

    static {
        SystemListener.add(new SystemListener("org.apache.sis.metadata"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void classpathChanged() {
                Class<MetadataSource> clazz = MetadataSource.class;
                synchronized (MetadataSource.class) {
                    instance = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private final class CloseTask
    extends DelayedRunnable {
        CloseTask(long timestamp) {
            super(timestamp);
        }

        @Override
        public void run() {
            MetadataSource.this.closeExpired();
        }
    }
}

