/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.lineage;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Collection;
import java.util.Date;
import org.apache.sis.metadata.TitleProperty;
import org.apache.sis.metadata.internal.TemporalUtilities;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.util.iso.Types;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gmi.LE_ProcessStep;
import org.apache.sis.xml.bind.gml.TM_Primitive;
import org.apache.sis.xml.bind.metadata.MD_Scope;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.ProcessStepReport;
import org.opengis.metadata.lineage.Processing;
import org.opengis.metadata.lineage.Source;
import org.opengis.metadata.quality.Scope;
import org.opengis.temporal.TemporalPrimitive;
import org.opengis.util.InternationalString;

@TitleProperty(name="description")
@XmlType(name="LI_ProcessStep_Type", propOrder={"description", "rationale", "stepDateTime", "date", "processors", "reference", "scope", "sources", "outputs", "processingInformation", "reports"})
@XmlRootElement(name="LI_ProcessStep")
@XmlSeeAlso(value={LE_ProcessStep.class})
public class DefaultProcessStep
extends ISOMetadata
implements ProcessStep {
    private static final long serialVersionUID = -2338712901907082970L;
    private InternationalString description;
    private InternationalString rationale;
    private TemporalPrimitive stepDateTime;
    private Collection<ResponsibleParty> processors;
    private Collection<Citation> references;
    private Scope scope;
    private Collection<Source> sources;
    private Collection<Source> outputs;
    private Processing processingInformation;
    private Collection<ProcessStepReport> reports;

    public DefaultProcessStep() {
    }

    public DefaultProcessStep(CharSequence description) {
        this.description = Types.toInternationalString(description);
    }

    public DefaultProcessStep(ProcessStep object) {
        super(object);
        if (object != null) {
            this.description = object.getDescription();
            this.rationale = object.getRationale();
            this.stepDateTime = TemporalUtilities.createInstant(object.getDate());
            this.processors = this.copyCollection(object.getProcessors(), ResponsibleParty.class);
            this.sources = this.copyCollection(object.getSources(), Source.class);
            this.outputs = this.copyCollection(object.getOutputs(), Source.class);
            this.processingInformation = object.getProcessingInformation();
            this.reports = this.copyCollection(object.getReports(), ProcessStepReport.class);
            if (object instanceof DefaultProcessStep) {
                this.references = this.copyCollection(((DefaultProcessStep)object).getReferences(), Citation.class);
                this.scope = ((DefaultProcessStep)object).getScope();
            }
        }
    }

    public static DefaultProcessStep castOrCopy(ProcessStep object) {
        if (object == null || object instanceof DefaultProcessStep) {
            return (DefaultProcessStep)object;
        }
        return new DefaultProcessStep(object);
    }

    @Override
    @XmlElement(name="description", required=true)
    public InternationalString getDescription() {
        return this.description;
    }

    public void setDescription(InternationalString newValue) {
        this.checkWritePermission(this.description);
        this.description = newValue;
    }

    @Override
    @XmlElement(name="rationale")
    public InternationalString getRationale() {
        return this.rationale;
    }

    public void setRationale(InternationalString newValue) {
        this.checkWritePermission(this.rationale);
        this.rationale = newValue;
    }

    @XmlElement(name="stepDateTime")
    @XmlJavaTypeAdapter(value=TM_Primitive.Since2014.class)
    public TemporalPrimitive getStepDateTime() {
        return this.stepDateTime;
    }

    public void setStepDateTime(TemporalPrimitive newValue) {
        this.checkWritePermission(this.stepDateTime);
        this.stepDateTime = newValue;
    }

    @Override
    @Deprecated(since="1.0")
    @XmlElement(name="dateTime", namespace="http://www.isotc211.org/2005/gmd")
    public Date getDate() {
        return FilterByVersion.LEGACY_METADATA.accept() ? TemporalUtilities.getDate(this.getStepDateTime()) : null;
    }

    @Deprecated(since="1.0")
    public void setDate(Date newValue) {
        this.setStepDateTime(TemporalUtilities.createInstant(newValue));
    }

    @XmlElement(name="processor")
    public Collection<ResponsibleParty> getProcessors() {
        this.processors = this.nonNullCollection(this.processors, ResponsibleParty.class);
        return this.processors;
    }

    public void setProcessors(Collection<? extends ResponsibleParty> newValues) {
        this.processors = this.writeCollection(newValues, this.processors, ResponsibleParty.class);
    }

    @UML(identifier="reference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getReferences() {
        this.references = this.nonNullCollection(this.references, Citation.class);
        return this.references;
    }

    public void setReferences(Collection<? extends Citation> newValues) {
        this.references = this.writeCollection(newValues, this.references, Citation.class);
    }

    @XmlElement(name="scope")
    @XmlJavaTypeAdapter(value=MD_Scope.Since2014.class)
    @UML(identifier="scope", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope newValue) {
        this.checkWritePermission(this.scope);
        this.scope = newValue;
    }

    @XmlElement(name="source")
    public Collection<Source> getSources() {
        this.sources = this.nonNullCollection(this.sources, Source.class);
        return this.sources;
    }

    public void setSources(Collection<? extends Source> newValues) {
        this.sources = this.writeCollection(newValues, this.sources, Source.class);
    }

    @XmlElement(name="output")
    public Collection<Source> getOutputs() {
        this.outputs = this.nonNullCollection(this.outputs, Source.class);
        return this.outputs;
    }

    public void setOutputs(Collection<? extends Source> newValues) {
        this.outputs = this.writeCollection(newValues, this.outputs, Source.class);
    }

    @Override
    @XmlElement(name="processingInformation")
    public Processing getProcessingInformation() {
        return this.processingInformation;
    }

    public void setProcessingInformation(Processing newValue) {
        this.checkWritePermission(this.processingInformation);
        this.processingInformation = newValue;
    }

    @XmlElement(name="report")
    public Collection<ProcessStepReport> getReports() {
        this.reports = this.nonNullCollection(this.reports, ProcessStepReport.class);
        return this.reports;
    }

    public void setReports(Collection<? extends ProcessStepReport> newValues) {
        this.reports = this.writeCollection(newValues, this.reports, ProcessStepReport.class);
    }

    @XmlElement(name="reference")
    private Collection<Citation> getReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getReferences() : null;
    }
}

