/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.FormatService;
import javax.measure.spi.QuantityFactory;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnits;
import javax.measure.spi.SystemOfUnitsService;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.DefaultQuantityFactory;
import org.apache.sis.measure.QuantityFormat;
import org.apache.sis.measure.ScalarFallback;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.UnitRegistry;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.util.logging.Logging;

public class UnitServices
extends ServiceProvider
implements SystemOfUnitsService,
FormatService {
    private final UnitRegistry[] systems = new UnitRegistry[]{new UnitRegistry("SI", 2), new UnitRegistry("SI + accepted", 6), new UnitRegistry("Imperial", 16), new UnitRegistry("CGS", 8), new UnitRegistry("SI + other", -1)};

    @Override
    public SystemOfUnits getSystemOfUnits() {
        return this.systems[this.systems.length - 1];
    }

    @Override
    public SystemOfUnits getSystemOfUnits(String name) {
        ArgumentChecks.ensureNonEmpty("name", name);
        for (UnitRegistry s2 : this.systems) {
            if (!CharSequences.equalsFiltered(s2.name, name, Characters.Filter.UNICODE_IDENTIFIER, true)) continue;
            return s2;
        }
        return null;
    }

    @Override
    public Collection<SystemOfUnits> getAvailableSystemsOfUnits() {
        return UnmodifiableArrayList.wrap(this.systems);
    }

    @Override
    public SystemOfUnitsService getSystemOfUnitsService() {
        return this;
    }

    @Override
    public javax.measure.format.UnitFormat getUnitFormat() {
        return new UnitFormat(Locale.getDefault(Locale.Category.FORMAT));
    }

    @Override
    public javax.measure.format.UnitFormat getUnitFormat(String name) {
        UnitFormat.Style style;
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        name = name.toUpperCase(locale).trim();
        try {
            style = UnitFormat.Style.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            Logging.recoverableException(AbstractUnit.LOGGER, UnitServices.class, "getUnitFormat", e);
            return null;
        }
        UnitFormat f = new UnitFormat(locale);
        f.setStyle(style);
        return f;
    }

    @Override
    public javax.measure.format.UnitFormat getUnitFormat(String name, String variant) {
        return this.getUnitFormat(name);
    }

    @Override
    public javax.measure.format.QuantityFormat getQuantityFormat() {
        return new QuantityFormat(Locale.getDefault(Locale.Category.FORMAT));
    }

    @Override
    public javax.measure.format.QuantityFormat getQuantityFormat(String name) {
        javax.measure.format.UnitFormat unitFormat = this.getUnitFormat(name);
        if (unitFormat instanceof UnitFormat) {
            return new QuantityFormat(NumberFormat.getInstance(), (UnitFormat)unitFormat);
        }
        return null;
    }

    @Override
    public Set<String> getAvailableFormatNames(FormatService.FormatType type) {
        HashSet<String> names = new HashSet<String>(4);
        for (UnitFormat.Style e : UnitFormat.Style.values()) {
            names.add(e.name());
        }
        return names;
    }

    @Override
    public FormatService getFormatService() {
        return this;
    }

    @Override
    public <Q extends Quantity<Q>> QuantityFactory<Q> getQuantityFactory(final Class<Q> type) {
        ArgumentChecks.ensureNonNull("type", type);
        QuantityFactory<Q> factory = Units.get(type);
        if (factory == null) {
            factory = type != null ? new DefaultQuantityFactory<Q>(){

                @Override
                public Quantity<Q> create(Number value, Unit<Q> unit) {
                    return ScalarFallback.factory(AbstractConverter.doubleValue(value), unit, type);
                }
            } : new DefaultQuantityFactory();
        }
        return factory;
    }
}

