/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.SeekableByteChannel;
import org.apache.sis.io.stream.Markable;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelData
implements Markable {
    private static final int BIT_OFFSET_SIZE = 3;
    public final String filename;
    public final ByteBuffer buffer;
    public final long channelOffset;
    long bufferOffset;
    private long bitPosition;
    private Mark mark;

    ChannelData(String filename, Channel channel, ByteBuffer buffer) throws IOException {
        this.filename = filename;
        this.buffer = buffer;
        this.channelOffset = channel instanceof SeekableByteChannel ? ((SeekableByteChannel)channel).position() : 0L;
    }

    ChannelData(ChannelData old) {
        this.filename = old.filename;
        this.buffer = old.buffer;
        this.channelOffset = old.channelOffset;
        this.bufferOffset = old.bufferOffset;
        this.bitPosition = old.bitPosition;
        this.mark = old.mark;
    }

    ChannelData(String filename, ByteBuffer data) {
        this.filename = filename;
        this.buffer = data.asReadOnlyBuffer();
        this.buffer.order(data.order());
        this.channelOffset = 0L;
    }

    final int readBitFromBuffer() {
        int bitOffset;
        int bp = this.buffer.position();
        long position = Math.addExact(this.bufferOffset, (long)bp);
        if (this.bitPosition >>> 3 != position) {
            this.bitPosition = position << 3;
        }
        byte value = (bitOffset = 7 - (int)(this.bitPosition++ & 7L)) != 0 ? this.buffer.get(bp) : this.buffer.get();
        return (value & 1 << bitOffset) == 0 ? 0 : 1;
    }

    public final int getBitOffset() {
        long position = this.position();
        if (this.bitPosition >>> 3 != position) {
            this.bitPosition = position << 3;
        }
        return (int)(this.bitPosition & 7L);
    }

    public final void setBitOffset(int bitOffset) {
        ArgumentChecks.ensureBetween("bitOffset", 0, 7, bitOffset);
        this.bitPosition = this.position() << 3 | (long)bitOffset;
    }

    public final void skipRemainingBits() {
        if (this.bitPosition != 0L) {
            if (this.getBitOffset() != 0) {
                this.buffer.get();
            }
            this.clearBitOffset();
        }
    }

    final void clearBitOffset() {
        this.bitPosition = 0L;
    }

    @Override
    public long getStreamPosition() {
        return this.position();
    }

    private long position() {
        return Math.addExact(this.bufferOffset, (long)this.buffer.position());
    }

    public final void setStreamPosition(long position) {
        this.bufferOffset = Math.subtractExact(position, (long)this.buffer.position());
        this.clearBitOffset();
        this.mark = null;
    }

    public final long getFlushedPosition() {
        return this.bufferOffset;
    }

    public final void flushBefore(long position) throws IOException {
        long currentPosition = this.getStreamPosition();
        if (position > currentPosition) {
            throw new IndexOutOfBoundsException(Errors.format((short)166, "position", this.bufferOffset, currentPosition, position));
        }
        if (this.buffer.isReadOnly()) {
            return;
        }
        int n = (int)Math.max(position - this.bufferOffset, 0L);
        int p = this.buffer.position() - n;
        int r = this.buffer.limit() - n;
        this.flushAndSetPosition(n);
        this.buffer.compact().position(p).limit(r);
        Mark lastValid = null;
        Mark m4 = this.mark;
        while (m4 != null) {
            if (m4.position >= position) {
                lastValid = m4;
            }
            m4 = m4.next;
        }
        if (lastValid != null) {
            lastValid.next = null;
        } else {
            this.mark = null;
        }
    }

    void flushAndSetPosition(int position) throws IOException {
        this.buffer.position(position);
        this.bufferOffset += (long)position;
    }

    public abstract void seek(long var1) throws IOException;

    @Override
    public final void mark() {
        this.mark = new Mark(this.getStreamPosition(), (byte)this.getBitOffset(), this.mark);
    }

    @Override
    public final void reset() throws IOException {
        Mark m4 = this.mark;
        if (m4 == null) {
            throw new IOException(Resources.format((short)63));
        }
        this.mark = m4.next;
        this.seek(m4.position);
        this.setBitOffset(m4.bitOffset);
    }

    @Override
    public final void reset(long position) throws IOException {
        Mark lastValid = null;
        while (this.mark != null && this.mark.position >= position) {
            boolean found;
            boolean bl = found = this.mark.position == position;
            if (found) {
                lastValid = this.mark;
            }
            this.mark = this.mark.next;
            if (!found) continue;
            break;
        }
        this.seek(position);
        if (lastValid != null) {
            this.setBitOffset(lastValid.bitOffset);
        }
    }

    protected void onEmptyTransfer() throws IOException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder().append(this.getClass().getSimpleName()).append("[\u201c").append(this.filename).append('\u201d');
        if (this.buffer != null) {
            b.append(" at ").append(this.getStreamPosition());
        }
        return b.append(']').toString();
    }

    private static final class Mark {
        final long position;
        final byte bitOffset;
        Mark next;

        Mark(long position, byte bitOffset, Mark next) {
            this.position = position;
            this.bitOffset = bitOffset;
            this.next = next;
        }
    }
}

