/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image.processing.isoline;

import java.awt.geom.Path2D;
import java.util.Arrays;
import java.util.Map;
import org.apache.sis.geometry.wrapper.j2d.PathBuilder;
import org.apache.sis.image.processing.isoline.PolylineStage;
import org.apache.sis.util.ArraysExt;

final class PolylineBuffer {
    static final int DIMENSION = 2;
    double[] coordinates;
    int size;
    PolylineBuffer opposite;

    PolylineBuffer() {
        this.coordinates = ArraysExt.EMPTY_DOUBLE;
    }

    PolylineBuffer(double[] data) {
        this.coordinates = data;
        this.size = data.length;
    }

    final void clear() {
        this.opposite = null;
        this.size = 0;
    }

    final boolean isEmpty() {
        return this.size == 0 & this.opposite == null;
    }

    final PolylineBuffer attach(PolylineBuffer other) {
        assert (this.opposite == null & other.opposite == null);
        other.opposite = this;
        this.opposite = other;
        return this;
    }

    final PolylineBuffer transferFrom(PolylineBuffer source) {
        assert (this.isEmpty());
        double[] swap = this.coordinates;
        this.coordinates = source.coordinates;
        this.size = source.size;
        this.opposite = source.opposite;
        if (this.opposite != null) {
            this.opposite.opposite = this;
        }
        source.clear();
        source.coordinates = swap;
        return this;
    }

    final boolean transferToOpposite() {
        if (this.opposite == null) {
            return false;
        }
        int sum = this.size + this.opposite.size;
        double[] data = this.opposite.coordinates;
        if (sum > data.length) {
            data = new double[sum];
        }
        System.arraycopy(this.opposite.coordinates, 0, data, this.size, this.opposite.size);
        int i = 0;
        int t2 = this.size;
        while ((t2 -= 2) >= 0) {
            data[t2] = this.coordinates[i++];
            data[t2 + 1] = this.coordinates[i++];
        }
        this.opposite.size = sum;
        this.opposite.coordinates = data;
        this.opposite.opposite = null;
        this.clear();
        return true;
    }

    final void append(double x, double y) {
        if (this.size >= this.coordinates.length) {
            this.coordinates = Arrays.copyOf(this.coordinates, Math.max(Math.multiplyExact(this.size, 2), 32));
        }
        this.coordinates[this.size++] = x;
        this.coordinates[this.size++] = y;
    }

    public String toString() {
        return PathBuilder.toString(this.coordinates, this.size);
    }

    final void toRawPath(Map<PolylineStage, Path2D> appendTo) {
        PolylineStage.BUFFER.add(appendTo, this.coordinates, this.size);
    }
}

