/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = 6323915437380051705L;
    protected final int dimension;
    private final int hasZM;
    private static final int Z_MASK = 1;
    private static final int M_MASK = 2;

    PackedCoordinateSequence(PackedCoordinateSequence original) {
        this.dimension = original.dimension;
        this.hasZM = original.hasZM;
    }

    PackedCoordinateSequence(int dimension, int measures) {
        int hasZM;
        ArgumentChecks.ensurePositive("measures", measures);
        ArgumentChecks.ensureBetween("dimension", 2 + measures, Math.addExact(3, measures), dimension);
        this.dimension = dimension;
        int n = hasZM = measures == 0 ? 0 : 2;
        if (dimension - measures >= 3) {
            hasZM |= 1;
        }
        this.hasZM = hasZM;
    }

    private static int getSpatialDimension(int hasZM) {
        return 2 | hasZM & 1;
    }

    public final int getDimension() {
        return this.dimension;
    }

    public final int getMeasures() {
        return this.dimension - PackedCoordinateSequence.getSpatialDimension(this.hasZM);
    }

    public final boolean hasZ() {
        return (this.hasZM & 1) != 0;
    }

    public final boolean hasM() {
        return (this.hasZM & 2) != 0;
    }

    public final double getX(int index) {
        return this.coordinate(index * this.dimension + 0);
    }

    public final double getY(int index) {
        return this.coordinate(index * this.dimension + 1);
    }

    public final double getZ(int index) {
        return (this.hasZM & 1) != 0 ? this.coordinate(index * this.dimension + 2) : java.lang.Double.NaN;
    }

    public final double getM(int index) {
        switch (this.hasZM) {
            default: {
                return java.lang.Double.NaN;
            }
            case 2: {
                return this.coordinate(index * this.dimension + 2);
            }
            case 3: 
        }
        return this.coordinate(index * this.dimension + 3);
    }

    public final Coordinate getCoordinate(int index) {
        double x = this.coordinate(index *= this.dimension);
        double y = this.coordinate(++index);
        switch (this.hasZM) {
            default: {
                return new Coordinate(x, y);
            }
            case 0: {
                return new CoordinateXY(x, y);
            }
            case 1: {
                return new Coordinate(x, y, this.coordinate(++index));
            }
            case 2: {
                return new CoordinateXYM(x, y, this.coordinate(++index));
            }
            case 3: 
        }
        return new CoordinateXYZM(x, y, this.coordinate(++index), this.coordinate(++index));
    }

    public final void getCoordinate(int index, Coordinate dest) {
        dest.x = this.coordinate(index *= this.dimension);
        dest.y = this.coordinate(++index);
        switch (this.hasZM) {
            case 1: {
                dest.setZ(this.coordinate(++index));
                break;
            }
            case 3: {
                dest.setZ(this.coordinate(++index));
            }
            case 2: {
                dest.setM(this.coordinate(++index));
            }
        }
    }

    public final Coordinate getCoordinateCopy(int index) {
        return this.getCoordinate(index);
    }

    public final double getOrdinate(int index, int dim) {
        return this.coordinate(index * this.dimension + dim);
    }

    abstract double coordinate(int var1);

    abstract void setCoordinates(Coordinate[] var1);

    void setCoordinates(CoordinateSequence values) {
        this.setCoordinates(values.toCoordinateArray());
    }

    public final Coordinate[] toCoordinateArray() {
        Coordinate[] coordinates = new Coordinate[this.size()];
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = this.getCoordinate(i);
        }
        return coordinates;
    }

    public final String toString() {
        return CoordinateSequences.toString((CoordinateSequence)this);
    }

    public int hashCode() {
        return 37 * this.dimension ^ this.hasZM;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            PackedCoordinateSequence other = (PackedCoordinateSequence)obj;
            return other.dimension == this.dimension && other.hasZM == this.hasZM;
        }
        return false;
    }

    @Deprecated
    public final Object clone() {
        return this.copy();
    }

    static final class Float
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 2625498691139718968L;
        private final float[] coordinates;

        private Float(Float original) {
            super(original);
            this.coordinates = (float[])original.coordinates.clone();
        }

        Float(float[] array, int length) {
            super(2, 0);
            this.coordinates = Arrays.copyOf(array, length);
        }

        Float(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coordinates = new float[Math.multiplyExact(size, dimension)];
        }

        public int size() {
            return this.coordinates.length / this.dimension;
        }

        @Override
        double coordinate(int index) {
            return this.coordinates[index];
        }

        public void setOrdinate(int index, int dim, double value) {
            this.coordinates[index * this.dimension + dim] = (float)value;
        }

        @Override
        void setCoordinates(Coordinate[] values) {
            int t2 = 0;
            for (Coordinate c : values) {
                for (int i = 0; i < this.dimension; ++i) {
                    this.coordinates[t2++] = (float)c.getOrdinate(i);
                }
            }
            assert (t2 == this.coordinates.length);
        }

        @Override
        void setCoordinates(CoordinateSequence values) {
            if (values instanceof PackedCoordinateSequence.Float) {
                System.arraycopy(((PackedCoordinateSequence.Float)values).getRawCoordinates(), 0, this.coordinates, 0, this.coordinates.length);
            } else {
                super.setCoordinates(values);
            }
        }

        public Envelope expandEnvelope(Envelope envelope) {
            for (int i = 0; i < this.coordinates.length; i += this.dimension) {
                envelope.expandToInclude((double)this.coordinates[i], (double)this.coordinates[i + 1]);
            }
            return envelope;
        }

        public CoordinateSequence copy() {
            return new Float(this);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.coordinates) + super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Arrays.equals(((Float)obj).coordinates, this.coordinates);
        }
    }

    static final class Double
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 1940132733783453171L;
        private final double[] coordinates;

        private Double(Double original) {
            super(original);
            this.coordinates = (double[])original.coordinates.clone();
        }

        Double(double[] array, int length) {
            super(2, 0);
            this.coordinates = Arrays.copyOf(array, length);
        }

        Double(int size, int dimension, int measures) {
            super(dimension, measures);
            this.coordinates = new double[Math.multiplyExact(size, dimension)];
        }

        public int size() {
            return this.coordinates.length / this.dimension;
        }

        @Override
        double coordinate(int index) {
            return this.coordinates[index];
        }

        public void setOrdinate(int index, int dim, double value) {
            this.coordinates[index * this.dimension + dim] = value;
        }

        @Override
        void setCoordinates(Coordinate[] values) {
            int t2 = 0;
            for (Coordinate c : values) {
                for (int i = 0; i < this.dimension; ++i) {
                    this.coordinates[t2++] = c.getOrdinate(i);
                }
            }
            assert (t2 == this.coordinates.length);
        }

        @Override
        void setCoordinates(CoordinateSequence values) {
            if (values instanceof PackedCoordinateSequence.Double) {
                System.arraycopy(((PackedCoordinateSequence.Double)values).getRawCoordinates(), 0, this.coordinates, 0, this.coordinates.length);
            } else {
                super.setCoordinates(values);
            }
        }

        public Envelope expandEnvelope(Envelope envelope) {
            for (int i = 0; i < this.coordinates.length; i += this.dimension) {
                envelope.expandToInclude(this.coordinates[i], this.coordinates[i + 1]);
            }
            return envelope;
        }

        public CoordinateSequence copy() {
            return new Double(this);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.coordinates) + super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Arrays.equals(((Double)obj).coordinates, this.coordinates);
        }
    }
}

