/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.iso.DefaultNameFactory;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.NameFactory;

public class AbstractIdentifiedType
implements Deprecable,
Serializable {
    private static final long serialVersionUID = 277130188958446740L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.feature");
    public static final String NAME_KEY = "name";
    public static final String DEFINITION_KEY = "definition";
    public static final String DESIGNATION_KEY = "designation";
    public static final String DESCRIPTION_KEY = "description";
    public static final String DEPRECATED_KEY = "deprecated";
    private final GenericName name;
    private final InternationalString definition;
    private final InternationalString designation;
    private final InternationalString description;
    final boolean deprecated;

    protected AbstractIdentifiedType(Map<String, ?> identification) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("identification", identification);
        Object value = identification.get(NAME_KEY);
        if (value == null) {
            throw new IllegalArgumentException(Errors.getResources(identification).getString((short)89, NAME_KEY));
        }
        if (value instanceof String) {
            this.name = this.createName(DefaultNameFactory.provider(), (String)value);
        } else if (value instanceof GenericName) {
            this.name = (GenericName)value;
        } else {
            throw AbstractIdentifiedType.illegalPropertyType(identification, NAME_KEY, value);
        }
        this.definition = Types.toInternationalString(identification, DEFINITION_KEY);
        this.designation = Types.toInternationalString(identification, DESIGNATION_KEY);
        this.description = Types.toInternationalString(identification, DESCRIPTION_KEY);
        value = identification.get(DEPRECATED_KEY);
        if (value == null) {
            this.deprecated = false;
        } else if (value instanceof Boolean) {
            this.deprecated = (Boolean)value;
        } else {
            throw AbstractIdentifiedType.illegalPropertyType(identification, DEPRECATED_KEY, value);
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> identification, String key, Object value) {
        return new IllegalArgumentException(Errors.getResources(identification).getString((short)58, key, value.getClass()));
    }

    GenericName createName(NameFactory factory, String value) {
        return factory.createLocalName(null, value);
    }

    public final GenericName getName() {
        return this.name;
    }

    public InternationalString getDefinition() {
        return this.definition;
    }

    public InternationalString getDesignation() {
        return this.designation;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public InternationalString getRemarks() {
        return this.deprecated ? this.description : null;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.definition, this.designation, this.description, this.deprecated);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            AbstractIdentifiedType that = (AbstractIdentifiedType)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition) && Objects.equals(this.designation, that.designation) && Objects.equals(this.description, that.description) && this.deprecated == that.deprecated;
        }
        return false;
    }

    static String toString(GenericName name, AbstractIdentifiedType container, String argument, int index) {
        short key = 89;
        if (name != null) {
            String s2 = name.toString();
            if (!s2.isEmpty()) {
                return s2;
            }
            key = 32;
        }
        StringBuilder b = new StringBuilder(40).append("Type[\u201c").append(container.getName()).append("\u201d].").append(argument).append('[').append(index).append("].name");
        throw new IllegalArgumentException(Errors.format(key, b.toString()));
    }
}

