/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.Arrays;
import org.apache.sis.image.DataType;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;

public final class SampleModelFactory {
    private int dataType;
    private final int width;
    private final int height;
    private int numBands;
    private int[] bankIndices;
    private int[] bandOffsets;
    private int[] bitMasks;
    private int dataBitOffset;
    private int numberOfBits;
    private int pixelStride;
    private int scanlineStride;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SampleModelFactory(DataType type, int width, int height, int numBands, int bitsPerSample, boolean isBanded) {
        this.dataType = type.toDataBufferType();
        this.width = width;
        this.height = height;
        this.numBands = numBands;
        this.scanlineStride = width;
        this.pixelStride = 1;
        if (bitsPerSample != type.size()) {
            if (numBands == 1) {
                this.pixelStride = 0;
                this.numberOfBits = bitsPerSample;
                this.scanlineStride = Numerics.ceilDiv(Math.multiplyExact(width, this.numberOfBits), type.size());
                return;
            } else {
                if (isBanded) throw new RasterFormatException(Errors.format((short)163, "bitsPerSample=" + type.size()));
                this.bitMasks = new int[numBands];
                this.bitMasks[0] = (1 << bitsPerSample) - 1;
                for (int i = 1; i < this.bitMasks.length; ++i) {
                    this.bitMasks[i] = this.bitMasks[i - 1] << bitsPerSample;
                }
            }
            return;
        } else if (isBanded) {
            this.bankIndices = ArraysExt.range(0, numBands);
            this.bandOffsets = new int[numBands];
            return;
        } else {
            this.bandOffsets = ArraysExt.range(0, numBands);
            this.scanlineStride = Math.multiplyExact(numBands, width);
            this.pixelStride = numBands;
        }
    }

    public SampleModelFactory(SampleModel model) {
        this.width = model.getWidth();
        this.height = model.getHeight();
        this.numBands = model.getNumBands();
        this.dataType = model.getDataType();
        if (model instanceof ComponentSampleModel) {
            ComponentSampleModel cm = (ComponentSampleModel)model;
            this.bankIndices = cm.getBankIndices();
            this.bandOffsets = cm.getBandOffsets();
            this.scanlineStride = cm.getScanlineStride();
            this.pixelStride = cm.getPixelStride();
            for (int i = 0; i < this.bankIndices.length; ++i) {
                if (this.bankIndices[i] == 0) continue;
                return;
            }
            this.bankIndices = null;
        } else if (model instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel cm = (SinglePixelPackedSampleModel)model;
            this.bitMasks = cm.getBitMasks();
            this.scanlineStride = cm.getScanlineStride();
            this.pixelStride = 1;
        } else if (model instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel cm = (MultiPixelPackedSampleModel)model;
            this.numberOfBits = cm.getPixelBitStride();
            this.dataBitOffset = cm.getDataBitOffset();
            this.scanlineStride = cm.getScanlineStride();
        } else {
            throw new RasterFormatException(Errors.format((short)163, model.getClass()));
        }
    }

    public void subsetAndCompress(int[] bands) {
        ArgumentChecks.ensureCountBetween("bands", true, 1, this.numBands, bands.length);
        if (this.bankIndices != null) {
            this.bankIndices = SampleModelFactory.subset(this.bankIndices, bands, true);
        }
        if (this.bandOffsets != null) {
            this.bandOffsets = SampleModelFactory.subset(this.bandOffsets, bands, this.bankIndices == null);
        }
        if (this.bitMasks != null) {
            int i;
            int[] shifts = new int[this.bitMasks.length];
            for (i = 0; i < shifts.length; ++i) {
                shifts[i] = SampleModelFactory.bitCount(this.bitMasks[i]);
            }
            for (i = 0; i < bands.length; ++i) {
                shifts[bands[i]] = 0;
            }
            for (i = 1; i < shifts.length; ++i) {
                int n = i;
                shifts[n] = shifts[n] + shifts[i - 1];
            }
            int[] masks = new int[bands.length];
            int allMasks = 0;
            for (int i2 = 0; i2 < bands.length; ++i2) {
                int b = bands[i2];
                masks[i2] = this.bitMasks[b] >>> shifts[b];
                allMasks |= masks[i2];
            }
            this.bitMasks = masks;
            if (this.dataType == 3 && (allMasks & 0xFFFF0000) == 0) {
                this.dataType = 1;
            }
            if (this.dataType == 1 && (allMasks & 0xFFFFFF00) == 0) {
                this.dataType = 0;
            }
        }
        if (this.pixelStride > 1) {
            int s2 = this.scanlineStride / this.pixelStride;
            int r = this.scanlineStride % this.pixelStride;
            this.pixelStride -= this.numBands - bands.length;
            this.scanlineStride = this.pixelStride * s2 + r;
        }
        this.numBands = bands.length;
    }

    private static int bitCount(int mask) {
        return 32 - Integer.numberOfLeadingZeros(mask) - Integer.numberOfTrailingZeros(mask);
    }

    private static int[] subset(int[] data, int[] bands, boolean compress) {
        int[] subset = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            subset[i] = data[bands[i]];
        }
        if (!compress) {
            return subset;
        }
        Arrays.sort(subset);
        int[] indices = new int[subset.length];
        for (int i = 0; i < bands.length; ++i) {
            indices[i] = Arrays.binarySearch(subset, data[bands[i]]);
            assert (indices[i] >= 0);
        }
        return indices;
    }

    public SampleModel build() {
        if (this.pixelStride == 1) {
            if (this.bankIndices != null) {
                return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, this.bankIndices, this.bandOffsets);
            }
            if (this.bitMasks != null) {
                return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, this.bitMasks);
            }
        }
        if (this.numberOfBits != 0) {
            return new MultiPixelPackedSampleModel(this.dataType, this.width, this.height, this.numberOfBits, this.scanlineStride, this.dataBitOffset);
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, this.bandOffsets);
    }
}

