/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.DataFormatType;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.LayoutBBTiled;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.LayoutSegmented;
import ucar.nc2.iosp.LayoutTiled;
import ucar.nc2.iosp.hdf4.H4header;
import ucar.nc2.iosp.hdf4.TagEnum;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.unidata.io.PositioningDataInputStream;
import ucar.unidata.io.RandomAccessFile;

public class H4iosp
extends AbstractIOServiceProvider {
    private static Logger log = LoggerFactory.getLogger(H4iosp.class);
    private static boolean showLayoutTypes = false;
    private H4header header = new H4header();

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return H4header.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        if (this.header.isEos()) {
            return "HDF4-EOS";
        }
        return DataFormatType.HDF4.toString();
    }

    @Override
    public String getFileTypeDescription() {
        return "Hierarchical Data Format, version 4";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.header.read(raf, ncfile);
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        if (v instanceof Structure) {
            return this.readStructureData((Structure)v, section);
        }
        H4header.Vinfo vinfo = (H4header.Vinfo)v.getSPobject();
        DataType dataType = v.getDataType();
        vinfo.setLayoutInfo();
        section = Section.fill(section, v.getShape());
        if (vinfo.hasNoData) {
            Object arr;
            Object object = arr = vinfo.fillValue == null ? IospHelper.makePrimitiveArray((int)section.computeSize(), dataType) : IospHelper.makePrimitiveArray((int)section.computeSize(), dataType, vinfo.fillValue);
            if (dataType == DataType.CHAR) {
                arr = IospHelper.convertByteToChar((byte[])arr);
            }
            return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), arr);
        }
        if (!vinfo.isCompressed) {
            if (!vinfo.isLinked && !vinfo.isChunked) {
                LayoutRegular layout = new LayoutRegular(vinfo.start, v.getElementSize(), v.getShape(), section);
                Object data = IospHelper.readDataFill(this.raf, layout, dataType, vinfo.fillValue, -1);
                return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
            }
            if (vinfo.isLinked) {
                LayoutSegmented layout = new LayoutSegmented(vinfo.segPos, vinfo.segSize, v.getElementSize(), v.getShape(), section);
                Object data = IospHelper.readDataFill(this.raf, layout, dataType, vinfo.fillValue, -1);
                return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
            }
            if (vinfo.isChunked) {
                H4ChunkIterator chunkIterator = new H4ChunkIterator(vinfo);
                LayoutTiled layout = new LayoutTiled(chunkIterator, vinfo.chunkSize, v.getElementSize(), section);
                Object data = IospHelper.readDataFill(this.raf, layout, dataType, vinfo.fillValue, -1);
                return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
            }
        } else {
            if (!vinfo.isLinked && !vinfo.isChunked) {
                if (showLayoutTypes) {
                    System.out.println("***notLinked, compressed");
                }
                LayoutRegular index = new LayoutRegular(0L, v.getElementSize(), v.getShape(), section);
                InputStream is = this.getCompressedInputStream(vinfo);
                PositioningDataInputStream dataSource = new PositioningDataInputStream(is);
                Object data = IospHelper.readDataFill(dataSource, index, dataType, vinfo.fillValue);
                return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
            }
            if (vinfo.isLinked) {
                if (showLayoutTypes) {
                    System.out.println("***Linked, compressed");
                }
                LayoutRegular index = new LayoutRegular(0L, v.getElementSize(), v.getShape(), section);
                InputStream is = this.getLinkedCompressedInputStream(vinfo);
                PositioningDataInputStream dataSource = new PositioningDataInputStream(is);
                Object data = IospHelper.readDataFill(dataSource, index, dataType, vinfo.fillValue);
                return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
            }
            if (vinfo.isChunked) {
                H4CompressedChunkIterator chunkIterator = new H4CompressedChunkIterator(vinfo);
                LayoutBBTiled layout = new LayoutBBTiled(chunkIterator, vinfo.chunkSize, v.getElementSize(), section);
                Object data = IospHelper.readDataFill(layout, dataType, vinfo.fillValue);
                return Array.factory(dataType.getPrimitiveClassType(), section.getShape(), data);
            }
        }
        throw new IllegalStateException();
    }

    private ArrayStructure readStructureData(Structure s2, Section section) throws IOException, InvalidRangeException {
        PositioningDataInputStream dataSource;
        InputStream is;
        H4header.Vinfo vinfo = (H4header.Vinfo)s2.getSPobject();
        vinfo.setLayoutInfo();
        int recsize = vinfo.elemSize;
        StructureMembers members = s2.makeStructureMembers();
        for (StructureMembers.Member m4 : members.getMembers()) {
            Variable v2 = s2.findVariable(m4.getName());
            H4header.Minfo minfo = (H4header.Minfo)v2.getSPobject();
            m4.setDataParam(minfo.offset);
        }
        members.setStructureSize(recsize);
        ArrayStructureBB structureArray = new ArrayStructureBB(members, section.getShape());
        byte[] result = structureArray.getByteBuffer().array();
        if (!vinfo.isLinked && !vinfo.isCompressed) {
            LayoutRegular layout = new LayoutRegular(vinfo.start, recsize, s2.getShape(), section);
            IospHelper.readData(this.raf, layout, DataType.STRUCTURE, result, -1, true);
        } else if (vinfo.isLinked && !vinfo.isCompressed) {
            is = new LinkedInputStream(vinfo);
            dataSource = new PositioningDataInputStream(is);
            LayoutRegular layout = new LayoutRegular(0L, recsize, s2.getShape(), section);
            IospHelper.readData(dataSource, layout, DataType.STRUCTURE, result);
        } else if (!vinfo.isLinked && vinfo.isCompressed) {
            is = this.getCompressedInputStream(vinfo);
            dataSource = new PositioningDataInputStream(is);
            LayoutRegular layout = new LayoutRegular(0L, recsize, s2.getShape(), section);
            IospHelper.readData(dataSource, layout, DataType.STRUCTURE, result);
        } else if (vinfo.isLinked && vinfo.isCompressed) {
            is = this.getLinkedCompressedInputStream(vinfo);
            dataSource = new PositioningDataInputStream(is);
            LayoutRegular layout = new LayoutRegular(0L, recsize, s2.getShape(), section);
            IospHelper.readData(dataSource, layout, DataType.STRUCTURE, result);
        } else {
            throw new IllegalStateException();
        }
        return structureArray;
    }

    @Override
    public String toStringDebug(Object o) {
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            H4header.Vinfo vinfo = (H4header.Vinfo)v.getSPobject();
            return vinfo != null ? vinfo.toString() : "";
        }
        return null;
    }

    private InputStream getCompressedInputStream(H4header.Vinfo vinfo) throws IOException {
        byte[] buffer = new byte[vinfo.length];
        this.raf.seek(vinfo.start);
        this.raf.readFully(buffer);
        ByteArrayInputStream in = new ByteArrayInputStream(buffer);
        return new InflaterInputStream(in);
    }

    private InputStream getLinkedCompressedInputStream(H4header.Vinfo vinfo) {
        return new InflaterInputStream(new LinkedInputStream(vinfo));
    }

    private InputStream getChunkedInputStream(H4header.Vinfo vinfo) {
        return new ChunkedInputStream(vinfo);
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message.toString().equals("header")) {
            return this.header;
        }
        return super.sendIospMessage(message);
    }

    private class DataChunk
    implements LayoutBBTiled.DataChunk {
        private int[] offset;
        private H4header.SpecialComp compress;
        private ByteBuffer bb;

        DataChunk(int[] offset, H4header.SpecialComp compress) {
            this.offset = offset;
            this.compress = compress;
        }

        @Override
        public int[] getOffset() {
            return this.offset;
        }

        @Override
        public ByteBuffer getByteBuffer() throws IOException {
            if (this.bb == null) {
                InputStream in;
                H4header.TagData cdata = this.compress.getDataTag();
                if (cdata.linked == null) {
                    byte[] cbuffer = new byte[cdata.length];
                    H4iosp.this.raf.seek(cdata.offset);
                    H4iosp.this.raf.readFully(cbuffer);
                    in = new ByteArrayInputStream(cbuffer);
                } else {
                    in = new LinkedInputStream(cdata.linked);
                }
                if (this.compress.compress_type == TagEnum.COMP_CODE_DEFLATE) {
                    InflaterInputStream zin = new InflaterInputStream(in);
                    ByteArrayOutputStream out = new ByteArrayOutputStream(this.compress.uncomp_length);
                    IO.copy(zin, out);
                    byte[] buffer = out.toByteArray();
                    this.bb = ByteBuffer.wrap(buffer);
                } else if (this.compress.compress_type == TagEnum.COMP_CODE_NONE) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream(this.compress.uncomp_length);
                    IO.copy(in, out);
                    byte[] buffer = out.toByteArray();
                    this.bb = ByteBuffer.wrap(buffer);
                } else {
                    throw new IllegalStateException("unknown compression type =" + this.compress.compress_type);
                }
            }
            return this.bb;
        }
    }

    private class H4CompressedChunkIterator
    implements LayoutBBTiled.DataChunkIterator {
        List<H4header.DataChunk> chunks;
        int chunkNo;

        H4CompressedChunkIterator(H4header.Vinfo vinfo) {
            this.chunks = vinfo.chunks;
            this.chunkNo = 0;
        }

        @Override
        public boolean hasNext() {
            return this.chunkNo < this.chunks.size();
        }

        @Override
        public LayoutBBTiled.DataChunk next() throws IOException {
            H4header.DataChunk chunk = this.chunks.get(this.chunkNo);
            H4header.TagData chunkData = chunk.data;
            assert (chunkData.ext_type == TagEnum.SPECIAL_COMP);
            ++this.chunkNo;
            return new DataChunk(chunk.origin, chunkData.compress);
        }
    }

    private static class H4ChunkIterator
    implements LayoutTiled.DataChunkIterator {
        List<H4header.DataChunk> chunks;
        int chunkNo;
        byte[] buffer;
        int segPos;
        int segSize;

        H4ChunkIterator(H4header.Vinfo vinfo) {
            this.chunks = vinfo.chunks;
            this.chunkNo = 0;
        }

        @Override
        public boolean hasNext() {
            return this.chunkNo < this.chunks.size();
        }

        @Override
        public LayoutTiled.DataChunk next() throws IOException {
            H4header.DataChunk chunk = this.chunks.get(this.chunkNo);
            H4header.TagData chunkData = chunk.data;
            ++this.chunkNo;
            return new LayoutTiled.DataChunk(chunk.origin, chunkData.offset);
        }
    }

    private class ChunkedInputStream
    extends InputStream {
        List<H4header.DataChunk> chunks;
        int chunkNo;
        byte[] buffer;
        int segPos;
        int segSize;

        ChunkedInputStream(H4header.Vinfo vinfo) {
            this.chunks = vinfo.chunks;
            this.chunkNo = 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readChunk() throws IOException {
            H4header.DataChunk chunk = this.chunks.get(this.chunkNo);
            H4header.TagData chunkData = chunk.data;
            ++this.chunkNo;
            if (chunkData.ext_type == TagEnum.SPECIAL_COMP) {
                H4header.TagData cdata = chunkData.compress.getDataTag();
                byte[] cbuffer = new byte[cdata.length];
                H4iosp.this.raf.seek(cdata.offset);
                H4iosp.this.raf.readFully(cbuffer);
                if (chunkData.compress.compress_type != TagEnum.COMP_CODE_DEFLATE) throw new IllegalStateException("unknown compression type =" + chunkData.compress.compress_type);
                InflaterInputStream in = new InflaterInputStream(new ByteArrayInputStream(cbuffer));
                ByteArrayOutputStream out = new ByteArrayOutputStream(chunkData.compress.uncomp_length);
                IO.copy(in, out);
                this.buffer = out.toByteArray();
            } else {
                this.buffer = new byte[chunkData.length];
                H4iosp.this.raf.seek(chunkData.offset);
                H4iosp.this.raf.readFully(this.buffer);
            }
            this.segPos = 0;
            this.segSize = this.buffer.length;
        }

        @Override
        public int read() throws IOException {
            if (this.segPos == this.segSize) {
                this.readChunk();
            }
            int b = this.buffer[this.segPos] & 0xFF;
            ++this.segPos;
            return b;
        }
    }

    private class LinkedInputStream
    extends InputStream {
        byte[] buffer;
        long pos = 0L;
        int nsegs;
        long[] segPosA;
        int[] segSizeA;
        int segno = -1;
        int segpos = 0;
        int segSize = 0;

        LinkedInputStream(H4header.Vinfo vinfo) {
            this.segPosA = vinfo.segPos;
            this.segSizeA = vinfo.segSize;
            this.nsegs = this.segSizeA.length;
        }

        LinkedInputStream(H4header.SpecialLinked linked) throws IOException {
            List<H4header.TagLinkedBlock> linkedBlocks = linked.getLinkedDataBlocks();
            this.nsegs = linkedBlocks.size();
            this.segPosA = new long[this.nsegs];
            this.segSizeA = new int[this.nsegs];
            int count = 0;
            for (H4header.TagLinkedBlock tag : linkedBlocks) {
                this.segPosA[count] = tag.offset;
                this.segSizeA[count] = tag.length;
                ++count;
            }
        }

        private boolean readSegment() throws IOException {
            ++this.segno;
            if (this.segno == this.nsegs) {
                return false;
            }
            this.segSize = this.segSizeA[this.segno];
            while (this.segSize == 0) {
                ++this.segno;
                if (this.segno == this.nsegs) {
                    return false;
                }
                this.segSize = this.segSizeA[this.segno];
            }
            this.buffer = new byte[this.segSize];
            H4iosp.this.raf.seek(this.segPosA[this.segno]);
            H4iosp.this.raf.readFully(this.buffer);
            this.segpos = 0;
            return true;
        }

        @Override
        public int read() throws IOException {
            boolean ok;
            if (this.segpos == this.segSize && !(ok = this.readSegment())) {
                return -1;
            }
            int b = this.buffer[this.segpos] & 0xFF;
            ++this.segpos;
            return b;
        }
    }
}

