/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.jcip.annotations.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.TwoDTimeInventory;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateTime
extends CoordinateTimeAbstract
implements Coordinate {
    private final List<Integer> offsetSorted;

    public CoordinateTime(int code, CalendarPeriod timeUnit, CalendarDate refDate, List<Integer> offsetSorted) {
        super(code, timeUnit, refDate);
        this.offsetSorted = Collections.unmodifiableList(offsetSorted);
    }

    CoordinateTime(CoordinateTime org, CalendarDate refDate) {
        super(org.code, org.timeUnit, refDate);
        this.offsetSorted = org.getOffsetSorted();
    }

    public List<Integer> getOffsetSorted() {
        return this.offsetSorted;
    }

    @Override
    public List<? extends Object> getValues() {
        return this.offsetSorted;
    }

    @Override
    public int getIndex(Object val) {
        return Collections.binarySearch(this.offsetSorted, (Integer)val);
    }

    @Override
    public Object getValue(int idx) {
        if (idx < 0 || idx >= this.offsetSorted.size()) {
            return null;
        }
        return this.offsetSorted.get(idx);
    }

    @Override
    public int getSize() {
        return this.offsetSorted.size();
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.time;
    }

    @Override
    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        CalendarDateUnit cdu = CalendarDateUnit.withCalendar(cal, this.periodName + " since " + this.refDate.toString());
        CalendarDate start = cdu.makeCalendarDate(this.offsetSorted.get(0));
        CalendarDate end = cdu.makeCalendarDate(this.offsetSorted.get(this.getSize() - 1));
        return CalendarDateRange.of(start, end);
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s:", new Object[]{indent, this.getType()});
        for (Integer cd2 : this.offsetSorted) {
            info.format(" %3d,", cd2);
        }
        info.format(" (%d) %n", this.offsetSorted.size());
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Time offsets: (%s) ref=%s %n", this.getUnit(), this.getRefDate());
        for (Integer cd2 : this.offsetSorted) {
            info.format("   %3d%n", cd2);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTime that = (CoordinateTime)o;
        if (this.code != that.code) {
            return false;
        }
        return this.offsetSorted.equals(that.offsetSorted);
    }

    public int hashCode() {
        int result = this.offsetSorted.hashCode();
        result = 31 * result + this.code;
        return result;
    }

    @Override
    public CoordinateTime makeBestTimeCoordinate(List<Double> runOffsets) {
        HashSet<Integer> values = new HashSet<Integer>();
        for (double runOffset : runOffsets) {
            for (Integer val : this.getOffsetSorted()) {
                values.add((int)(runOffset + (double)val.intValue()));
            }
        }
        ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
        for (Object e : values) {
            offsetSorted.add((Integer)e);
        }
        Collections.sort(offsetSorted);
        return new CoordinateTime(this.getCode(), this.getTimeUnit(), this.getRefDate(), offsetSorted);
    }

    public int[] makeTime2RuntimeMap(List<Double> runOffsets, CoordinateTime coordBest, TwoDTimeInventory twot) {
        int[] result = new int[coordBest.getSize()];
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        int count = 0;
        for (Integer val : coordBest.getOffsetSorted()) {
            map.put(val, count++);
        }
        int runIdx = 0;
        for (double runOffset : runOffsets) {
            int timeIdx = 0;
            for (Integer val : this.getOffsetSorted()) {
                if (twot == null || twot.getCount(runIdx, timeIdx) > 0) {
                    Integer bestVal = (int)(runOffset + (double)val.intValue());
                    Integer bestValIdx = (Integer)map.get(bestVal);
                    if (bestValIdx == null) {
                        throw new IllegalStateException();
                    }
                    result[bestValIdx.intValue()] = runIdx + 1;
                }
                ++timeIdx;
            }
            ++runIdx;
        }
        return result;
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        final Grib1Customizer cust;
        final int code;
        final CalendarPeriod timeUnit;
        final CalendarDate refDate;

        public Builder1(Grib1Customizer cust, int code, CalendarPeriod timeUnit, CalendarDate refDate) {
            this.cust = cust;
            this.code = code;
            this.timeUnit = timeUnit;
            this.refDate = refDate;
        }

        @Override
        public Object extract(Grib1Record gr) {
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            Grib1ParamTime ptime = pds.getParamTime(this.cust);
            int offset = ptime.getForecastTime();
            int tuInRecord = pds.getTimeUnit();
            if (tuInRecord == this.code) {
                return offset;
            }
            CalendarDate validDate = GribUtils.getValidTime(this.refDate, tuInRecord, offset);
            int newOffset = TimeCoord.getOffset(this.refDate, validDate, this.timeUnit);
            return newOffset;
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
            for (Object val : values) {
                offsetSorted.add((Integer)val);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTime(this.code, this.timeUnit, this.refDate, offsetSorted);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CalendarDate refDate;

        public Builder2(int code, CalendarPeriod timeUnit, CalendarDate refDate) {
            this.code = code;
            this.timeUnit = timeUnit;
            this.refDate = refDate;
        }

        @Override
        public Object extract(Grib2Record gr) {
            Grib2Pds pds = gr.getPDS();
            int offset = pds.getForecastTime();
            int tuInRecord = pds.getTimeUnit();
            if (tuInRecord == this.code) {
                return offset;
            }
            CalendarPeriod period = Grib2Utils.getCalendarPeriod(tuInRecord);
            CalendarDate validDate = this.refDate.add(period.multiply(offset));
            int newOffset = TimeCoord.getOffset(this.refDate, validDate, this.timeUnit);
            return newOffset;
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<Integer> offsetSorted = new ArrayList<Integer>(values.size());
            for (Object val : values) {
                offsetSorted.add((Integer)val);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTime(this.code, this.timeUnit, this.refDate, offsetSorted);
        }
    }
}

