/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.sis.io.stream.IOUtilities;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.storage.DataOptionKey;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreProvider;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.storage.wkt.StoreFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class PRJDataStore
extends URIDataStore {
    private static final int MAXIMAL_LENGTH = 65536;
    protected static final String PRJ = "prj";
    protected final Charset encoding;
    private final Locale locale;
    private final TimeZone timezone;
    protected CoordinateReferenceSystem crs;

    protected PRJDataStore(DataStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector);
        this.crs = connector.getOption(DataOptionKey.DEFAULT_CRS);
        this.encoding = (Charset)connector.getOption(DataOptionKey.ENCODING);
        this.locale = (Locale)connector.getOption(DataOptionKey.LOCALE);
        this.timezone = (TimeZone)connector.getOption(DataOptionKey.TIMEZONE);
    }

    protected final void readPRJ() throws DataStoreException {
        Exception cause = null;
        try {
            AuxiliaryContent content = this.readAuxiliaryFile(PRJ);
            if (content == null) {
                this.listeners.warning(Resources.format((short)66, PRJ));
                return;
            }
            String wkt = content.toString();
            StoreFormat format = new StoreFormat(this.locale, this.timezone, null, this.listeners);
            format.setConvention(Convention.WKT1_COMMON_UNITS);
            ParsePosition pos = new ParsePosition(0);
            this.crs = (CoordinateReferenceSystem)format.parse(wkt, pos);
            if (this.crs != null) {
                format.validate(this.crs);
                return;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            this.listeners.warning(Resources.format((short)66, PRJ), e);
            return;
        }
        catch (IOException | ClassCastException | ParseException e) {
            cause = e;
        }
        throw new DataStoreReferencingException(Resources.format((short)66, PRJ), cause);
    }

    protected final AuxiliaryContent readAuxiliaryFile(String extension) throws IOException, DataStoreException {
        Object source;
        InputStream stream;
        Path path = this.getSpecifiedPath();
        if (path != null) {
            String base = PRJDataStore.getBaseFilename(path);
            path = path.resolveSibling(base.concat(extension));
            stream = Files.newInputStream(path, new OpenOption[0]);
            source = path;
        } else {
            try {
                URI uri = IOUtilities.toAuxiliaryURI(this.location, extension);
                if (uri == null) {
                    return null;
                }
                URL url = uri.toURL();
                stream = url.openStream();
                source = url;
            }
            catch (URISyntaxException e) {
                throw new DataStoreException(Resources.format((short)66, "*." + extension), e);
            }
        }
        try (InputStreamReader reader = this.encoding != null ? new InputStreamReader(stream, this.encoding) : new InputStreamReader(stream);){
            int count;
            char[] buffer = new char[1024];
            int offset = 0;
            while ((count = reader.read(buffer, offset, buffer.length - offset)) >= 0) {
                if ((offset += count) < buffer.length) continue;
                if (offset >= 65536) {
                    throw new DataStoreContentException(Resources.forLocale(this.listeners.getLocale()).getString((short)71, IOUtilities.filename(source)));
                }
                buffer = Arrays.copyOf(buffer, offset * 2);
            }
            AuxiliaryContent auxiliaryContent = new AuxiliaryContent(source, buffer, 0, offset);
            return auxiliaryContent;
        }
    }

    protected final void writePRJ() throws DataStoreException {
        block10: {
            try {
                if (this.crs == null) {
                    this.deleteAuxiliaryFile(PRJ);
                    break block10;
                }
                try (BufferedWriter out = this.writeAuxiliaryFile(PRJ);){
                    StoreFormat format = new StoreFormat(this.locale, this.timezone, null, this.listeners);
                    format.format(this.crs, (Appendable)out);
                    out.newLine();
                }
            }
            catch (IOException e) {
                String identifier = this.getIdentifier().orElse(null);
                if (identifier == null) {
                    identifier = Classes.getShortClassName(this);
                }
                throw new DataStoreException(Resources.format((short)69, identifier), e);
            }
        }
    }

    protected final BufferedWriter writeAuxiliaryFile(String extension) throws IOException, DataStoreException {
        Path[] paths = super.getComponentFiles();
        if (paths.length == 0) {
            throw new UnknownServiceException();
        }
        Path path = paths[0];
        String base = PRJDataStore.getBaseFilename(path);
        path = path.resolveSibling(base.concat(extension));
        return this.encoding != null ? Files.newBufferedWriter(path, this.encoding, new OpenOption[0]) : Files.newBufferedWriter(path, new OpenOption[0]);
    }

    protected final void deleteAuxiliaryFile(String extension) throws DataStoreException, IOException {
        for (Path path : super.getComponentFiles()) {
            String base = PRJDataStore.getBaseFilename(path);
            path = path.resolveSibling(base.concat(extension));
            Files.deleteIfExists(path);
        }
    }

    @Override
    public Path[] getComponentFiles() throws DataStoreException {
        return this.listComponentFiles(PRJ);
    }

    protected final Path[] listComponentFiles(String ... auxiliaries) throws DataStoreException {
        Path[] paths = super.getComponentFiles();
        int count = paths.length;
        if (count != 0) {
            Path path = paths[0];
            String base = PRJDataStore.getBaseFilename(path);
            for (String extension : auxiliaries) {
                Path p;
                if (extension == null || !Files.isRegularFile(p = path.resolveSibling(base.concat(extension)), new LinkOption[0])) continue;
                if (count >= paths.length) {
                    paths = Arrays.copyOf(paths, count + auxiliaries.length);
                }
                paths[count++] = p;
            }
            paths = ArraysExt.resize(paths, count);
        }
        return paths;
    }

    private static String getBaseFilename(Path path) {
        String base = path.getFileName().toString();
        int s2 = base.lastIndexOf(46);
        return s2 >= 0 ? base.substring(0, s2 + 1) : base + ".";
    }

    @Override
    public Optional<ParameterValueGroup> getOpenParameters() {
        ParameterValueGroup pg = PRJDataStore.parameters(this.provider, this.location);
        if (pg != null) {
            pg.parameter("defaultCRS").setValue(this.crs);
            return Optional.of(pg);
        }
        return Optional.empty();
    }

    protected static final class AuxiliaryContent
    implements CharSequence {
        private final Object source;
        private final char[] buffer;
        private final int offset;
        private final int length;

        private AuxiliaryContent(Object source, char[] buffer, int offset, int length) {
            this.source = source;
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        public String getFilename() {
            return IOUtilities.filename(this.source);
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.buffer[this.offset + index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new AuxiliaryContent(this.source, this.buffer, this.offset + start, end - start);
        }

        @Override
        public String toString() {
            return new String(this.buffer, this.offset, this.length);
        }
    }

    public static abstract class Provider
    extends URIDataStore.Provider {
        static final String CRS_NAME = "defaultCRS";
        public static final ParameterDescriptor<CoordinateReferenceSystem> DEFAULT_CRS;

        protected Provider() {
        }

        @Override
        protected ParameterDescriptorGroup build(ParameterBuilder builder) {
            return builder.createGroup(LOCATION_PARAM, DEFAULT_CRS);
        }

        @Override
        public DataStore open(ParameterValueGroup parameters) throws DataStoreException {
            ArgumentChecks.ensureNonNull("parameter", parameters);
            StorageConnector connector = Provider.connector(this, parameters);
            Parameters pg = Parameters.castOrWrap(parameters);
            connector.setOption(DataOptionKey.DEFAULT_CRS, pg.getValue(DEFAULT_CRS));
            return this.open(connector);
        }

        static {
            ParameterBuilder builder = new ParameterBuilder();
            DEFAULT_CRS = ((ParameterBuilder)((ParameterBuilder)builder.addName(CRS_NAME)).setDescription(Vocabulary.formatInternational((short)36))).create(CoordinateReferenceSystem.class, null);
        }
    }
}

