/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.crs;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Time;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.util.ArgumentChecks;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.datum.TemporalDatum;

@XmlType(name="TemporalCRSType", propOrder={"coordinateSystem", "datum"})
@XmlRootElement(name="TemporalCRS")
public class DefaultTemporalCRS
extends AbstractCRS
implements TemporalCRS {
    private static final long serialVersionUID = 3000119849197222007L;
    private TemporalDatum datum;
    private transient UnitConverter toSeconds;
    private transient long origin;

    public DefaultTemporalCRS(Map<String, ?> properties, TemporalDatum datum, TimeCS cs) {
        super(properties, cs);
        ArgumentChecks.ensureNonNull("datum", datum);
        this.datum = datum;
        this.initializeConverter();
    }

    protected DefaultTemporalCRS(TemporalCRS crs) {
        super(crs);
        this.datum = crs.getDatum();
        this.initializeConverter();
    }

    public static DefaultTemporalCRS castOrCopy(TemporalCRS object) {
        return object == null || object instanceof DefaultTemporalCRS ? (DefaultTemporalCRS)object : new DefaultTemporalCRS(object);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeConverter();
    }

    private void initializeConverter() {
        this.toSeconds = this.getUnit().getConverterTo(Units.SECOND);
        long t2 = this.datum.getOrigin().getTime();
        this.origin = t2 / 1000L;
        if ((t2 %= 1000L) != 0L) {
            UnitConverter c = Units.converter(null, Fraction.valueOf(t2, 1000L));
            this.toSeconds = c.concatenate(this.toSeconds);
        }
    }

    public Class<? extends TemporalCRS> getInterface() {
        return TemporalCRS.class;
    }

    @Override
    @XmlElement(name="temporalDatum", required=true)
    public TemporalDatum getDatum() {
        return this.datum;
    }

    @Override
    @XmlElement(name="timeCS", required=true)
    public TimeCS getCoordinateSystem() {
        return (TimeCS)super.getCoordinateSystem();
    }

    public final Unit<Time> getUnit() {
        return super.getCoordinateSystem().getAxis(0).getUnit().asType(Time.class);
    }

    @Override
    public DefaultTemporalCRS forConvention(AxesConvention convention) {
        return (DefaultTemporalCRS)super.forConvention(convention);
    }

    @Override
    final AbstractCRS createSameType(Map<String, ?> properties, CoordinateSystem cs) {
        return new DefaultTemporalCRS(properties, this.datum, (TimeCS)cs);
    }

    public Instant toInstant(double value) {
        if (Double.isFinite(value)) {
            value = this.toSeconds.convert(value);
            long t2 = Math.round(value);
            return Instant.ofEpochSecond(Math.addExact(t2, this.origin), Math.round((value - (double)t2) * 1.0E9));
        }
        return null;
    }

    public Date toDate(double value) {
        if (Double.isFinite(value)) {
            value = this.toSeconds.convert(value);
            long t2 = Math.round(value);
            long ms = Math.addExact(t2, this.origin);
            ms = Math.multiplyExact(ms, 1000);
            ms = Math.addExact(Math.round((value - (double)t2) * 1000.0), ms);
            return new Date(ms);
        }
        return null;
    }

    public Duration toDuration(double delta) {
        if (Double.isFinite(delta *= Units.derivative(this.toSeconds, Double.NaN))) {
            long t2 = Math.round(delta);
            return Duration.ofSeconds(t2, Math.round((delta - (double)t2) * 1.0E9));
        }
        return null;
    }

    public double toValue(Instant time) {
        if (time != null) {
            double t2 = Math.subtractExact(time.getEpochSecond(), this.origin);
            return this.toSeconds.inverse().convert(t2 += (double)time.getNano() / 1.0E9);
        }
        return Double.NaN;
    }

    public double toValue(Date time) {
        if (time != null) {
            long ms = time.getTime();
            long t2 = ms / 1000L;
            t2 = Math.subtractExact(t2, this.origin);
            return this.toSeconds.inverse().convert((double)t2 + (double)(ms %= 1000L) / 1000.0);
        }
        return Double.NaN;
    }

    public double toValue(Duration delta) {
        if (delta != null) {
            double t2 = delta.getSeconds();
            t2 += (double)delta.getNano() / 1.0E9;
            return t2 *= Units.derivative(this.toSeconds.inverse(), Double.NaN);
        }
        return Double.NaN;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        super.formatTo(formatter);
        if (formatter.getConvention().majorVersion() == 1) {
            formatter.setInvalidWKT(this, null);
        }
        return DefaultTemporalCRS.isBaseCRS(formatter) ? "BaseTimeCRS" : "TimeCRS";
    }

    private DefaultTemporalCRS() {
    }

    private void setDatum(TemporalDatum value) {
        if (this.datum == null) {
            this.datum = value;
            if (super.getCoordinateSystem() != null) {
                this.initializeConverter();
            }
        } else {
            ImplementationHelper.propertyAlreadySet(DefaultVerticalCRS.class, "setDatum", "temporalDatum");
        }
    }

    private void setCoordinateSystem(TimeCS cs) {
        this.setCoordinateSystem("timeCS", cs);
        if (this.toSeconds == null && this.datum != null) {
            this.initializeConverter();
        }
    }
}

