/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.measure.Unit;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.internal.NameToIdentifier;
import org.apache.sis.parameter.ParameterTableRow;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.X364;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class ParameterFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -1345231739800152411L;
    private static final AtomicReference<ParameterFormat> INSTANCE = new AtomicReference();
    private static final String SEPARATOR = " \u2502 ";
    private final Locale displayLocale;
    private ContentLevel contentLevel = ContentLevel.BRIEF;
    private Set<String> preferredCodespaces;
    private Colors colors;

    public ParameterFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = SEPARATOR;
    }

    public ParameterFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = SEPARATOR;
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public ContentLevel getContentLevel() {
        return this.contentLevel;
    }

    public void setContentLevel(ContentLevel level) {
        ArgumentChecks.ensureNonNull("level", (Object)level);
        this.contentLevel = level;
    }

    public String[] getPreferredCodespaces() {
        Set<String> p = this.preferredCodespaces;
        return p != null ? (String[])p.toArray(String[]::new) : null;
    }

    public void setPreferredCodespaces(String ... codespaces) {
        Set<String> copy = null;
        if (codespaces != null) {
            copy = CollectionsExt.immutableSet(true, codespaces);
        }
        this.preferredCodespaces = copy;
    }

    private boolean isPreferredCodespace(String codespace) {
        Set<String> p = this.preferredCodespaces;
        return p == null || p.contains(codespace);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    private void nextColumn(TableAppender table) {
        table.append(this.beforeFill);
        table.nextColumn(this.fillCharacter);
    }

    @Override
    public void format(Object object, Appendable toAppendTo) throws IOException {
        ReferenceIdentifier name;
        ParameterDescriptorGroup descriptor;
        ParameterValueGroup values;
        boolean isSummary;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        boolean bl = isSummary = this.contentLevel == ContentLevel.NAME_SUMMARY;
        if (object instanceof ParameterValueGroup) {
            values = (ParameterValueGroup)object;
            descriptor = values.getDescriptor();
            name = descriptor.getName();
        } else if (object instanceof ParameterDescriptorGroup) {
            descriptor = (ParameterDescriptorGroup)object;
            values = null;
            name = descriptor.getName();
        } else if (object instanceof OperationMethod) {
            OperationMethod operation = (OperationMethod)object;
            descriptor = operation.getParameters();
            values = null;
            name = operation.getName();
        } else {
            if (isSummary && object instanceof IdentifiedObject[]) {
                this.formatSummary((IdentifiedObject[])object, toAppendTo);
                return;
            }
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)163, object.getClass()));
        }
        if (isSummary) {
            this.formatSummary((IdentifiedObject[])descriptor.descriptors().toArray(IdentifiedObject[]::new), toAppendTo);
        } else {
            this.format(name.getCode(), descriptor, values, toAppendTo);
        }
    }

    private void format(String name, ParameterDescriptorGroup group, ParameterValueGroup values, Appendable out) throws IOException {
        int n;
        boolean isBrief = this.contentLevel == ContentLevel.BRIEF;
        boolean showObligation = !isBrief || values == null;
        boolean hasColors = this.colors != null;
        String lineSeparator = this.lineSeparator;
        LinkedHashMap<String, Integer> remarks = new LinkedHashMap<String, Integer>();
        ParameterTableRow header = new ParameterTableRow(group, this.displayLocale, this.preferredCodespaces, remarks, isBrief);
        String groupCodespace = header.getCodeSpace();
        int codespaceWidth = 0;
        List<Object> elements = values != null ? values.values() : group.descriptors();
        LinkedHashMap<GeneralParameterDescriptor, ParameterTableRow> descriptorValues = new LinkedHashMap<GeneralParameterDescriptor, ParameterTableRow>(Containers.hashMapCapacity(elements.size()));
        ArrayList deferredGroups = null;
        for (Object e : elements) {
            Object p;
            GeneralParameterDescriptor descriptor;
            GeneralParameterValue parameter;
            if (values != null) {
                parameter = (GeneralParameterValue)e;
                descriptor = parameter.getDescriptor();
            } else {
                parameter = null;
                descriptor = (GeneralParameterDescriptor)e;
            }
            if (descriptor instanceof ParameterDescriptorGroup) {
                if (deferredGroups == null) {
                    deferredGroups = new ArrayList(4);
                }
                deferredGroups.add(e);
                continue;
            }
            Object value = null;
            Unit<?> unit = null;
            if (parameter instanceof ParameterValue) {
                p = (ParameterValue)parameter;
                value = p.getValue();
                unit = p.getUnit();
            } else if (descriptor instanceof ParameterDescriptor) {
                p = (ParameterDescriptor)descriptor;
                value = p.getDefaultValue();
                unit = p.getUnit();
            }
            ParameterTableRow row = (ParameterTableRow)descriptorValues.get(descriptor);
            if (row == null) {
                row = new ParameterTableRow(descriptor, this.displayLocale, this.preferredCodespaces, remarks, isBrief);
                descriptorValues.put(descriptor, row);
                if (row.codespaceWidth > codespaceWidth) {
                    codespaceWidth = row.codespaceWidth;
                }
            }
            row.addValue(value, unit);
        }
        int unitWidth = 0;
        boolean bl = false;
        boolean writeCodespaces = groupCodespace == null;
        StringBuffer buffer = new StringBuffer();
        FieldPosition dummyFP = new FieldPosition(-1);
        for (Map.Entry entry : descriptorValues.entrySet()) {
            int p;
            Range<?> valueDomain;
            GeneralParameterDescriptor descriptor = (GeneralParameterDescriptor)entry.getKey();
            if (!(descriptor instanceof ParameterDescriptor)) continue;
            ParameterTableRow row = (ParameterTableRow)entry.getValue();
            if (!writeCodespaces && !groupCodespace.equals(((ParameterTableRow)entry.getValue()).getCodeSpace())) {
                writeCodespaces = true;
            }
            if ((valueDomain = Parameters.getValueDomain((ParameterDescriptor)descriptor)) != null && (p = row.setValueDomain(valueDomain, this.getFormat(Range.class), buffer)) > n) {
                n = p;
            }
            row.expandSingleton();
            int length = row.units.size();
            for (int i = 0; i < length; ++i) {
                Object unit = row.units.get(i);
                if (unit == null) continue;
                if (this.getFormat(Unit.class).format(unit, buffer, dummyFP).length() != 0 && Character.isLetterOrDigit(buffer.codePointAt(0))) {
                    buffer.insert(0, ' ');
                }
                String symbol = buffer.toString();
                row.units.set(i, symbol);
                buffer.setLength(0);
                int p2 = symbol.length();
                if (p2 <= unitWidth) continue;
                unitWidth = p2;
            }
        }
        Vocabulary resources = Vocabulary.getResources(this.displayLocale);
        header.writeIdentifiers(out, true, this.colors, false, lineSeparator);
        out.append(lineSeparator);
        int horizontalBorder = isBrief ? 9472 : 9552;
        TableAppender table = isBrief || !this.columnSeparator.equals(SEPARATOR) ? new TableAppender(out, this.columnSeparator) : new TableAppender(out);
        table.setMultiLinesCells(true);
        table.nextLine((char)horizontalBorder);
        int numColumnsBeforeValue = 0;
        int i = 0;
        while (true) {
            block49: {
                short key;
                boolean end = false;
                switch (i) {
                    case 0: {
                        key = 139;
                        break;
                    }
                    case 1: {
                        key = 203;
                        break;
                    }
                    case 2: {
                        if (showObligation) {
                            key = 147;
                            break;
                        }
                        break block49;
                    }
                    case 3: {
                        key = 214;
                        break;
                    }
                    case 4: {
                        key = values == null ? (short)56 : 213;
                        end = true;
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
                if (hasColors) {
                    table.append(X364.BOLD.sequence());
                }
                table.append(resources.getString(key));
                if (hasColors) {
                    table.append(X364.NORMAL.sequence());
                }
                if (!writeCodespaces && i == 0) {
                    table.append(" (").append(groupCodespace).append(')');
                }
                if (end) break;
                this.nextColumn(table);
                ++numColumnsBeforeValue;
            }
            ++i;
        }
        table.nextLine();
        int horizontalLine = horizontalBorder;
        for (Map.Entry entry : descriptorValues.entrySet()) {
            if (horizontalLine != 0) {
                table.nextLine('\u2500');
            }
            horizontalLine = isBrief ? 0 : 9472;
            ParameterTableRow row = (ParameterTableRow)entry.getValue();
            row.codespaceWidth = codespaceWidth;
            row.writeIdentifiers(table, writeCodespaces, null, hasColors, lineSeparator);
            this.nextColumn(table);
            GeneralParameterDescriptor generalDescriptor = (GeneralParameterDescriptor)entry.getKey();
            if (generalDescriptor instanceof ParameterDescriptor) {
                String valueDomain;
                ParameterDescriptor descriptor = (ParameterDescriptor)generalDescriptor;
                Class valueClass = descriptor.getValueClass();
                if (valueClass != null) {
                    table.append(this.getFormat(Class.class).format(valueClass, buffer, dummyFP).toString());
                }
                this.nextColumn(table);
                buffer.setLength(0);
                if (showObligation) {
                    int minimumOccurs = descriptor.getMinimumOccurs();
                    int maximumOccurs = descriptor.getMaximumOccurs();
                    if (maximumOccurs == 1) {
                        table.append(resources.getString(minimumOccurs == 0 ? (short)152 : 125));
                    } else {
                        Format f = this.getFormat(Integer.class);
                        table.append(f.format(minimumOccurs, buffer, dummyFP).toString()).append(" \u2026 ");
                        buffer.setLength(0);
                        if (maximumOccurs == Integer.MAX_VALUE) {
                            table.append('\u221e');
                        } else {
                            table.append(f.format(maximumOccurs, buffer, dummyFP).toString());
                            buffer.setLength(0);
                        }
                    }
                    this.nextColumn(table);
                }
                if ((valueDomain = row.valueDomain) != null) {
                    table.append(CharSequences.spaces(n - row.valueDomainAlignment)).append(valueDomain);
                }
                this.nextColumn(table);
                byte alignment = valueClass != null && Number.class.isAssignableFrom(valueClass) ? (byte)1 : -1;
                table.setCellAlignment(alignment);
                int length = row.values.size();
                for (int i2 = 0; i2 < length; ++i2) {
                    CharSequence text;
                    Format format;
                    Object value = row.values.get(i2);
                    if (value == null) continue;
                    if (i2 != 0) {
                        String ditto = resources.getString((short)68);
                        table.nextLine();
                        table.setCellAlignment((byte)0);
                        for (int j = 0; j < numColumnsBeforeValue; ++j) {
                            table.append(ditto);
                            this.nextColumn(table);
                        }
                        table.setCellAlignment(alignment);
                    }
                    if ((format = this.getFormat(value.getClass())) != null) {
                        if (format instanceof NumberFormat && value instanceof Number) {
                            ParameterFormat.configure((NumberFormat)format, Math.abs(((Number)value).doubleValue()));
                        }
                        text = format.format(value, buffer, dummyFP);
                    } else {
                        text = value instanceof CodeList ? Types.getCodeTitle((CodeList)value).toString(this.getLocale()) : (value instanceof InternationalString ? ((InternationalString)value).toString(this.getLocale()) : value.toString());
                    }
                    table.append(text);
                    buffer.setLength(0);
                    int pad = unitWidth;
                    String unit = (String)row.units.get(i2);
                    if (unit != null) {
                        table.append(unit);
                        pad -= unit.length();
                    }
                    table.append(CharSequences.spaces(pad));
                }
            }
            table.nextLine();
            table.setCellAlignment((byte)-1);
        }
        table.nextLine((char)horizontalBorder);
        table.flush();
        for (Map.Entry remark : remarks.entrySet()) {
            ParameterTableRow.writeFootnoteNumber(out, (Integer)remark.getValue());
            out.append(' ').append((CharSequence)remark.getKey()).append(lineSeparator);
        }
        if (deferredGroups != null) {
            for (Map.Entry element : deferredGroups) {
                ParameterDescriptorGroup descriptor;
                ParameterValueGroup value;
                if (element instanceof ParameterValueGroup) {
                    value = (ParameterValueGroup)((Object)element);
                    descriptor = value.getDescriptor();
                } else {
                    value = null;
                    descriptor = (ParameterDescriptorGroup)((Object)element);
                }
                out.append(lineSeparator);
                this.format(name + "/" + descriptor.getName().getCode(), descriptor, value, out);
            }
        }
    }

    private static void configure(NumberFormat format, double m4) {
        int n;
        if (format.getMaximumFractionDigits() <= 9 && (n = m4 < 10.0 ? 9 : (m4 < 1000.0 ? 6 : 3)) >= format.getMinimumFractionDigits()) {
            format.setMaximumFractionDigits(n);
        }
    }

    private void formatSummary(IdentifiedObject[] objects, Appendable out) throws IOException {
        Object name;
        Vocabulary resources = Vocabulary.getResources(this.displayLocale);
        boolean hasIdentifiers = false;
        ArrayList<String[]> rows = new ArrayList<String[]>();
        LinkedHashMap<String, Integer> columnIndices = new LinkedHashMap<String, Integer>();
        columnIndices.put(null, 0);
        if (this.preferredCodespaces != null) {
            for (String codespace : this.preferredCodespaces) {
                columnIndices.put(codespace, columnIndices.size());
            }
        }
        for (IdentifiedObject object : objects) {
            Collection<GenericName> aliases;
            String codespace;
            String[] row = new String[columnIndices.size()];
            Set<ReferenceIdentifier> identifiers = object.getIdentifiers();
            if (identifiers != null) {
                ReferenceIdentifier identifier = null;
                for (ReferenceIdentifier candidate : identifiers) {
                    if (candidate == null) continue;
                    if (this.isPreferredCodespace(candidate.getCodeSpace())) {
                        identifier = candidate;
                        break;
                    }
                    if (identifier != null) continue;
                    identifier = candidate;
                }
                if (identifier != null) {
                    row[0] = IdentifiedObjects.toString(identifier);
                    hasIdentifiers = true;
                }
            }
            if ((name = object.getName()) != null && this.isPreferredCodespace(codespace = name.getCodeSpace())) {
                row = ParameterFormat.putIfAbsent(resources, row, columnIndices, codespace, name.getCode());
                name = null;
            }
            if ((aliases = object.getAlias()) != null) {
                for (GenericName alias : aliases) {
                    String codespace2;
                    if (alias == null || !this.isPreferredCodespace(codespace2 = NameToIdentifier.getCodeSpace(alias, this.displayLocale))) continue;
                    row = ParameterFormat.putIfAbsent(resources, row, columnIndices, codespace2, alias.tip().toInternationalString().toString(this.displayLocale));
                    name = null;
                }
            }
            if (name != null) {
                row = ParameterFormat.putIfAbsent(resources, row, columnIndices, name.getCodeSpace(), name.getCode());
            }
            rows.add(row);
        }
        boolean hasColors = this.colors != null;
        TableAppender table = new TableAppender(out, this.columnSeparator);
        table.setMultiLinesCells(true);
        table.appendHorizontalSeparator();
        for (Object codespace : columnIndices.keySet()) {
            if (codespace == null) {
                if (!hasIdentifiers) continue;
                codespace = resources.getString((short)99);
            }
            if (hasColors) {
                codespace = X364.BOLD.sequence() + (String)codespace + X364.NORMAL.sequence();
            }
            table.append((CharSequence)codespace);
            this.nextColumn(table);
        }
        table.appendHorizontalSeparator();
        int numColumns = columnIndices.size();
        for (String[] row : rows) {
            int i;
            int n = i = hasIdentifiers ? 0 : 1;
            while (i < numColumns) {
                if (i < row.length && (name = row[i]) != null) {
                    table.append((CharSequence)name);
                }
                this.nextColumn(table);
                ++i;
            }
            table.nextLine();
        }
        table.appendHorizontalSeparator();
        table.flush();
    }

    private static String[] putIfAbsent(Vocabulary resources, String[] row, Map<String, Integer> columnIndices, String codespace, String name) {
        int i;
        Integer columnIndex;
        if (codespace == null) {
            codespace = resources.getString((short)208);
        }
        if ((columnIndex = columnIndices.get(codespace)) != null) {
            i = columnIndex;
        } else {
            i = columnIndices.size();
            columnIndices.put(codespace, i);
        }
        if (i >= row.length) {
            row = Arrays.copyOf(row, i + 1);
        }
        if (row[i] == null) {
            row[i] = name;
        }
        return row;
    }

    private static ParameterFormat getSharedInstance(Colors colors) {
        ParameterFormat f = INSTANCE.getAndSet(null);
        if (f == null) {
            f = new ParameterFormat();
        }
        f.setColors(colors);
        return f;
    }

    static String sharedFormat(Object object) {
        ParameterFormat f = ParameterFormat.getSharedInstance(null);
        String s2 = f.format(object);
        INSTANCE.set(f);
        return s2;
    }

    static void print(Object object) {
        Console console = System.console();
        Closeable out = console != null ? console.writer() : System.out;
        ParameterFormat f = ParameterFormat.getSharedInstance(Colors.NAMING);
        try {
            f.format(object, (Appendable)((Object)out));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        INSTANCE.set(f);
    }

    @Override
    public Object parse(CharSequence text, ParsePosition pos) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)162, "parse"), pos.getIndex());
    }

    @Override
    public ParameterFormat clone() {
        ParameterFormat clone = (ParameterFormat)super.clone();
        clone.colors = clone.colors.clone();
        return clone;
    }

    public static enum ContentLevel {
        DETAILED,
        BRIEF,
        NAME_SUMMARY;

    }
}

