/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.wkt;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.geometry.AbstractDirectPosition;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Symbols;
import org.apache.sis.io.wkt.Transliterator;
import org.apache.sis.io.wkt.UnformattableObjectException;
import org.apache.sis.io.wkt.Warnings;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.internal.Resources;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.metadata.simple.SimpleExtent;
import org.apache.sis.referencing.AbstractIdentifiedObject;
import org.apache.sis.referencing.DefaultObjectDomain;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.internal.Legacy;
import org.apache.sis.referencing.util.WKTUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Characters;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Localized;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.IntegerList;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.internal.StandardDateFormat;
import org.apache.sis.util.internal.X364;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.coordinate.Position;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.TemporalExtent;
import org.opengis.metadata.extent.VerticalExtent;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.InternationalString;

public class Formatter
implements Localized {
    static final int BBOX_ACCURACY = 2;
    private static final int VERTICAL_ACCURACY = 9;
    static final String FOREGROUND_DEFAULT = "\u001b[39m";
    static final String BACKGROUND_DEFAULT = "\u001b[49m";
    private final Locale locale;
    private final Symbols symbols;
    private final String separatorNewLine;
    private Colors colors;
    private Convention convention;
    private Citation authority;
    Transliterator transliterator;
    boolean verifyCharacterValidity = true;
    private final List<FormattableObject> enclosingElements = new ArrayList<FormattableObject>();
    private final Map<Unit<?>, Unit<?>> units = new HashMap(4);
    private long hasContextualUnit;
    private final NumberFormat numberFormat;
    private final DateFormat dateFormat;
    private final UnitFormat unitFormat;
    private final FieldPosition dummy = new FieldPosition(0);
    private StringBuffer buffer;
    private int elementStart;
    private byte toUpperCase;
    private byte longKeywords;
    private int listSizeLimit;
    private int colorApplied;
    private byte indentation;
    private int margin;
    private IntegerList keywordSpaceAt;
    private boolean requestNewLine;
    private boolean isComplement;
    private boolean highlightError;
    private Warnings warnings;
    private final Locale errorLocale;

    public Formatter() {
        this(Convention.DEFAULT, Symbols.getDefault(), 2);
    }

    public Formatter(Convention convention, Symbols symbols, int indentation) {
        ArgumentChecks.ensureNonNull("convention", (Object)convention);
        ArgumentChecks.ensureNonNull("symbols", symbols);
        ArgumentChecks.ensureBetween("indentation", -1, 127, indentation);
        this.errorLocale = this.locale = Locale.getDefault(Locale.Category.DISPLAY);
        this.convention = convention;
        this.authority = convention.getNameAuthority();
        this.symbols = symbols.immutable();
        this.transliterator = convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        this.separatorNewLine = this.symbols.separatorNewLine();
        this.indentation = (byte)indentation;
        this.numberFormat = symbols.createNumberFormat();
        this.dateFormat = new StandardDateFormat(symbols.getLocale());
        this.unitFormat = new UnitFormat(symbols.getLocale());
        this.buffer = new StringBuffer();
        this.unitFormat.setStyle(UnitFormat.Style.NAME);
        if (convention.usesCommonUnits) {
            this.unitFormat.setLocale(Locale.US);
        }
    }

    Formatter(Locale locale, Locale errorLocale, Symbols symbols, NumberFormat numberFormat, DateFormat dateFormat, UnitFormat unitFormat) {
        this.locale = locale;
        this.errorLocale = errorLocale;
        this.convention = Convention.DEFAULT;
        this.authority = Convention.DEFAULT.getNameAuthority();
        this.symbols = symbols;
        this.separatorNewLine = symbols.separatorNewLine();
        this.indentation = (byte)2;
        this.numberFormat = numberFormat;
        this.dateFormat = dateFormat;
        this.unitFormat = unitFormat;
    }

    final void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
        this.elementStart = buffer != null ? buffer.length() : 0;
    }

    final void configure(Convention convention, Citation authority, Colors colors, byte toUpperCase, byte longKeywords, byte indentation, int listSizeLimit) {
        this.convention = convention;
        this.authority = authority != null ? authority : convention.getNameAuthority();
        this.colors = colors;
        this.toUpperCase = toUpperCase;
        this.longKeywords = longKeywords;
        this.indentation = indentation;
        this.listSizeLimit = listSizeLimit;
        this.transliterator = convention == Convention.INTERNAL ? Transliterator.IDENTITY : Transliterator.DEFAULT;
        this.unitFormat.setLocale(convention.usesCommonUnits ? Locale.US : Locale.ROOT);
    }

    public final Convention getConvention() {
        return this.convention;
    }

    public final Transliterator getTransliterator() {
        return this.transliterator;
    }

    public final Citation getNameAuthority() {
        return this.authority;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    private void setColor(ElementKind type) {
        if (this.colors != null) {
            if (this.colorApplied == 0) {
                String color = this.colors.getAnsiSequence(type);
                if (color == null) {
                    return;
                }
                boolean isStart = this.buffer.length() == this.elementStart;
                this.buffer.append(color);
                if (isStart) {
                    this.elementStart = this.buffer.length();
                }
            }
            ++this.colorApplied;
        }
    }

    private void resetColor() {
        if (this.colors != null && --this.colorApplied <= 0) {
            this.colorApplied = 0;
            this.buffer.append(FOREGROUND_DEFAULT);
        }
    }

    public void newLine() {
        if (this.indentation > -1) {
            this.requestNewLine = true;
        }
    }

    public void indent(int amount) {
        this.margin = Math.max(0, this.margin + this.indentation * amount);
    }

    public String shortOrLong(String shortKeyword, String longKeyword) {
        return (this.longKeywords != 0 ? this.longKeywords < 0 : this.convention.toUpperCase) ? shortKeyword : longKeyword;
    }

    private void appendSeparator() {
        if (this.buffer.length() != this.elementStart) {
            if (this.requestNewLine) {
                this.buffer.append(this.separatorNewLine).append(CharSequences.spaces(this.margin));
            } else {
                this.buffer.append(this.symbols.getSeparator());
            }
        } else if (this.requestNewLine) {
            this.buffer.append(System.lineSeparator()).append(CharSequences.spaces(this.margin));
        }
        this.requestNewLine = false;
    }

    private void openElement(boolean newLine, String keyword) {
        if (newLine && this.buffer.length() != this.elementStart) {
            this.newLine();
        }
        this.appendSeparator();
        if (this.toUpperCase != 0) {
            Locale locale = this.symbols.getLocale();
            keyword = this.toUpperCase >= 0 ? keyword.toUpperCase(locale) : keyword.toLowerCase(locale);
        }
        this.elementStart = this.buffer.append(keyword).appendCodePoint(this.symbols.getOpeningBracket(0)).length();
    }

    private void closeElement(boolean newLine) {
        this.buffer.appendCodePoint(this.symbols.getClosingBracket(0));
        if (newLine) {
            this.newLine();
        }
    }

    public void append(FormattableObject object) {
        String color;
        int stackDepth;
        if (object == null) {
            return;
        }
        int i = stackDepth = this.enclosingElements.size();
        while (--i >= 0) {
            if (this.enclosingElements.get(i) != object) continue;
            throw new IllegalStateException(Errors.getResources(this.errorLocale).getString((short)18));
        }
        this.enclosingElements.add(object);
        if (this.hasContextualUnit < 0L) {
            throw new IllegalStateException(Errors.getResources(this.errorLocale).getString((short)131));
        }
        this.hasContextualUnit <<= 1;
        this.appendSeparator();
        int base = this.buffer.length();
        this.elementStart = this.buffer.appendCodePoint(this.symbols.getOpeningBracket(0)).length();
        this.indent(1);
        IdentifiedObject info = object instanceof IdentifiedObject ? (IdentifiedObject)((Object)object) : null;
        String keyword = object.formatTo(this);
        if (keyword == null) {
            if (info != null) {
                this.setInvalidWKT(info, null);
            } else {
                this.setInvalidWKT(object.getClass(), null);
            }
            keyword = Formatter.getName(object.getClass());
        } else if (this.toUpperCase != 0) {
            Locale locale = this.symbols.getLocale();
            String string = keyword = this.toUpperCase >= 0 ? keyword.toUpperCase(locale) : keyword.toLowerCase(locale);
        }
        if (this.highlightError && this.colors != null && (color = this.colors.getAnsiSequence(ElementKind.ERROR)) != null) {
            this.buffer.insert(base, color + BACKGROUND_DEFAULT);
            base += color.length();
        }
        this.highlightError = false;
        this.buffer.insert(base, keyword);
        if (this.keywordSpaceAt != null) {
            int length = keyword.length();
            CharSequence additionalMargin = CharSequences.spaces(keyword.codePointCount(0, length));
            int n = this.keywordSpaceAt.size();
            int i2 = 0;
            while (i2 < n) {
                int p = this.keywordSpaceAt.getInt(i2);
                this.buffer.insert(p += ++i2 * length, additionalMargin);
            }
            this.keywordSpaceAt.clear();
        }
        if (info == null && this.convention.majorVersion() != 1 && object instanceof GeneralParameterValue) {
            info = ((GeneralParameterValue)((Object)object)).getDescriptor();
        }
        if (info != null) {
            this.appendComplement(info, stackDepth >= 1 ? this.enclosingElements.get(stackDepth - 1) : null, stackDepth >= 2 ? this.enclosingElements.get(stackDepth - 2) : null);
        }
        this.buffer.appendCodePoint(this.symbols.getClosingBracket(0));
        this.indent(-1);
        this.enclosingElements.remove(stackDepth);
        this.hasContextualUnit >>>= 1;
    }

    private void appendComplement(IdentifiedObject object, FormattableObject parent, FormattableObject gp) {
        Set<ReferenceIdentifier> identifiers;
        boolean showRemarks;
        boolean showOthers;
        boolean filterID;
        boolean showIDs;
        this.isComplement = true;
        if (this.convention == Convention.INTERNAL) {
            showIDs = true;
            filterID = false;
            showOthers = true;
            showRemarks = true;
        } else {
            if (parent == null || parent instanceof CompoundCRS) {
                showIDs = true;
            } else if (gp instanceof CoordinateOperation && !(parent instanceof IdentifiedObject)) {
                showIDs = true;
            } else if (this.convention == Convention.WKT2_SIMPLIFIED) {
                showIDs = false;
            } else {
                boolean bl = showIDs = object instanceof OperationMethod || object instanceof GeneralParameterDescriptor;
            }
            if (this.convention.majorVersion() == 1) {
                filterID = true;
                showOthers = false;
                showRemarks = false;
            } else {
                boolean bl = filterID = parent != null;
                if (object instanceof CoordinateOperation) {
                    showRemarks = showOthers = !(parent instanceof ConcatenatedOperation);
                } else if (object instanceof ReferenceSystem) {
                    showOthers = parent == null;
                    showRemarks = parent == null || gp instanceof CoordinateOperation;
                } else {
                    showOthers = false;
                    showRemarks = false;
                }
            }
        }
        if (showOthers) {
            this.appendForSubtypes(object);
        }
        if (showIDs && (identifiers = object.getIdentifiers()) != null) {
            if (filterID) {
                for (ReferenceIdentifier id : identifiers) {
                    if (!Citations.identifierMatches(this.authority, id.getAuthority())) continue;
                    identifiers = Set.of(id);
                    break;
                }
            }
            for (ReferenceIdentifier id : identifiers) {
                if (!(id instanceof FormattableObject)) {
                    id = ImmutableIdentifier.castOrCopy(id);
                }
                this.append((FormattableObject)((Object)id));
                if (!filterID) continue;
                break;
            }
        }
        if (showRemarks) {
            this.appendOnNewLine("Remark", object.getRemarks(), ElementKind.REMARKS);
        }
        this.isComplement = false;
    }

    private void appendForSubtypes(IdentifiedObject object) {
        InternationalString anchor = null;
        InternationalString scope = null;
        Extent area = null;
        if (object instanceof Datum) {
            anchor = ((Datum)object).getAnchorPoint();
        } else if (!(object instanceof ReferenceSystem) && !(object instanceof CoordinateOperation)) {
            return;
        }
        for (DefaultObjectDomain domain : Legacy.getDomains(object)) {
            scope = domain.getScope();
            area = domain.getDomainOfValidity();
            if (area == null) continue;
            break;
        }
        this.appendOnNewLine("Anchor", anchor, null);
        this.append(scope, area);
    }

    public void append(InternationalString scope, Extent area) {
        if (scope != null && !(scope instanceof NilObject)) {
            this.appendOnNewLine("Scope", scope, ElementKind.SCOPE);
        }
        if (area != null && !(area instanceof NilObject)) {
            this.appendOnNewLine("Area", area.getDescription(), ElementKind.EXTENT);
            this.append(Extents.getGeographicBoundingBox(area), 2);
            this.appendVerticalExtent(Extents.getVerticalRange(area));
            this.appendTemporalExtent(Extents.getTimeRange(area));
        }
    }

    public void append(GeographicBoundingBox bbox, int fractionDigits) {
        if (bbox != null) {
            this.openElement(this.isComplement, "BBox");
            this.setColor(ElementKind.EXTENT);
            this.numberFormat.setMinimumFractionDigits(fractionDigits);
            this.numberFormat.setMaximumFractionDigits(fractionDigits);
            this.numberFormat.setRoundingMode(RoundingMode.FLOOR);
            this.appendPreset(bbox.getSouthBoundLatitude());
            this.appendPreset(bbox.getWestBoundLongitude());
            this.numberFormat.setRoundingMode(RoundingMode.CEILING);
            this.appendPreset(bbox.getNorthBoundLatitude());
            this.appendPreset(bbox.getEastBoundLongitude());
            this.resetColor();
            this.closeElement(this.isComplement);
        }
    }

    private void appendVerticalExtent(MeasurementRange<Double> range) {
        if (range != null) {
            double min2 = range.getMinDouble();
            double max = range.getMaxDouble();
            int minimumFractionDigits = Numerics.fractionDigitsForDelta(max - min2);
            int maximumFractionDigits = Math.min(Math.min(Numerics.suggestFractionDigits(min2, max), minimumFractionDigits + 2), 9);
            this.openElement(true, "VerticalExtent");
            this.setColor(ElementKind.EXTENT);
            this.numberFormat.setMinimumFractionDigits(minimumFractionDigits);
            this.numberFormat.setMaximumFractionDigits(maximumFractionDigits);
            this.numberFormat.setRoundingMode(RoundingMode.FLOOR);
            this.appendPreset(min2);
            this.numberFormat.setRoundingMode(RoundingMode.CEILING);
            this.appendPreset(max);
            Unit<?> unit = range.unit();
            if (!this.convention.isSimplified() || !Units.METRE.equals(unit)) {
                this.append(unit);
            }
            this.resetColor();
            this.closeElement(true);
        }
    }

    private void appendTemporalExtent(Range<Date> range) {
        if (range != null) {
            Date min2 = range.getMinValue();
            Date max = range.getMaxValue();
            if (min2 != null && max != null) {
                this.openElement(true, "TimeExtent");
                this.setColor(ElementKind.EXTENT);
                this.append(min2);
                this.append(max);
                this.resetColor();
                this.closeElement(true);
            }
        }
    }

    public void append(MathTransform transform) {
        if (transform != null) {
            if (transform instanceof FormattableObject) {
                this.append((FormattableObject)((Object)transform));
            } else {
                FormattableObject object = WKTUtilities.toFormattable(transform, this.convention == Convention.INTERNAL);
                if (object != null) {
                    this.append(object);
                } else {
                    throw new UnformattableObjectException(Errors.format((short)50, FormattableObject.class, transform.getClass()));
                }
            }
        }
    }

    private void appendOnNewLine(String keyword, InternationalString text, ElementKind type) {
        String localized;
        ArgumentChecks.ensureNonNull("keyword", keyword);
        if (text != null && (localized = text.toString(this.locale)) != null && !(localized = localized.strip()).isEmpty()) {
            this.openElement(true, keyword);
            this.quote(localized, type);
            this.closeElement(true);
        }
    }

    public void append(String text, ElementKind type) {
        if (text != null) {
            this.appendSeparator();
            if (type != ElementKind.CODE_LIST) {
                this.quote(text, type);
            } else {
                this.setColor(type);
                this.buffer.append(text);
                this.resetColor();
            }
        }
    }

    private void quote(String text, ElementKind type) {
        this.setColor(type);
        int base = this.buffer.appendCodePoint(this.symbols.getOpeningQuote(0)).length();
        if (type != ElementKind.REMARKS) {
            text = this.transliterator.filter(text);
            if (this.verifyCharacterValidity) {
                int n;
                int startAt = 0;
                int length = text.length();
                for (int i = 0; i < length; i += n) {
                    int c = text.codePointAt(i);
                    n = Character.charCount(c);
                    if (Characters.isValidWKT(c)) continue;
                    String illegal = text.substring(i, i + n);
                    while ((i += n) < length) {
                        c = text.codePointAt(i);
                        n = Character.charCount(c);
                        if (c != 32 && c != 95) continue;
                    }
                    this.warnings().add(Errors.formatInternational((short)48, "Well-Known Text", text.substring(startAt, i), illegal), null, null);
                    break;
                }
            }
        }
        this.buffer.append(text);
        this.closeQuote(base);
        this.resetColor();
    }

    private void closeQuote(int fromIndex) {
        String quote = this.symbols.getQuote();
        while ((fromIndex = this.buffer.indexOf(quote, fromIndex)) >= 0) {
            int n = quote.length();
            if (this.convention.majorVersion() == 1) {
                this.buffer.delete(fromIndex, fromIndex + n);
                continue;
            }
            this.buffer.insert(fromIndex += n, quote);
            fromIndex += n;
        }
        this.buffer.append(quote);
    }

    public void append(CodeList<?> code) {
        if (code != null) {
            String name;
            this.appendSeparator();
            String string = name = this.convention.majorVersion() == 1 ? code.name() : Types.getCodeName(code);
            if (CharSequences.isUnicodeIdentifier(name)) {
                this.setColor(ElementKind.CODE_LIST);
                this.buffer.append(name);
                this.resetColor();
            } else {
                this.quote(name, ElementKind.CODE_LIST);
                this.setInvalidWKT(code.getClass(), null);
            }
        }
    }

    public void append(Date date) {
        if (date != null) {
            this.appendSeparator();
            this.dateFormat.format(date, this.buffer, this.dummy);
        }
    }

    public void append(boolean value) {
        this.appendSeparator();
        this.buffer.append(value ? "TRUE" : "FALSE");
    }

    public void append(long number) {
        this.appendSeparator();
        this.setColor(this.isComplement ? ElementKind.IDENTIFIER : ElementKind.INTEGER);
        this.numberFormat.setMaximumFractionDigits(0);
        this.numberFormat.format(number, this.buffer, this.dummy);
        this.resetColor();
    }

    public void append(double number) {
        this.appendSeparator();
        this.setColor(ElementKind.NUMBER);
        if (this.symbols.useScientificNotation(Math.abs(number))) {
            this.buffer.append(number);
        } else {
            this.numberFormat.setMaximumFractionDigits(DecimalFunctions.fractionDigitsForValue(number, 2));
            this.numberFormat.setMinimumFractionDigits(1);
            this.numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
            this.numberFormat.format(number, this.buffer, this.dummy);
        }
        this.resetColor();
    }

    public void append(Vector[] rows, int ... fractionDigits) {
        CharSequence marginBeforeRow;
        boolean needsAlignment;
        if (rows == null || rows.length == 0) {
            return;
        }
        if (fractionDigits == null || fractionDigits.length == 0) {
            fractionDigits = WKTUtilities.suggestFractionDigits(rows);
        }
        this.numberFormat.setRoundingMode(RoundingMode.HALF_EVEN);
        int numRows = rows.length;
        boolean isMultiLines = this.indentation > -1 && numRows > 1;
        boolean bl = needsAlignment = !this.requestNewLine;
        if (isMultiLines) {
            int currentLineLength = this.margin;
            if (needsAlignment) {
                int length;
                int i;
                int c;
                for (i = length = this.buffer.length(); i > 0 && !Characters.isLineOrParagraphSeparator(c = this.buffer.codePointBefore(i)); i -= Character.charCount(c)) {
                }
                currentLineLength = this.buffer.codePointCount(i, length);
            }
            marginBeforeRow = CharSequences.spaces(currentLineLength);
        } else {
            marginBeforeRow = "";
        }
        int[][] formattedNumberMarks = new int[numRows][];
        int numColumns = 0;
        for (int j = 0; j < numRows; ++j) {
            if (j == 0) {
                this.appendSeparator();
            } else {
                this.buffer.append(this.separatorNewLine).append(marginBeforeRow);
            }
            Vector numbers = rows[j];
            int numCols = numbers.size();
            numColumns = Math.max(numColumns, numCols);
            int[] nArray = new int[numCols << 1];
            formattedNumberMarks[j] = nArray;
            for (int i = 0; i < numCols; ++i) {
                if (i != 0) {
                    this.buffer.append(' ');
                }
                if (i < fractionDigits.length) {
                    int f = fractionDigits[i];
                    this.numberFormat.setMaximumFractionDigits(f);
                    this.numberFormat.setMinimumFractionDigits(f);
                }
                nArray[i << 1] = this.buffer.length();
                this.setColor(ElementKind.NUMBER);
                Number n = numbers.get(i);
                if (n != null) {
                    this.numberFormat.format(n, this.buffer, this.dummy);
                } else {
                    this.buffer.append('\u2026');
                }
                this.resetColor();
                nArray[i << 1 | 1] = this.buffer.length();
            }
        }
        if (isMultiLines) {
            int base = this.elementStart;
            String toWrite = this.buffer.substring(base);
            this.buffer.setLength(base);
            int[] columnWidths = new int[numColumns];
            for (int[] marks : formattedNumberMarks) {
                for (int i = 0; i < marks.length; i += 2) {
                    int k = i >> 1;
                    int n = i;
                    int n2 = marks[n] - base;
                    marks[n] = n2;
                    int n3 = i + 1;
                    marks[n3] = marks[n3] - base;
                    int w = toWrite.codePointCount(n2, marks[n3]);
                    if (w <= columnWidths[k]) continue;
                    columnWidths[k] = w;
                }
            }
            if (needsAlignment && this.keywordSpaceAt == null) {
                this.keywordSpaceAt = new IntegerList(formattedNumberMarks.length, Integer.MAX_VALUE);
            }
            boolean bl2 = false;
            int lastPosition = 0;
            for (int[] marks : formattedNumberMarks) {
                boolean bl3;
                int i = 0;
                while (i < marks.length) {
                    int w = columnWidths[i >> 1];
                    int s2 = marks[i++];
                    int e = marks[i++];
                    this.buffer.append(toWrite, lastPosition, s2).append(CharSequences.spaces(w - toWrite.codePointCount(s2, e)));
                    if (bl3) {
                        bl3 = false;
                        this.keywordSpaceAt.add(this.buffer.length());
                    }
                    this.buffer.append(toWrite, s2, e);
                    lastPosition = e;
                }
                bl3 = needsAlignment;
            }
        }
    }

    private void appendPreset(double number) {
        this.appendSeparator();
        this.setColor(ElementKind.NUMBER);
        this.numberFormat.format(number, this.buffer, this.dummy);
        this.resetColor();
    }

    private void appendExact(double number) {
        if (Locale.ROOT.equals(this.symbols.getLocale())) {
            this.appendSeparator();
            this.setColor(this.highlightError ? ElementKind.ERROR : ElementKind.NUMBER);
            int i = (int)number;
            if ((double)i == number) {
                this.buffer.append(i);
            } else {
                this.buffer.append(number);
            }
            this.resetColor();
        } else {
            this.append(number);
        }
        this.highlightError = false;
    }

    public void append(Unit<?> unit) {
        if (unit != null) {
            Integer code;
            boolean isSimplified = this.longKeywords == 0 ? this.convention.isSimplified() : this.longKeywords < 0;
            boolean isWKT1 = this.convention.majorVersion() == 1;
            Unit<?> base = unit.getSystemUnit();
            String keyword = base.equals(Units.METRE) ? (isSimplified ? "Unit" : "LengthUnit") : (base.equals(Units.RADIAN) ? (isSimplified ? "Unit" : "AngleUnit") : (base.equals(Units.UNITY) ? (isSimplified ? "Unit" : "ScaleUnit") : (base.equals(Units.SECOND) ? "TimeUnit" : "ParametricUnit")));
            this.openElement(false, keyword);
            this.setColor(ElementKind.UNIT);
            int fromIndex = this.buffer.appendCodePoint(this.symbols.getOpeningQuote(0)).length();
            this.unitFormat.format(unit, this.buffer, this.dummy);
            this.closeQuote(fromIndex);
            this.resetColor();
            double conversion = Units.toStandardUnit(unit);
            if (Double.isNaN(conversion) && Units.isAngular(unit)) {
                this.appendExact(Math.PI / 180);
            } else {
                this.appendExact(conversion);
            }
            if ((this.convention == Convention.INTERNAL || Double.isNaN(conversion)) && (code = Units.getEpsgCode(unit, this.getEnclosingElement(1) instanceof CoordinateSystemAxis)) != null) {
                this.openElement(false, isWKT1 ? "Authority" : "Id");
                this.append("EPSG", null);
                if (isWKT1) {
                    this.append(code.toString(), null);
                } else {
                    this.append(code.intValue());
                }
                this.closeElement(false);
            }
            this.closeElement(false);
            if (!(conversion > 0.0) || keyword != "Unit" && isWKT1) {
                this.setInvalidWKT(Unit.class, null);
            }
        }
    }

    public void appendAny(Object value) {
        if (value == null) {
            this.appendSeparator();
            this.buffer.append("null");
        } else if (!this.appendValue(value) && !this.appendElement(value)) {
            this.append(value.toString(), null);
        }
    }

    final boolean appendValue(Object value) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (Numbers.isInteger(number.getClass())) {
                this.append(number.longValue());
            } else {
                this.append(number.doubleValue());
            }
        } else if (value instanceof CodeList) {
            this.append((CodeList)value);
        } else if (value instanceof Date) {
            this.append((Date)value);
        } else if (value instanceof Boolean) {
            this.append((Boolean)value);
        } else if (value instanceof CharSequence) {
            this.append(value instanceof InternationalString ? ((InternationalString)value).toString(this.locale) : value.toString(), null);
        } else if (value.getClass().isArray()) {
            this.appendSeparator();
            this.elementStart = this.buffer.appendCodePoint(this.symbols.getOpenSequence()).length();
            int length = Array.getLength(value);
            int cut = length <= this.listSizeLimit ? length : Math.max(this.listSizeLimit / 2 - 1, 1);
            for (int i = 0; i < length; ++i) {
                if (i == cut) {
                    int skip = length - Math.min(2 * cut, this.listSizeLimit);
                    this.buffer.append(this.symbols.getSeparator());
                    this.setColor(ElementKind.REMARKS);
                    this.buffer.append(Resources.forLocale(this.locale).getString((short)4, skip));
                    this.resetColor();
                    i += skip;
                    this.setInvalidWKT(value.getClass().getSimpleName(), null);
                }
                this.appendAny(Array.get(value, i));
            }
            this.buffer.appendCodePoint(this.symbols.getCloseSequence());
        } else {
            return false;
        }
        return true;
    }

    final boolean appendElement(Object value) {
        if (value instanceof FormattableObject) {
            this.append((FormattableObject)value);
        } else if (value instanceof IdentifiedObject) {
            this.append(AbstractIdentifiedObject.castOrCopy((IdentifiedObject)value));
        } else if (value instanceof MathTransform) {
            this.append((MathTransform)value);
        } else if (value instanceof Unit) {
            this.append((Unit)value);
        } else if (value instanceof GeographicBoundingBox) {
            this.append((GeographicBoundingBox)value, 2);
        } else if (value instanceof VerticalExtent) {
            this.appendVerticalExtent(Extents.getVerticalRange(new SimpleExtent(null, (VerticalExtent)value, null)));
        } else if (value instanceof TemporalExtent) {
            this.appendTemporalExtent(Extents.getTimeRange(new SimpleExtent(null, null, (TemporalExtent)value)));
        } else if (value instanceof Position) {
            this.append(AbstractDirectPosition.castOrCopy(((Position)value).getDirectPosition()));
        } else if (value instanceof Envelope) {
            this.append(AbstractEnvelope.castOrCopy((Envelope)value));
        } else {
            return false;
        }
        return true;
    }

    public String delegateTo(Object other) throws UnformattableObjectException {
        ArgumentChecks.ensureNonNull("other", other);
        if (other instanceof FormattableObject) {
            return ((FormattableObject)other).formatTo(this);
        }
        throw new UnformattableObjectException(Errors.format((short)50, FormattableObject.class, other.getClass()));
    }

    public FormattableObject getEnclosingElement(int depth) {
        ArgumentChecks.ensurePositive("depth", depth);
        depth = this.enclosingElements.size() - 1 - depth;
        return depth >= 0 ? this.enclosingElements.get(depth) : null;
    }

    public boolean hasContextualUnit(int depth) {
        ArgumentChecks.ensurePositive("depth", depth);
        return (this.hasContextualUnit & Numerics.bitmask(depth)) != 0L;
    }

    public <Q extends Quantity<Q>> Unit<Q> addContextualUnit(Unit<Q> unit) {
        if (unit == null || this.convention.usesCommonUnits) {
            return null;
        }
        this.hasContextualUnit |= 1L;
        return this.units.put(unit.getSystemUnit(), unit);
    }

    public void restoreContextualUnit(Unit<?> unit, Unit<?> previous) {
        if (previous == null) {
            if (unit != null && this.units.remove(unit.getSystemUnit()) != unit && !this.convention.usesCommonUnits) {
                throw new IllegalStateException();
            }
            this.hasContextualUnit &= 0xFFFFFFFFFFFFFFFEL;
        } else if (this.units.put(previous.getSystemUnit(), previous) != unit) {
            throw new IllegalStateException();
        }
    }

    public <Q extends Quantity<Q>> Unit<Q> toContextualUnit(Unit<Q> unit) {
        Unit<?> candidate;
        if (unit != null && (candidate = this.units.get(unit.getSystemUnit())) != null) {
            return candidate;
        }
        return unit;
    }

    public boolean isInvalidWKT() {
        return this.warnings != null || this.buffer != null && this.buffer.length() == 0;
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = new Warnings(this.errorLocale, false, Map.of());
        }
        return this.warnings;
    }

    public void setInvalidWKT(IdentifiedObject unformattable, Exception cause) {
        String name;
        ArgumentChecks.ensureNonNull("unformattable", unformattable);
        ReferenceIdentifier id = unformattable.getName();
        if (id == null || (name = id.getCode()) == null) {
            name = Formatter.getName(unformattable.getClass());
        }
        this.setInvalidWKT(name, cause);
    }

    public void setInvalidWKT(Class<?> unformattable, Exception cause) {
        ArgumentChecks.ensureNonNull("unformattable", unformattable);
        this.setInvalidWKT(Formatter.getName(unformattable), cause);
    }

    private void setInvalidWKT(String invalidElement, Exception cause) {
        this.warnings().add(Errors.formatInternational((short)13, "WKT", invalidElement), cause, null);
        this.highlightError = true;
    }

    private static String getName(Class<?> unformattable) {
        if (!unformattable.isInterface()) {
            for (Class<?> candidate : unformattable.getInterfaces()) {
                if (!candidate.getName().startsWith("org.opengis.")) continue;
                unformattable = candidate;
                break;
            }
        }
        return Classes.getShortName(unformattable);
    }

    final Warnings getWarnings() {
        return this.warnings;
    }

    final void appendWarnings() throws IOException {
        Warnings warnings = this.warnings;
        if (warnings != null) {
            StringBuffer buffer = this.buffer;
            String ln = System.lineSeparator();
            buffer.append(ln).append(ln);
            if (this.colors != null) {
                buffer.append(X364.BACKGROUND_RED.sequence()).append(X364.BOLD.sequence()).append(' ');
            }
            Vocabulary.getResources(this.errorLocale).appendLabel((short)222, buffer);
            if (this.colors != null) {
                buffer.append(' ').append(X364.RESET.sequence()).append(X364.FOREGROUND_RED.sequence());
            }
            buffer.append(ln);
            int n = warnings.getNumMessages();
            HashSet<String> done = new HashSet<String>();
            for (int i = 0; i < n; ++i) {
                String message = Exceptions.getLocalizedMessage(warnings.getException(i), this.errorLocale);
                if (message == null) {
                    message = warnings.getMessage(i);
                }
                if (!done.add(message)) continue;
                buffer.append("  \u2022 ").append(message).append(ln);
            }
        }
    }

    public String toWKT() {
        return this.buffer.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder(Classes.getShortClassName(this));
        String separator = " of ";
        int i = this.enclosingElements.size();
        while (--i >= 0) {
            b.append(separator).append(Classes.getShortClassName(this.enclosingElements.get(i)));
            separator = " inside ";
        }
        return b.toString();
    }

    final void clear() {
        if (this.buffer != null) {
            this.buffer.setLength(0);
        }
        this.enclosingElements.clear();
        this.units.clear();
        this.hasContextualUnit = 0L;
        this.elementStart = 0;
        this.colorApplied = 0;
        this.margin = 0;
        this.keywordSpaceAt = null;
        this.requestNewLine = false;
        this.isComplement = false;
        this.highlightError = false;
        this.warnings = null;
    }
}

