/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.Reference;
import java.nio.DoubleBuffer;
import java.util.Objects;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.coverage.grid.j2d.FillValues;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.Shapes2D;
import org.apache.sis.image.ComputedImage;
import org.apache.sis.image.Interpolation;
import org.apache.sis.image.MaskImage;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.image.PositionalConsistencyImage;
import org.apache.sis.image.ResamplingGrid;
import org.apache.sis.image.TransferType;
import org.apache.sis.measure.Quantities;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class ResampledImage
extends ComputedImage {
    public static final String POSITIONAL_CONSISTENCY_KEY = "org.apache.sis.PositionalConsistency";
    static final int BIDIMENSIONAL = 2;
    private final int minX;
    private final int minY;
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    protected final MathTransform toSource;
    private final MathTransform toSourceSupport;
    protected final Interpolation interpolation;
    private final Object fillValues;
    private final Quantity<Length> linearAccuracy;
    private Reference<ComputedImage> positionalConsistency;
    private Reference<ComputedImage> mask;

    protected ResampledImage(RenderedImage source, SampleModel sampleModel, Point minTile, Rectangle bounds, MathTransform toSource, Interpolation interpolation, Number[] fillValues, Quantity<?>[] accuracy) {
        super(sampleModel, source);
        if (source.getWidth() <= 0 || source.getHeight() <= 0) {
            throw new IllegalArgumentException(Resources.format((short)19));
        }
        ArgumentChecks.ensureNonNull("interpolation", interpolation);
        this.width = bounds.width;
        ArgumentChecks.ensureStrictlyPositive("width", this.width);
        this.height = bounds.height;
        ArgumentChecks.ensureStrictlyPositive("height", this.height);
        this.minX = bounds.x;
        this.minY = bounds.y;
        if (minTile != null) {
            this.minTileX = minTile.x;
            this.minTileY = minTile.y;
        } else {
            this.minTileX = 0;
            this.minTileY = 0;
        }
        this.toSource = toSource;
        int numDim = toSource.getSourceDimensions();
        if (numDim != 2 || (numDim = toSource.getTargetDimensions()) < 2) {
            throw new IllegalArgumentException(Errors.format((short)81, "toSource", 2, numDim));
        }
        interpolation = interpolation.toCompatible(source);
        Dimension s2 = interpolation.getSupportSize();
        if (s2.width > source.getWidth() || s2.height > source.getHeight()) {
            interpolation = Interpolation.NEAREST;
            s2 = interpolation.getSupportSize();
        }
        this.interpolation = interpolation;
        double[] offset = new double[numDim];
        offset[0] = ResampledImage.interpolationSupportOffset(s2.width);
        offset[1] = ResampledImage.interpolationSupportOffset(s2.height);
        MathTransform toSourceSupport = MathTransforms.concatenate(toSource, MathTransforms.translation(offset));
        Boolean canUseGrid = null;
        Quantity<Length> linearAccuracy = null;
        if (accuracy != null) {
            for (Quantity<?> hint : accuracy) {
                if (hint == null) continue;
                Unit<?> unit = hint.getUnit();
                if (Units.PIXEL.equals(unit)) {
                    boolean c;
                    boolean bl = c = Math.abs(hint.getValue().doubleValue()) >= 0.125;
                    if (canUseGrid == null) {
                        canUseGrid = c;
                        continue;
                    }
                    canUseGrid = canUseGrid & c;
                    continue;
                }
                if (!Units.isLinear(unit)) continue;
                linearAccuracy = Quantities.max(linearAccuracy, hint.asType(Length.class));
            }
        }
        if (canUseGrid != null && canUseGrid.booleanValue()) {
            try {
                toSourceSupport = ResamplingGrid.getOrCreate(MathTransforms.bidimensional(toSourceSupport), bounds);
            }
            catch (ImagingOpException | TransformException e) {
                ResampledImage.recoverableException("<init>", e);
            }
        }
        this.toSourceSupport = toSourceSupport;
        this.linearAccuracy = linearAccuracy;
        this.fillValues = new FillValues((SampleModel)sampleModel, (Number[])fillValues, (boolean)false).asPrimitiveArray;
    }

    static double interpolationSupportOffset(int span) {
        if (span <= 1) {
            return 0.5;
        }
        return -((span - 1) / 2);
    }

    private static double interpolationLimit(double max, int span) {
        max += (double)span;
        if (span > 1) {
            max -= 0.5;
        }
        return max;
    }

    private int getPositionalAccuracyCount() {
        int n = 0;
        if (this.linearAccuracy != null) {
            ++n;
        }
        if (this.toSourceSupport instanceof ResamplingGrid) {
            ++n;
        }
        return n;
    }

    private Quantity<?>[] getPositionalAccuracy() {
        Quantity[] accuracy = new Quantity[this.getPositionalAccuracyCount()];
        int n = 0;
        if (this.linearAccuracy != null) {
            accuracy[n++] = this.linearAccuracy;
        }
        if (this.toSourceSupport instanceof ResamplingGrid) {
            accuracy[n++] = Quantities.create(0.125, Units.PIXEL);
        }
        return accuracy;
    }

    private synchronized RenderedImage getPositionalConsistency() throws TransformException {
        ComputedImage image;
        ComputedImage computedImage = image = this.positionalConsistency != null ? this.positionalConsistency.get() : null;
        if (image == null) {
            this.positionalConsistency = null;
            Dimension s2 = this.interpolation.getSupportSize();
            double[] offset = new double[this.toSourceSupport.getSourceDimensions()];
            offset[0] = -ResampledImage.interpolationSupportOffset(s2.width);
            offset[1] = -ResampledImage.interpolationSupportOffset(s2.height);
            MathTransform tr = MathTransforms.concatenate(this.toSourceSupport, MathTransforms.translation(offset));
            image = new PositionalConsistencyImage(this, tr);
            this.positionalConsistency = image.reference();
        }
        return image;
    }

    private synchronized RenderedImage getMask() {
        ComputedImage image;
        ComputedImage computedImage = image = this.mask != null ? this.mask.get() : null;
        if (image == null) {
            this.mask = null;
            image = new MaskImage(this);
            this.mask = image.reference();
        }
        return image;
    }

    boolean hasNoMask() {
        return this.fillValues instanceof int[];
    }

    @Override
    public String verify() {
        if (this.toSource instanceof MathTransform2D) {
            try {
                Rectangle bounds = this.getBounds();
                Rectangle2D tb = Shapes2D.transform((MathTransform2D)this.toSource, (Rectangle2D)bounds, (Rectangle2D)bounds);
                if (!ImageUtilities.getBounds(this.getSource()).intersects(tb)) {
                    return "toSource";
                }
            }
            catch (TransformException e) {
                ResampledImage.recoverableException("verify", e);
                return "toSource";
            }
        }
        return super.verify();
    }

    private static void recoverableException(String method, Exception error) {
        Logging.recoverableException(ImageUtilities.LOGGER, ResampledImage.class, method, error);
    }

    @Override
    public ColorModel getColorModel() {
        RenderedImage image = this.getDestination();
        if (image == null) {
            image = this.getSource();
        }
        return image.getColorModel();
    }

    @Override
    public Object getProperty(String key) {
        switch (key) {
            case "org.apache.sis.SampleDimensions": 
            case "org.apache.sis.SampleResolutions": {
                return this.getSource().getProperty(key);
            }
            case "org.apache.sis.PositionalAccuracy": {
                return this.getPositionalAccuracy();
            }
            case "org.apache.sis.PositionalConsistency": {
                try {
                    return this.getPositionalConsistency();
                }
                catch (IllegalArgumentException | TransformException e) {
                    throw (ImagingOpException)new ImagingOpException(e.getMessage()).initCause(e);
                }
            }
            case "org.apache.sis.Mask": {
                if (this.hasNoMask()) break;
                return this.getMask();
            }
        }
        return super.getProperty(key);
    }

    @Override
    public String[] getPropertyNames() {
        Object[] inherited = this.getSource().getPropertyNames();
        String[] names = new String[]{"org.apache.sis.SampleDimensions", "org.apache.sis.SampleResolutions", "org.apache.sis.PositionalAccuracy", POSITIONAL_CONSISTENCY_KEY, "org.apache.sis.Mask"};
        int n = 0;
        for (String name : names) {
            if (name != POSITIONAL_CONSISTENCY_KEY && (name == "org.apache.sis.PositionalAccuracy" ? this.getPositionalAccuracyCount() == 0 : (name == "org.apache.sis.Mask" ? this.hasNoMask() : !ArraysExt.contains(inherited, name)))) continue;
            names[n++] = name;
        }
        return ArraysExt.resize(names, n);
    }

    @Override
    public final int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public final int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public final int getMinX() {
        return this.minX;
    }

    @Override
    public final int getMinY() {
        return this.minY;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected Raster computeTile(int tileX, int tileY, WritableRaster tile) throws TransformException {
        long[] maxValues;
        long[] minValues;
        double[] values;
        int[] intValues;
        boolean isInteger;
        int[] intTransfer;
        double[] transfer;
        boolean shortcut;
        boolean useFillValues;
        double yoff;
        double xoff;
        double ylim;
        double xlim;
        double ymax;
        double xmax;
        double ymin;
        double xmin;
        PixelIterator it;
        double[] coordinates;
        int tgtDim;
        int tileMaxY;
        int tileMaxX;
        int tileMinY;
        int tileMinX;
        int scanline;
        int numBands;
        block30: {
            block29: {
                if (tile == null) {
                    tile = this.createTile(tileX, tileY);
                }
                numBands = tile.getNumBands();
                scanline = tile.getWidth();
                tileMinX = tile.getMinX();
                tileMinY = tile.getMinY();
                tileMaxX = Math.addExact(tileMinX, scanline);
                tileMaxY = Math.addExact(tileMinY, tile.getHeight());
                tgtDim = this.toSourceSupport.getTargetDimensions();
                coordinates = new double[scanline * Math.max(2, tgtDim)];
                Dimension support = this.interpolation.getSupportSize();
                it = new PixelIterator.Builder().setWindowSize(support).create(this.getSource());
                Rectangle domain = it.getDomain();
                xmin = domain.getMinX();
                ymin = domain.getMinY();
                xmax = domain.getMaxX() - 1.0;
                ymax = domain.getMaxY() - 1.0;
                xlim = ResampledImage.interpolationLimit(xmax, support.width);
                ylim = ResampledImage.interpolationLimit(ymax, support.height);
                xoff = ResampledImage.interpolationSupportOffset(support.width) - 0.5;
                yoff = ResampledImage.interpolationSupportOffset(support.height) - 0.5;
                useFillValues = this.getDestination() == null;
                shortcut = useFillValues && Interpolation.NEAREST.equals(this.interpolation) && ImageUtilities.isLosslessConversion(this.sampleModel, tile.getSampleModel());
                transfer = null;
                intTransfer = null;
                isInteger = this.fillValues instanceof int[];
                if (!isInteger) break block29;
                int[] nArray = intValues = new int[scanline * numBands];
                if (shortcut) {
                    values = null;
                    minValues = null;
                    maxValues = null;
                    break block30;
                } else {
                    int b;
                    values = new double[numBands];
                    minValues = new long[numBands];
                    maxValues = new long[numBands];
                    SampleModel sm = tile.getSampleModel();
                    for (b = 0; b < numBands; ++b) {
                        maxValues[b] = Numerics.bitmask(sm.getSampleSize(b)) - 1L;
                    }
                    if (!ImageUtilities.isUnsignedType(sm)) {
                        for (b = 0; b < numBands; ++b) {
                            int n = b;
                            long l = maxValues[n] >>> 1;
                            maxValues[n] = l;
                            minValues[b] = l ^ 0xFFFFFFFFFFFFFFFFL;
                        }
                    }
                }
                break block30;
            }
            intValues = null;
            double[] dArray = values = new double[scanline * numBands];
            minValues = null;
            maxValues = null;
        }
        int sx = Integer.MAX_VALUE;
        int sy = Integer.MAX_VALUE;
        PixelIterator.Window<DoubleBuffer> buffer = it.createWindow(TransferType.DOUBLE);
        int ty = tileMinY;
        while (ty < tileMaxY) {
            int numX;
            void var35_31;
            int tx;
            int vi;
            int ci;
            int ci2 = 0;
            for (int tx2 = tileMinX; tx2 < tileMaxX; ++tx2) {
                coordinates[ci2++] = tx2;
                coordinates[ci2++] = ty;
            }
            this.toSourceSupport.transform(coordinates, 0, coordinates, 0, scanline);
            int posX = tileMinX;
            if (shortcut) {
                ci = 0;
                vi = 0;
                for (tx = tileMinX; tx < tileMaxX; ++tx, ci += tgtDim, vi += numBands) {
                    long y;
                    long x = (long)Math.floor(coordinates[ci]);
                    if (x >= (long)it.lowerX && x < (long)it.upperX && (y = (long)Math.floor(coordinates[ci + 1])) >= (long)it.lowerY && y < (long)it.upperY) {
                        boolean bl = sx != (sx = (int)x);
                        int n = sy;
                        sy = (int)y;
                        if (bl | n != sy) {
                            it.moveTo(sx, sy);
                        }
                        if (isInteger) {
                            intTransfer = it.getPixel(intTransfer);
                            System.arraycopy(intTransfer, 0, intValues, vi, numBands);
                            continue;
                        }
                        transfer = it.getPixel(transfer);
                        System.arraycopy(transfer, 0, values, vi, numBands);
                        continue;
                    }
                    System.arraycopy(this.fillValues, 0, var35_31, vi, numBands);
                }
            } else {
                ci = 0;
                vi = 0;
                for (tx = tileMinX; tx < tileMaxX; ++tx, ci += tgtDim) {
                    double x = coordinates[ci];
                    if (x <= xlim) {
                        double y;
                        double d = x;
                        double xf = d - (x = Math.max(xmin, Math.min(xmax, Math.floor(x))));
                        if (xf >= xoff && (y = coordinates[ci + 1]) <= ylim) {
                            double d2 = y;
                            double yf = d2 - (y = Math.max(ymin, Math.min(ymax, Math.floor(y))));
                            if (yf >= yoff) {
                                boolean bl = sx != (sx = (int)x);
                                int n = sy;
                                sy = (int)y;
                                if (bl | n != sy) {
                                    it.moveTo(sx, sy);
                                    buffer.update();
                                }
                                this.interpolation.interpolate((DoubleBuffer)buffer.values, numBands, xf, yf, values, isInteger ? 0 : vi);
                                if (isInteger) {
                                    for (int b = 0; b < numBands; ++b) {
                                        intValues[vi + b] = (int)Math.max(minValues[b], Math.min(maxValues[b], Math.round(values[b])));
                                    }
                                }
                                vi += numBands;
                                continue;
                            }
                        }
                    }
                    if (useFillValues) {
                        System.arraycopy(this.fillValues, 0, var35_31, vi, numBands);
                        vi += numBands;
                        continue;
                    }
                    if (vi != 0) {
                        int numX2 = vi / numBands;
                        if (isInteger) {
                            tile.setPixels(posX, ty, numX2, 1, intValues);
                        } else {
                            tile.setPixels(posX, ty, numX2, 1, values);
                        }
                        posX += numX2;
                        vi = 0;
                    }
                    ++posX;
                }
            }
            if ((numX = scanline - (posX - tileMinX)) != 0) {
                if (isInteger) {
                    tile.setPixels(posX, ty, numX, 1, intValues);
                } else {
                    tile.setPixels(posX, ty, numX, 1, values);
                }
            }
            ++ty;
        }
        return tile;
    }

    @Override
    protected Disposable prefetch(Rectangle tiles) {
        RenderedImage source = this.getSource();
        if (source instanceof PlanarImage) {
            try {
                Dimension s2 = this.interpolation.getSupportSize();
                Rectangle pixels = ImageUtilities.tilesToPixels(this, tiles);
                Rectangle2D.Double bounds = new Rectangle2D.Double((double)pixels.x - 0.5 * (double)s2.width, (double)pixels.y - 0.5 * (double)s2.height, (double)pixels.width + (double)s2.width, (double)pixels.height + (double)s2.height);
                pixels = (Rectangle)Shapes2D.transform(MathTransforms.bidimensional(this.toSource), (Rectangle2D)bounds, (Rectangle2D)pixels);
                ImageUtilities.clipBounds(source, pixels);
                return ((PlanarImage)source).prefetch(ImageUtilities.pixelsToTiles(source, pixels));
            }
            catch (TransformException e) {
                ResampledImage.recoverableException("prefetch", e);
            }
        }
        return super.prefetch(tiles);
    }

    public boolean equals(Object object) {
        if (this.equalsBase(object)) {
            ResampledImage other = (ResampledImage)object;
            return this.minX == other.minX && this.minY == other.minY && this.width == other.width && this.height == other.height && this.minTileX == other.minTileX && this.minTileY == other.minTileY && this.interpolation.equals(other.interpolation) && Objects.deepEquals(this.fillValues, other.fillValues) && this.toSource.equals(other.toSource);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCodeBase() + this.minX + 31 * (this.minY + 31 * (this.width + 31 * this.height)) + this.interpolation.hashCode() + this.toSource.hashCode();
    }
}

