/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ImageUtilities;
import org.apache.sis.coverage.grid.j2d.TileOpExecutor;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;

public abstract class PlanarImage
implements RenderedImage {
    public static final String GRID_GEOMETRY_KEY = "org.apache.sis.GridGeometry";
    public static final String POSITIONAL_ACCURACY_KEY = "org.apache.sis.PositionalAccuracy";
    public static final String SAMPLE_DIMENSIONS_KEY = "org.apache.sis.SampleDimensions";
    public static final String SAMPLE_RESOLUTIONS_KEY = "org.apache.sis.SampleResolutions";
    public static final String STATISTICS_KEY = "org.apache.sis.Statistics";
    public static final String MASK_KEY = "org.apache.sis.Mask";

    protected PlanarImage() {
    }

    @Override
    public Vector<RenderedImage> getSources() {
        return null;
    }

    @Override
    public Object getProperty(String key) {
        ArgumentChecks.ensureNonNull("key", key);
        return Image.UndefinedProperty;
    }

    @Override
    public String[] getPropertyNames() {
        return null;
    }

    public Rectangle getBounds() {
        return ImageUtilities.getBounds(this);
    }

    @Override
    public int getMinX() {
        return 0;
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMinTileX() {
        return 0;
    }

    @Override
    public int getMinTileY() {
        return 0;
    }

    @Override
    public int getNumXTiles() {
        return Numerics.ceilDiv(this.getWidth(), this.getTileWidth());
    }

    @Override
    public int getNumYTiles() {
        return Numerics.ceilDiv(this.getHeight(), this.getTileHeight());
    }

    @Override
    public int getTileGridXOffset() {
        return Math.toIntExact((long)this.getMinX() - Math.multiplyFull(this.getMinTileX(), this.getTileWidth()));
    }

    @Override
    public int getTileGridYOffset() {
        return Math.toIntExact((long)this.getMinY() - Math.multiplyFull(this.getMinTileY(), this.getTileHeight()));
    }

    private WritableRaster createWritableRaster(Rectangle aoi) {
        SampleModel sm = this.getSampleModel();
        if (sm.getWidth() != aoi.width || sm.getHeight() != aoi.height) {
            sm = sm.createCompatibleSampleModel(aoi.width, aoi.height);
        }
        return Raster.createWritableRaster(sm, aoi.getLocation());
    }

    @Override
    public Raster getData() {
        Rectangle aoi = this.getBounds();
        WritableRaster raster = this.createWritableRaster(aoi);
        PlanarImage.copyData(aoi, this, raster);
        return raster;
    }

    @Override
    public Raster getData(Rectangle aoi) {
        ArgumentChecks.ensureNonNull("aoi", aoi);
        if (!this.getBounds().contains(aoi)) {
            throw new IllegalArgumentException(Errors.format((short)119));
        }
        WritableRaster raster = this.createWritableRaster(aoi);
        PlanarImage.copyData(aoi, this, raster);
        return raster;
    }

    @Override
    public WritableRaster copyData(WritableRaster raster) {
        Rectangle aoi;
        if (raster != null) {
            aoi = raster.getBounds();
            ImageUtilities.clipBounds(this, aoi);
        } else {
            aoi = this.getBounds();
            raster = this.createWritableRaster(aoi);
        }
        if (!aoi.isEmpty()) {
            PlanarImage.copyData(aoi, this, raster);
        }
        return raster;
    }

    static void copyData(final Rectangle aoi, RenderedImage source, final WritableRaster target) {
        TileOpExecutor executor = new TileOpExecutor(source, aoi){

            @Override
            protected void readFrom(Raster tile) {
                Rectangle bounds = tile.getBounds();
                Rectangle t2 = aoi.intersection(bounds);
                if (!t2.equals(bounds)) {
                    tile = tile.createChild(t2.x, t2.y, t2.width, t2.height, t2.x, t2.y, null);
                }
                target.setRect(tile);
            }
        };
        executor.readFrom(source);
    }

    Disposable prefetch(Rectangle tiles) {
        return null;
    }

    static String verifyCompatibility(SampleModel sm, ColorModel cm) {
        if (cm == null || cm.isCompatibleSampleModel(sm)) {
            return null;
        }
        if (cm.getTransferType() != sm.getTransferType()) {
            return "transferType";
        }
        if (cm.getNumComponents() != sm.getNumBands()) {
            return "numComponents";
        }
        return "";
    }

    public String verify() {
        long remainder;
        int tileWidth = this.getTileWidth();
        int tileHeight = this.getTileHeight();
        SampleModel sm = this.getSampleModel();
        if (sm != null) {
            String cm = PlanarImage.verifyCompatibility(sm, this.getColorModel());
            if (cm != null) {
                Object p = "colorModel";
                if (!cm.isEmpty()) {
                    p = (String)p + "." + cm;
                }
                return p;
            }
            if (sm.getWidth() < tileWidth) {
                return "tileWidth";
            }
            if (sm.getHeight() < tileHeight) {
                return "tileHeight";
            }
        }
        if ((remainder = Math.multiplyFull(this.getNumXTiles(), tileWidth) - (long)this.getWidth()) != 0L) {
            return remainder >= 0L && remainder < (long)tileWidth ? "width" : "numXTiles";
        }
        remainder = Math.multiplyFull(this.getNumYTiles(), tileHeight) - (long)this.getHeight();
        if (remainder != 0L) {
            return remainder >= 0L && remainder < (long)tileHeight ? "height" : "numYTiles";
        }
        if (Math.multiplyFull(this.getMinTileX(), tileWidth) + (long)this.getTileGridXOffset() != (long)this.getMinX()) {
            return "tileX";
        }
        if (Math.multiplyFull(this.getMinTileY(), tileHeight) + (long)this.getTileGridYOffset() != (long)this.getMinY()) {
            return "tileY";
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer;
        block12: {
            ColorModel cm;
            buffer = new StringBuilder(100).append(Classes.getShortClassName(this)).append("[(").append(this.getWidth()).append(" \u00d7 ").append(this.getHeight()).append(") pixels");
            SampleModel sm = this.getSampleModel();
            if (sm != null) {
                buffer.append(" \u00d7 ").append(sm.getNumBands()).append(" bands");
                String type = ImageUtilities.getDataTypeName(sm);
                if (type != null) {
                    buffer.append(" of type ").append(type);
                }
            }
            if ((cm = this.getColorModel()) != null) {
                String transparency;
                buffer.append("; ");
                if (cm instanceof IndexColorModel) {
                    buffer.append(((IndexColorModel)cm).getMapSize()).append(" indexed colors");
                } else {
                    ColorModelFactory.formatDescription(cm.getColorSpace(), buffer);
                }
                switch (cm.getTransparency()) {
                    case 1: {
                        transparency = "opaque";
                        break;
                    }
                    case 3: {
                        transparency = "translucent";
                        break;
                    }
                    case 2: {
                        transparency = "bitmask transparency";
                        break;
                    }
                    default: {
                        break block12;
                    }
                }
                buffer.append("; ").append(transparency);
            }
        }
        int tx = this.getNumXTiles();
        int ty = this.getNumYTiles();
        if (tx != 1 || ty != 1) {
            buffer.append("; ").append(tx).append(" \u00d7 ").append(ty).append(" tiles");
        }
        buffer.append(']');
        String error = this.verify();
        if (error != null) {
            buffer.append(System.lineSeparator()).append("\u2514\u2500").append(Messages.format((short)34, error));
        }
        return buffer.toString();
    }
}

