/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.time.Instant;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.CurveExtremum;
import org.apache.sis.geometry.EnvelopeReducer;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundInEnvelope;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Range;
import org.apache.sis.metadata.internal.ReferencingServices;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.referencing.operation.DefaultCoordinateOperationFactory;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.util.CoordinateOperations;
import org.apache.sis.referencing.util.DirectPositionView;
import org.apache.sis.referencing.util.TemporalAccessor;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Static;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public final class Envelopes
extends Static {
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.geometry");
    static final double SPAN_FRACTION_AS_BOUND = 0.25;
    private static final boolean[] CORNERS = new boolean[]{false, false, false, true, true, true, true, false, false, false};

    private Envelopes() {
    }

    public static Envelope compound(Envelope ... components) throws FactoryException {
        ArgumentChecks.ensureNonNull("components", components);
        int sum = 0;
        for (int i = 0; i < components.length; ++i) {
            Envelope env = components[i];
            ArgumentChecks.ensureNonNullElement("components", i, env);
            sum += env.getDimension();
        }
        GeneralEnvelope compound = new GeneralEnvelope(sum);
        CoordinateReferenceSystem[] crsComponents = null;
        int firstAffectedCoordinate = 0;
        for (int i = 0; i < components.length; ++i) {
            Envelope env = components[i];
            int dim = env.getDimension();
            compound.subEnvelope(firstAffectedCoordinate, firstAffectedCoordinate += dim).setEnvelope(env);
            if (i == 0) {
                CoordinateReferenceSystem crs = env.getCoordinateReferenceSystem();
                if (crs == null) continue;
                crsComponents = new CoordinateReferenceSystem[components.length];
                crsComponents[0] = crs;
                continue;
            }
            if (crsComponents == null || (crsComponents[i] = env.getCoordinateReferenceSystem()) != null) continue;
            crsComponents = null;
        }
        if (firstAffectedCoordinate != sum) {
            throw new ConcurrentModificationException();
        }
        if (crsComponents != null) {
            compound.setCoordinateReferenceSystem(CRS.compound(crsComponents));
        }
        return compound;
    }

    public static GeneralEnvelope union(Envelope ... envelopes) throws TransformException {
        return EnvelopeReducer.UNION.reduce(envelopes);
    }

    public static GeneralEnvelope intersect(Envelope ... envelopes) throws TransformException {
        return EnvelopeReducer.INTERSECT.reduce(envelopes);
    }

    public static CoordinateOperation findOperation(Envelope source, Envelope target) throws FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateReferenceSystem sourceCRS;
        if (source != null && target != null && (sourceCRS = source.getCoordinateReferenceSystem()) != null && (targetCRS = target.getCoordinateReferenceSystem()) != null) {
            DefaultGeographicBoundingBox areaOfInterest = null;
            if (sourceCRS != targetCRS) {
                try {
                    ReferencingServices converter = ReferencingServices.getInstance();
                    areaOfInterest = converter.setBounds(source, null, "findOperation");
                    DefaultGeographicBoundingBox targetAOI = converter.setBounds(target, null, "findOperation");
                    if (areaOfInterest == null) {
                        areaOfInterest = targetAOI;
                    } else if (targetAOI != null) {
                        areaOfInterest.add(targetAOI);
                    }
                }
                catch (TransformException e) {
                    Logging.recoverableException(LOGGER, Envelopes.class, "findOperation", e);
                }
            }
            return CRS.findOperation(sourceCRS, targetCRS, areaOfInterest);
        }
        return null;
    }

    static void recoverableException(Class<? extends Static> caller, TransformException exception) {
        Logging.recoverableException(LOGGER, caller, "transform", exception);
    }

    static Matrix derivativeAndTransform(MathTransform transform, double[] srcPts, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        if (transform instanceof AbstractMathTransform) {
            return ((AbstractMathTransform)transform).transform(srcPts, 0, dstPts, dstOff, derivate);
        }
        Matrix derivative = derivate ? transform.derivative(new DirectPositionView.Double(srcPts, 0, transform.getSourceDimensions())) : null;
        transform.transform(srcPts, 0, dstPts, dstOff, 1);
        return derivative;
    }

    public static Envelope transform(Envelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (envelope != null && targetCRS != null && (sourceCRS = envelope.getCoordinateReferenceSystem()) != targetCRS) {
            if (sourceCRS == null) {
                envelope = new GeneralEnvelope(envelope);
                ((GeneralEnvelope)envelope).setCoordinateReferenceSystem(targetCRS);
            } else {
                CoordinateOperation operation;
                try {
                    operation = DefaultCoordinateOperationFactory.provider().createOperation(sourceCRS, targetCRS);
                }
                catch (FactoryException exception) {
                    throw new TransformException(Errors.format((short)16), exception);
                }
                envelope = Envelopes.transform(operation, envelope);
            }
            assert (Utilities.deepEquals(targetCRS, envelope.getCoordinateReferenceSystem(), ComparisonMode.DEBUG));
        }
        return envelope;
    }

    private static GeneralEnvelope transform(MathTransform transform, Envelope envelope, double[] targetPt, List<GeneralEnvelope> results) throws TransformException {
        if (transform.isIdentity()) {
            GeneralEnvelope transformed = new GeneralEnvelope(envelope);
            transformed.setCoordinateReferenceSystem(null);
            if (targetPt != null) {
                int i = envelope.getDimension();
                while (--i >= 0) {
                    targetPt[i] = transformed.getMedian(i);
                }
            }
            return transformed;
        }
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Errors.format((short)80, sourceDim, envelope.getDimension()));
        }
        if (sourceDim >= 20) {
            throw new ArithmeticException(Errors.format((short)37, sourceDim));
        }
        boolean isDerivativeSupported = true;
        DirectPosition temporary = null;
        GeneralEnvelope transformed = null;
        Matrix[] derivatives = new Matrix[Math.toIntExact(MathFunctions.pow(3L, sourceDim))];
        double[] coordinates = new double[Math.multiplyExact(derivatives.length, targetDim)];
        double[] sourcePt = new double[sourceDim];
        DirectPositionView.Double ordinatesView = new DirectPositionView.Double(coordinates, 0, targetDim);
        WraparoundInEnvelope.Controller wc = new WraparoundInEnvelope.Controller(transform);
        do {
            int i = sourceDim;
            while (--i >= 0) {
                sourcePt[i] = envelope.getMinimum(i);
            }
            int pointIndex = 0;
            block15: while (true) {
                int offset = pointIndex * targetDim;
                try {
                    derivatives[pointIndex] = Envelopes.derivativeAndTransform(wc.transform, sourcePt, coordinates, offset, isDerivativeSupported);
                }
                catch (TransformException e) {
                    if (!isDerivativeSupported) {
                        throw e;
                    }
                    isDerivativeSupported = false;
                    wc.transform.transform(sourcePt, 0, coordinates, offset, 1);
                    Envelopes.recoverableException(Envelopes.class, e);
                }
                if (transformed == null) {
                    transformed = new GeneralEnvelope(targetDim);
                    for (int i2 = 0; i2 < targetDim; ++i2) {
                        double value = coordinates[offset + i2];
                        transformed.setRange(i2, value, value);
                    }
                } else {
                    ordinatesView.offset = offset;
                    transformed.add(ordinatesView);
                }
                int indexBase3 = ++pointIndex;
                int dim = sourceDim;
                while (--dim >= 0) {
                    switch (indexBase3 % 3) {
                        case 0: {
                            sourcePt[dim] = envelope.getMinimum(dim);
                            break;
                        }
                        case 1: {
                            sourcePt[dim] = envelope.getMaximum(dim);
                            continue block15;
                        }
                        case 2: {
                            sourcePt[dim] = envelope.getMedian(dim);
                            continue block15;
                        }
                        default: {
                            throw new AssertionError(indexBase3);
                        }
                    }
                    indexBase3 /= 3;
                }
                break;
            }
            assert (pointIndex == derivatives.length) : pointIndex;
            DirectPositionView.Double sourceView = new DirectPositionView.Double(sourcePt, 0, sourceDim);
            CurveExtremum extremum = new CurveExtremum();
            for (int pointIndex2 = 0; pointIndex2 < derivatives.length; ++pointIndex2) {
                Matrix D12 = derivatives[pointIndex2];
                if (D12 == null) continue;
                int indexBase3 = pointIndex2;
                int power3 = 1;
                int i3 = sourceDim;
                while (--i3 >= 0) {
                    int medianIndex;
                    Matrix D22;
                    int digitBase3 = indexBase3 % 3;
                    if (digitBase3 != 2 && (D22 = derivatives[medianIndex = pointIndex2 + power3 * (2 - digitBase3)]) != null) {
                        double xmin = envelope.getMinimum(i3);
                        double xmax = envelope.getMaximum(i3);
                        double x2 = envelope.getMedian(i3);
                        double x1 = digitBase3 == 0 ? xmin : xmax;
                        int offset1 = targetDim * pointIndex2;
                        int offset2 = targetDim * medianIndex;
                        for (int j = 0; j < targetDim; ++j) {
                            extremum.resolve(x1, coordinates[offset1 + j], D12.getElement(j, i3), x2, coordinates[offset2 + j], D22.getElement(j, i3));
                            boolean isP2 = false;
                            do {
                                double y;
                                double x;
                                double d = x = isP2 ? extremum.ex2 : extremum.ex1;
                                if (!(x > xmin) || !(x < xmax)) continue;
                                double d2 = y = isP2 ? extremum.ey2 : extremum.ey1;
                                if (!(y < transformed.getMinimum(j)) && !(y > transformed.getMaximum(j))) continue;
                                int ib3 = pointIndex2;
                                int dim = sourceDim;
                                while (--dim >= 0) {
                                    double coordinate;
                                    if (dim == i3) {
                                        coordinate = x;
                                    } else {
                                        switch (ib3 % 3) {
                                            case 0: {
                                                coordinate = envelope.getMinimum(dim);
                                                break;
                                            }
                                            case 1: {
                                                coordinate = envelope.getMaximum(dim);
                                                break;
                                            }
                                            case 2: {
                                                coordinate = envelope.getMedian(dim);
                                                break;
                                            }
                                            default: {
                                                throw new AssertionError(ib3);
                                            }
                                        }
                                    }
                                    sourcePt[dim] = coordinate;
                                    ib3 /= 3;
                                }
                                temporary = wc.transform.transform(sourceView, temporary);
                                transformed.add(temporary);
                            } while (isP2 = !isP2);
                        }
                    }
                    indexBase3 /= 3;
                    power3 *= 3;
                }
                derivatives[pointIndex2] = null;
            }
            if (targetPt != null) {
                System.arraycopy(coordinates, coordinates.length - targetDim, targetPt, 0, targetDim);
                targetPt = null;
            }
            if (results == null) continue;
            results.add(transformed);
            transformed = null;
        } while (wc.translate());
        return transformed;
    }

    public static GeneralEnvelope transform(CoordinateOperation operation, Envelope envelope) throws TransformException {
        long includedBoundsValue;
        CoordinateReferenceSystem targetCRS;
        CoordinateSystem cs;
        CoordinateReferenceSystem crs;
        ArgumentChecks.ensureNonNull("operation", operation);
        if (envelope == null) {
            return null;
        }
        boolean isOperationComplete = true;
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !Utilities.equalsIgnoreMetadata(crs, sourceCRS)) {
            MathTransform mt;
            try {
                mt = DefaultCoordinateOperationFactory.provider().createOperation(crs, sourceCRS).getMathTransform();
            }
            catch (FactoryException e) {
                throw new TransformException(Errors.format((short)16), e);
            }
            if (!mt.isIdentity()) {
                isOperationComplete = false;
                envelope = Envelopes.transform(mt, envelope);
            }
        }
        MathTransform mt = operation.getMathTransform();
        double[] centerPt = new double[mt.getTargetDimensions()];
        GeneralEnvelope transformed = Envelopes.transform(mt, envelope, centerPt, null);
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null) {
            GeneralDirectPosition sourcePt = null;
            DirectPosition targetPt = null;
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                boolean b2;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null) continue;
                double min2 = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                double v1 = axis.getMinimumValue();
                double v2 = axis.getMaximumValue();
                boolean b1 = v1 > min2 && v1 < max;
                boolean bl = b2 = v2 > min2 && v2 < max;
                if (!b1 && !b2) continue;
                if (sourcePt == null) {
                    sourcePt = new GeneralDirectPosition(dimension);
                    for (int j = 0; j < dimension; ++j) {
                        sourcePt.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (b1) {
                    sourcePt.setOrdinate(i, v1);
                    targetPt = mt.transform(sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                if (b2) {
                    sourcePt.setOrdinate(i, v2);
                    targetPt = mt.transform(sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                sourcePt.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((targetCRS = operation.getTargetCRS()) == null) {
            return transformed;
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        MathTransform inverse = null;
        TransformException warning = null;
        AbstractEnvelope sourceBox = null;
        DirectPosition sourcePt = null;
        DirectPosition targetPt = null;
        DirectPosition revertPt = null;
        long includedMinValue = 0L;
        long includedMaxValue = 0L;
        long isWrapAroundAxis = 0L;
        int dimension = targetCS.getDimension();
        block10: for (int i = 0; i < dimension; ++i) {
            long dimensionBitMask = Numerics.bitmask(i);
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis == null) continue;
            boolean testMax = false;
            do {
                double extremum;
                double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                if (!Double.isFinite(extremum)) continue;
                if (inverse == null) {
                    try {
                        inverse = mt.inverse();
                    }
                    catch (NoninvertibleTransformException exception) {
                        if (dimension < mt.getSourceDimensions()) break block10;
                        warning = exception;
                        break block10;
                    }
                    targetPt = new GeneralDirectPosition((double[])centerPt.clone());
                    sourceBox = AbstractEnvelope.castOrCopy(envelope);
                }
                targetPt.setOrdinate(i, extremum);
                try {
                    double delta;
                    sourcePt = inverse.transform(targetPt, sourcePt);
                    if (!sourceBox.contains(sourcePt) || CoordinateOperations.isWrapAround(axis) && !((delta = Math.abs((revertPt = mt.transform(sourcePt, revertPt)).getOrdinate(i) - extremum)) < 0.25 * (axis.getMaximumValue() - axis.getMinimumValue()))) continue;
                    transformed.add(targetPt);
                    if (testMax) {
                        includedMaxValue |= dimensionBitMask;
                        continue;
                    }
                    includedMinValue |= dimensionBitMask;
                }
                catch (TransformException exception) {
                    if (warning == null) {
                        warning = exception;
                        continue;
                    }
                    warning.addSuppressed(exception);
                }
            } while (testMax = !testMax);
            if ((includedMinValue & includedMaxValue & dimensionBitMask) == 0L && CoordinateOperations.isWrapAround(axis)) {
                isWrapAroundAxis |= dimensionBitMask;
            }
            if (targetPt == null) continue;
            targetPt.setOrdinate(i, centerPt[i]);
        }
        if ((includedBoundsValue = includedMinValue | includedMaxValue) != 0L) {
            while (isWrapAroundAxis != 0L) {
                long bm;
                int wrapAroundDimension = Long.numberOfTrailingZeros(isWrapAroundAxis);
                long dimensionBitMask = Numerics.bitmask(wrapAroundDimension);
                isWrapAroundAxis &= dimensionBitMask ^ 0xFFFFFFFFFFFFFFFFL;
                CoordinateSystemAxis wrapAroundAxis = targetCS.getAxis(wrapAroundDimension);
                double min3 = wrapAroundAxis.getMinimumValue();
                double max = wrapAroundAxis.getMaximumValue();
                for (long am = includedBoundsValue & (dimensionBitMask ^ 0xFFFFFFFFFFFFFFFFL); am != 0L; am &= bm ^ 0xFFFFFFFFFFFFFFFFL) {
                    bm = Long.lowestOneBit(am);
                    int axisIndex = Long.numberOfTrailingZeros(bm);
                    CoordinateSystemAxis axis = targetCS.getAxis(axisIndex);
                    for (int c = 0; c < 4; ++c) {
                        double value;
                        if ((c & 1) == 0) {
                            if (((c == 0 ? includedMinValue : includedMaxValue) & bm) == 0L) {
                                ++c;
                                continue;
                            }
                            targetPt.setOrdinate(axisIndex, c == 0 ? axis.getMinimumValue() : axis.getMaximumValue());
                            value = min3;
                        } else {
                            value = max;
                        }
                        targetPt.setOrdinate(wrapAroundDimension, value);
                        try {
                            sourcePt = inverse.transform(targetPt, sourcePt);
                            if (!sourceBox.contains(sourcePt)) continue;
                            transformed.add(targetPt);
                            continue;
                        }
                        catch (TransformException exception) {
                            if (warning == null) {
                                warning = exception;
                                continue;
                            }
                            warning.addSuppressed(exception);
                        }
                    }
                    targetPt.setOrdinate(axisIndex, centerPt[axisIndex]);
                }
                targetPt.setOrdinate(wrapAroundDimension, centerPt[wrapAroundDimension]);
            }
        }
        Set<Integer> wrapAroundChanges = isOperationComplete && operation instanceof AbstractCoordinateOperation ? ((AbstractCoordinateOperation)operation).getWrapAroundChanges() : CoordinateOperations.wrapAroundChanges(sourceCRS, targetCS);
        transformed.normalize(targetCS, 0, wrapAroundChanges.size(), wrapAroundChanges.iterator());
        if (warning != null) {
            Envelopes.recoverableException(Envelopes.class, warning);
        }
        return transformed;
    }

    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", transform);
        return envelope != null ? Envelopes.transform(transform, envelope, null, null) : null;
    }

    public static GeneralEnvelope[] wraparound(MathTransform transform, Envelope envelope) throws TransformException {
        ArgumentChecks.ensureNonNull("transform", transform);
        if (envelope == null) {
            return new GeneralEnvelope[0];
        }
        ArrayList<GeneralEnvelope> results = new ArrayList<GeneralEnvelope>(4);
        GeneralEnvelope transformed = Envelopes.transform(transform, envelope, null, results);
        if (results.isEmpty() && transformed != null) {
            return new GeneralEnvelope[]{transformed};
        }
        return (GeneralEnvelope[])results.toArray(GeneralEnvelope[]::new);
    }

    public static Envelope fromWKT(CharSequence wkt) throws FactoryException {
        ArgumentChecks.ensureNonNull("wkt", wkt);
        try {
            return new GeneralEnvelope(wkt);
        }
        catch (IllegalArgumentException e) {
            throw new FactoryException(Errors.format((short)154, Envelope.class), e);
        }
    }

    public static String toString(Envelope envelope) {
        return AbstractEnvelope.toString(envelope, false);
    }

    public static String toPolygonWKT(Envelope envelope) throws IllegalArgumentException {
        double length;
        int dimension;
        for (dimension = envelope.getDimension(); dimension != 0 && !Double.isFinite(length = envelope.getSpan(dimension - 1)); --dimension) {
        }
        if (dimension < 2) {
            throw new IllegalArgumentException(Errors.format((short)31));
        }
        StringBuilder buffer = new StringBuilder("POLYGON(");
        String separator = "(";
        for (int corner = 0; corner < CORNERS.length; corner += 2) {
            for (int i = 0; i < dimension; ++i) {
                double value;
                switch (i) {
                    case 0: 
                    case 1: {
                        value = CORNERS[corner + i] ? envelope.getMaximum(i) : envelope.getMinimum(i);
                        break;
                    }
                    default: {
                        value = envelope.getMedian(i);
                    }
                }
                StringBuilders.trimFractionalPart(buffer.append(separator).append(value));
                separator = " ";
            }
            separator = ", ";
        }
        return buffer.append("))").toString();
    }

    public static Optional<Range<Instant>> toTimeRange(Envelope envelope) {
        TemporalAccessor t2;
        if (envelope != null && (t2 = TemporalAccessor.of(envelope.getCoordinateReferenceSystem(), 0)) != null) {
            return Optional.of(t2.getTimeRange(envelope));
        }
        return Optional.empty();
    }
}

