/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.internal;

import java.util.Arrays;
import org.apache.sis.coverage.internal.CompoundTransform;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class RepeatedTransform
extends CompoundTransform {
    private final MathTransform component;
    private final int repetition;

    RepeatedTransform(MathTransform component, int repetition) {
        this.component = component;
        this.repetition = repetition;
    }

    @Override
    final MathTransform[] components() {
        Object[] components = new MathTransform[this.repetition];
        Arrays.fill(components, this.component);
        return components;
    }

    @Override
    public int getSourceDimensions() {
        return this.component.getSourceDimensions() * this.repetition;
    }

    @Override
    public int getTargetDimensions() {
        return this.component.getTargetDimensions() * this.repetition;
    }

    @Override
    public boolean isIdentity() {
        return this.component.isIdentity();
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        MatrixSIS m4;
        if (derivate) {
            m4 = Matrices.createZero(this.repetition, this.repetition);
            for (int i = 0; i < this.repetition; ++i) {
                m4.setElement(i, i, ((MathTransform1D)this.component).derivative(srcPts[srcOff + i]));
            }
        } else {
            m4 = null;
        }
        this.component.transform(srcPts, srcOff, dstPts, dstOff, this.repetition);
        return m4;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.component.transform(srcPts, srcOff, dstPts, dstOff, numPts * this.repetition);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.component.transform(srcPts, srcOff, dstPts, dstOff, numPts * this.repetition);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        this.component.transform(srcPts, srcOff, dstPts, dstOff, numPts * this.repetition);
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        this.component.transform(srcPts, srcOff, dstPts, dstOff, numPts * this.repetition);
    }
}

