/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid.j2d;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.util.Map;
import org.apache.sis.coverage.grid.j2d.DeferredProperty;
import org.apache.sis.image.PlanarImage;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public class TiledImage
extends PlanarImage {
    private final ColorModel colorModel;
    private final int width;
    private final int height;
    private final int minTileX;
    private final int minTileY;
    private final Raster[] tiles;
    private final Map<String, Object> properties;

    public TiledImage(Map<String, Object> properties, ColorModel colorModel, int width, int height, int minTileX, int minTileY, Raster ... tiles) {
        ArgumentChecks.ensureStrictlyPositive("width", width);
        ArgumentChecks.ensureStrictlyPositive("height", height);
        ArgumentChecks.ensureNonEmpty("tiles", tiles);
        this.colorModel = colorModel;
        this.width = width;
        this.height = height;
        this.minTileX = minTileX;
        this.minTileY = minTileY;
        this.tiles = tiles;
        this.properties = properties != null ? Map.copyOf(properties) : Map.of();
    }

    @Override
    public String verify() {
        int minX = this.getMinX();
        int minY = this.getMinY();
        int numXTiles = this.getNumXTiles();
        int tileWidth = this.getTileWidth();
        int tileHeight = this.getTileHeight();
        SampleModel sm = this.getSampleModel();
        for (int i = 0; i < this.tiles.length; ++i) {
            Raster tile = this.tiles[i];
            int tx = i % numXTiles;
            int ty = i / numXTiles;
            int ox = minX + tx * tileWidth;
            int oy = minY + ty * tileHeight;
            if (tile.getMinX() != ox) {
                return TiledImage.property(tx, ty, "x");
            }
            if (tile.getMinY() != oy) {
                return TiledImage.property(tx, ty, "y");
            }
            int tw = tile.getWidth();
            int th = tile.getHeight();
            if (tw != tileWidth || th != tileHeight) {
                if (tw != Math.min(tileWidth, this.width - ox)) {
                    return TiledImage.property(tx, ty, "width");
                }
                if (th != Math.min(tileHeight, this.height - oy)) {
                    return TiledImage.property(tx, ty, "height");
                }
            }
            if (sm.equals(tile.getSampleModel())) continue;
            return TiledImage.property(tx, ty, "sampleModel");
        }
        return super.verify();
    }

    private static String property(int tx, int ty, String name) {
        return "tiles[" + tx + ", " + ty + "]." + name;
    }

    @Override
    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public SampleModel getSampleModel() {
        return this.tiles[0].getSampleModel();
    }

    @Override
    public Object getProperty(String key) {
        Object value = this.properties.getOrDefault(key, Image.UndefinedProperty);
        if (value instanceof DeferredProperty) {
            value = ((DeferredProperty)value).compute(this);
        }
        return value;
    }

    @Override
    public String[] getPropertyNames() {
        int n = this.properties.size();
        return n == 0 ? null : this.properties.keySet().toArray(new String[n]);
    }

    @Override
    public int getMinX() {
        return this.tiles[0].getMinX();
    }

    @Override
    public int getMinY() {
        return this.tiles[0].getMinY();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getTileWidth() {
        return this.tiles[0].getWidth();
    }

    @Override
    public int getTileHeight() {
        return this.tiles[0].getHeight();
    }

    @Override
    public int getMinTileX() {
        return this.minTileX;
    }

    @Override
    public int getMinTileY() {
        return this.minTileY;
    }

    @Override
    public Raster getTile(int tileX, int tileY) {
        int numXTiles = this.getNumXTiles();
        int numYTiles = this.getNumYTiles();
        tileX = TiledImage.verifyTileIndex("tileX", tileX, this.minTileX, numXTiles);
        tileY = TiledImage.verifyTileIndex("tileY", tileY, this.minTileY, numYTiles);
        return this.tiles[tileX + tileY * numXTiles];
    }

    private static int verifyTileIndex(String name, int value, int min2, int count) {
        int r = value - min2;
        if (r >= 0 && r < count) {
            return r;
        }
        throw new IndexOutOfBoundsException(Errors.format((short)166, name, min2, min2 + count - 1, value));
    }
}

