/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.management;

import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.management.C3P0RegistryManager;
import com.mchange.v2.c3p0.management.DynamicPooledDataSourceManagerMBean;
import com.mchange.v2.c3p0.management.ManagementCoordinator;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ActiveManagementCoordinator
implements ManagementCoordinator {
    public static final String C3P0_REGISTRY_NAME_KEY = "com.mchange.v2.c3p0.management.RegistryName";
    private static final String C3P0_REGISTRY_NAME_PFX = "com.mchange.v2.c3p0:type=C3P0Registry";
    public static final String EXCLUDE_IDENTITY_TOKEN_KEY = "com.mchange.v2.c3p0.management.ExcludeIdentityToken";
    static final MLogger logger = MLog.getLogger(ActiveManagementCoordinator.class);
    static final boolean EXCLUDE_IDENTITY_TOKEN;
    final MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
    final String regName = ActiveManagementCoordinator.getRegistryName();

    @Override
    public void attemptManageC3P0Registry() {
        block4: {
            try {
                ObjectName objectName = new ObjectName(this.regName);
                C3P0RegistryManager c3P0RegistryManager = new C3P0RegistryManager();
                if (this.mbs.isRegistered(objectName)) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.warning("A C3P0Registry mbean is already registered. This probably means that an application using c3p0 was undeployed, but not all PooledDataSources were closed prior to undeployment. This may lead to resource leaks over time. Please take care to close all PooledDataSources.");
                    }
                    this.mbs.unregisterMBean(objectName);
                }
                this.mbs.registerMBean(c3P0RegistryManager, objectName);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "Failed to set up C3P0RegistryManager mBean. [c3p0 will still function normally, but management via JMX may not be possible.]", exception);
            }
        }
    }

    @Override
    public void attemptUnmanageC3P0Registry() {
        block6: {
            try {
                ObjectName objectName = new ObjectName(this.regName);
                if (this.mbs.isRegistered(objectName)) {
                    this.mbs.unregisterMBean(objectName);
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "C3P0Registry mbean unregistered.");
                    }
                } else if (logger.isLoggable(MLevel.FINE)) {
                    logger.fine("The C3P0Registry mbean was not found in the registry, so could not be unregistered.");
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block6;
                logger.log(MLevel.WARNING, "An Exception occurred while trying to unregister the C3P0RegistryManager mBean." + exception);
            }
        }
    }

    @Override
    public void attemptManagePooledDataSource(PooledDataSource pooledDataSource) {
        block3: {
            String string = null;
            try {
                string = ActiveManagementCoordinator.getPdsObjectNameStr(pooledDataSource);
                ObjectName objectName = new ObjectName(string);
                if (this.mbs.isRegistered(objectName) && logger.isLoggable(MLevel.WARNING)) {
                    logger.warning("You are attempting to register an mbean '" + string + "', but an mbean by that name is already registered. The new mbean will replace the old one in the MBean server. " + (EXCLUDE_IDENTITY_TOKEN ? "Since you have excluded the guaranteed-unique identity token, you must take care to give each PooledDataSource a unique dataSourceName." : "This should not happen unless you have (pathologically) modified the DataSource's guaranteed-unique identityToken."));
                }
                DynamicPooledDataSourceManagerMBean dynamicPooledDataSourceManagerMBean = new DynamicPooledDataSourceManagerMBean(pooledDataSource, string, this.mbs);
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block3;
                logger.log(MLevel.WARNING, "Failed to set up a PooledDataSourceManager mBean. [ " + (string == null ? pooledDataSource.toString() : string) + " ] c3p0 will still function normally, but management of this DataSource by JMX may not be possible.", exception);
            }
        }
    }

    @Override
    public void attemptUnmanagePooledDataSource(PooledDataSource pooledDataSource) {
        block6: {
            String string = null;
            try {
                string = ActiveManagementCoordinator.getPdsObjectNameStr(pooledDataSource);
                ObjectName objectName = new ObjectName(string);
                if (this.mbs.isRegistered(objectName)) {
                    this.mbs.unregisterMBean(objectName);
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "MBean: " + string + " unregistered.");
                    }
                } else if (logger.isLoggable(MLevel.FINE)) {
                    logger.fine("The mbean " + string + " was not found in the registry, so could not be unregistered.");
                }
            }
            catch (Exception exception) {
                if (!logger.isLoggable(MLevel.WARNING)) break block6;
                logger.log(MLevel.WARNING, "An Exception occurred while unregistering mBean. [" + (string == null ? pooledDataSource.toString() : string) + "] ", exception);
            }
        }
    }

    static String getPdsObjectNameStr(PooledDataSource pooledDataSource) {
        String string = pooledDataSource.getDataSourceName();
        if (string == null && EXCLUDE_IDENTITY_TOKEN) {
            string = pooledDataSource.getIdentityToken();
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("com.mchange.v2.c3p0:type=PooledDataSource");
        if (!EXCLUDE_IDENTITY_TOKEN) {
            stringBuilder.append(",identityToken=");
            stringBuilder.append(pooledDataSource.getIdentityToken());
        }
        if (string != null) {
            stringBuilder.append(",name=");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static String getRegistryName() {
        String string = C3P0Config.getMultiPropertiesConfig().getProperty(C3P0_REGISTRY_NAME_KEY);
        string = string == null ? C3P0_REGISTRY_NAME_PFX : "com.mchange.v2.c3p0:type=C3P0Registry,name=" + string;
        return string;
    }

    static {
        String string = C3P0Config.getMultiPropertiesConfig().getProperty(EXCLUDE_IDENTITY_TOKEN_KEY);
        EXCLUDE_IDENTITY_TOKEN = string == null ? false : Boolean.parseBoolean(string.trim().toLowerCase());
        if (EXCLUDE_IDENTITY_TOKEN) {
            logger.info("com.mchange.v2.c3p0.management.ExcludeIdentityToken set to true; please ensure unique dataSourceName values are set for all PooledDataSources.");
        }
    }
}

