/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v2.c3p0.cfg.InvalidConfigException;
import com.mchange.v2.c3p0.cfg.Validator;

public final class Validators {
    public static Validator<String> MarkSessionBoundaries = new AbstractValidator<String>("markSessionBoundaries"){

        @Override
        String _validate(String string) throws InvalidConfigException {
            String string2 = string.toLowerCase();
            if ("always".equals(string2) || "never".equals(string2) || "if-no-statement-cache".equals(string2)) {
                return string2;
            }
            throw new InvalidConfigException(this.param + " must be one of 'always', 'never', or 'if-no-statement-cache'. Found '" + string + "'.");
        }
    };
    public static Validator<String> ContextClassLoaderSource = new AbstractValidator<String>("contextClassLoaderSource"){

        @Override
        String _validate(String string) throws InvalidConfigException {
            String string2 = string.toLowerCase();
            if ("caller".equals(string2) || "library".equals(string2) || "none".equals(string2)) {
                return string2;
            }
            throw new InvalidConfigException(this.param + " must be one of 'caller', 'library', or 'none'. Found '" + string + "'.");
        }
    };

    private Validators() {
    }

    static abstract class AbstractValidator<T>
    implements Validator<T> {
        String param;

        AbstractValidator(String string) {
            this.param = string;
        }

        abstract T _validate(T var1) throws InvalidConfigException;

        @Override
        public T validate(T t2) throws InvalidConfigException {
            try {
                return this._validate(t2);
            }
            catch (InvalidConfigException invalidConfigException) {
                throw invalidConfigException;
            }
            catch (Exception exception) {
                throw new InvalidConfigException("While validating '" + this.param + "', encountered Exception: " + exception, exception);
            }
        }
    }
}

