/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Version {
    private static final Log LOG = LogFactory.getLog(Version.class);
    private static final String PDFBOX_VERSION_PROPERTIES = "/org/apache/pdfbox/resources/version.properties";

    private Version() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream resourceAsStream = Version.class.getResourceAsStream(PDFBOX_VERSION_PROPERTIES);){
            String string;
            try (BufferedInputStream is = new BufferedInputStream(resourceAsStream);){
                Properties properties = new Properties();
                properties.load(is);
                string = properties.getProperty("pdfbox.version", null);
            }
            return string;
        }
        catch (IOException io) {
            LOG.debug("Unable to read version from properties - returning null", io);
            return null;
        }
    }
}

