/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="encrypt", header={"Encrypts a PDF document"}, description={"${COMMAND-NAME} will read an unencrypted document and encrypt it either using a password or a certificate.%n", "While encrypting the document permissions can be set which will allow/disallow certain functionality"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class Encrypt
implements Callable<Integer> {
    private final PrintStream SYSERR;
    @CommandLine.Option(names={"-O"}, description={"set the owner password (ignored if certFile is set)"}, arity="0..1", interactive=true)
    private String ownerPassword;
    @CommandLine.Option(names={"-U"}, description={"set the user password (ignored if certFile is set)"}, arity="0..1", interactive=true)
    private String userPassword;
    @CommandLine.Option(names={"-certFile"}, paramLabel="certFile", description={"Path to X.509 certificate (repeat both if needed)"})
    private List<File> certFileList = new ArrayList<File>();
    @CommandLine.Option(names={"-canAssemble"}, description={"set the assemble permission (default: ${DEFAULT-VALUE})"})
    private boolean canAssembleDocument = true;
    @CommandLine.Option(names={"-canExtractContent"}, description={"set the extraction permission (default: ${DEFAULT-VALUE})"})
    private boolean canExtractContent = true;
    @CommandLine.Option(names={"-canExtractForAccessibility"}, description={"set the extraction permission (default: ${DEFAULT-VALUE})"})
    private boolean canExtractForAccessibility = true;
    @CommandLine.Option(names={"-canFillInForm"}, description={"set the form fill in permission (default: ${DEFAULT-VALUE})"})
    private boolean canFillInForm = true;
    @CommandLine.Option(names={"-canModify"}, description={"set the modify permission (default: ${DEFAULT-VALUE})"})
    private boolean canModify = true;
    @CommandLine.Option(names={"-canModifyAnnotations"}, description={"set the modify annots permission (default: ${DEFAULT-VALUE})"})
    private boolean canModifyAnnotations = true;
    @CommandLine.Option(names={"-canPrint"}, description={"set the print permission (default: ${DEFAULT-VALUE})"})
    private boolean canPrint = true;
    @CommandLine.Option(names={"-canPrintFaithful"}, description={"set the print faithful permission (default: ${DEFAULT-VALUE})"})
    private boolean canPrintFaithful = true;
    @CommandLine.Option(names={"-keyLength"}, description={"Key length in bits (valid values: 40, 128 or 256) (default: ${DEFAULT-VALUE})"})
    private int keyLength = 256;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to encrypt"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the encrypted PDF file. If omitted the original file is overwritten."})
    private File outfile;

    public Encrypt() {
        this.SYSERR = System.err;
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine(new Encrypt()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        block20: {
            AccessPermission ap = new AccessPermission();
            ap.setCanAssembleDocument(this.canAssembleDocument);
            ap.setCanExtractContent(this.canExtractContent);
            ap.setCanExtractForAccessibility(this.canExtractForAccessibility);
            ap.setCanFillInForm(this.canFillInForm);
            ap.setCanModify(this.canModify);
            ap.setCanModifyAnnotations(this.canModifyAnnotations);
            ap.setCanPrint(this.canPrint);
            ap.setCanPrintFaithful(this.canPrintFaithful);
            if (this.outfile == null) {
                this.outfile = this.infile;
            }
            try (PDDocument document = Loader.loadPDF(this.infile);){
                if (!document.isEncrypted()) {
                    if (!document.getSignatureDictionaries().isEmpty()) {
                        this.SYSERR.println("Warning: Document contains signatures which will be invalidated by encryption.");
                    }
                    if (!this.certFileList.isEmpty()) {
                        PublicKeyProtectionPolicy ppp = new PublicKeyProtectionPolicy();
                        PublicKeyRecipient recip = new PublicKeyRecipient();
                        recip.setPermission(ap);
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        for (File certFile : this.certFileList) {
                            try (FileInputStream inStream = new FileInputStream(certFile);){
                                X509Certificate certificate = (X509Certificate)cf.generateCertificate(inStream);
                                recip.setX509(certificate);
                            }
                            ppp.addRecipient(recip);
                        }
                        ppp.setEncryptionKeyLength(this.keyLength);
                        document.protect(ppp);
                    } else {
                        StandardProtectionPolicy spp = new StandardProtectionPolicy(this.ownerPassword, this.userPassword, ap);
                        spp.setEncryptionKeyLength(this.keyLength);
                        document.protect(spp);
                    }
                    document.save(this.outfile);
                    break block20;
                }
                this.SYSERR.println("Error: Document is already encrypted.");
            }
            catch (IOException | CertificateException ex) {
                this.SYSERR.println("Error encrypting PDF [" + ex.getClass().getSimpleName() + "]: " + ex.getMessage());
                return 4;
            }
        }
        return 0;
    }
}

