/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CharStringCommand {
    private final Type1KeyWord type1KeyWord;
    private final Type2KeyWord type2KeyWord;
    private static final Map<Integer, CharStringCommand> CHAR_STRING_COMMANDS = CharStringCommand.createMap();
    public static final CharStringCommand COMMAND_CLOSEPATH = CharStringCommand.getInstance(Key.access$000(Key.CLOSEPATH));
    public static final CharStringCommand COMMAND_RLINETO = CharStringCommand.getInstance(Key.access$000(Key.RLINETO));
    public static final CharStringCommand COMMAND_HLINETO = CharStringCommand.getInstance(Key.access$000(Key.HLINETO));
    public static final CharStringCommand COMMAND_VLINETO = CharStringCommand.getInstance(Key.access$000(Key.VLINETO));
    public static final CharStringCommand COMMAND_RRCURVETO = CharStringCommand.getInstance(Key.access$000(Key.RRCURVETO));
    public static final CharStringCommand COMMAND_HSBW = CharStringCommand.getInstance(Key.access$000(Key.HSBW));
    public static final CharStringCommand COMMAND_CALLOTHERSUBR = CharStringCommand.getInstance(Key.access$000(Key.CALLOTHERSUBR));
    private static final int KEY_UNKNOWN = 99;
    private static final CharStringCommand COMMAND_UNKNOWN = new CharStringCommand(99, 0);

    private static Map<Integer, CharStringCommand> createMap() {
        HashMap<Integer, CharStringCommand> charStringCommandMap = new HashMap<Integer, CharStringCommand>();
        charStringCommandMap.put(Key.HSTEM.hashValue, new CharStringCommand(Key.HSTEM));
        charStringCommandMap.put(Key.VSTEM.hashValue, new CharStringCommand(Key.VSTEM));
        charStringCommandMap.put(Key.VMOVETO.hashValue, new CharStringCommand(Key.VMOVETO));
        charStringCommandMap.put(Key.RLINETO.hashValue, new CharStringCommand(Key.RLINETO));
        charStringCommandMap.put(Key.HLINETO.hashValue, new CharStringCommand(Key.HLINETO));
        charStringCommandMap.put(Key.VLINETO.hashValue, new CharStringCommand(Key.VLINETO));
        charStringCommandMap.put(Key.RRCURVETO.hashValue, new CharStringCommand(Key.RRCURVETO));
        charStringCommandMap.put(Key.CLOSEPATH.hashValue, new CharStringCommand(Key.CLOSEPATH));
        charStringCommandMap.put(Key.CALLSUBR.hashValue, new CharStringCommand(Key.CALLSUBR));
        charStringCommandMap.put(Key.RET.hashValue, new CharStringCommand(Key.RET));
        charStringCommandMap.put(Key.ESCAPE.hashValue, new CharStringCommand(Key.ESCAPE));
        charStringCommandMap.put(Key.HSBW.hashValue, new CharStringCommand(Key.HSBW));
        charStringCommandMap.put(Key.ENDCHAR.hashValue, new CharStringCommand(Key.ENDCHAR));
        charStringCommandMap.put(Key.HSTEMHM.hashValue, new CharStringCommand(Key.HSTEMHM));
        charStringCommandMap.put(Key.HINTMASK.hashValue, new CharStringCommand(Key.HINTMASK));
        charStringCommandMap.put(Key.CNTRMASK.hashValue, new CharStringCommand(Key.CNTRMASK));
        charStringCommandMap.put(Key.RMOVETO.hashValue, new CharStringCommand(Key.RMOVETO));
        charStringCommandMap.put(Key.HMOVETO.hashValue, new CharStringCommand(Key.HMOVETO));
        charStringCommandMap.put(Key.VSTEMHM.hashValue, new CharStringCommand(Key.VSTEMHM));
        charStringCommandMap.put(Key.RCURVELINE.hashValue, new CharStringCommand(Key.RCURVELINE));
        charStringCommandMap.put(Key.RLINECURVE.hashValue, new CharStringCommand(Key.RLINECURVE));
        charStringCommandMap.put(Key.VVCURVETO.hashValue, new CharStringCommand(Key.VVCURVETO));
        charStringCommandMap.put(Key.HHCURVETO.hashValue, new CharStringCommand(Key.HHCURVETO));
        charStringCommandMap.put(Key.SHORTINT.hashValue, new CharStringCommand(Key.SHORTINT));
        charStringCommandMap.put(Key.CALLGSUBR.hashValue, new CharStringCommand(Key.CALLGSUBR));
        charStringCommandMap.put(Key.VHCURVETO.hashValue, new CharStringCommand(Key.VHCURVETO));
        charStringCommandMap.put(Key.HVCURVETO.hashValue, new CharStringCommand(Key.HVCURVETO));
        charStringCommandMap.put(Key.DOTSECTION.hashValue, new CharStringCommand(12, 0));
        charStringCommandMap.put(Key.VSTEM3.hashValue, new CharStringCommand(12, 1));
        charStringCommandMap.put(Key.HSTEM3.hashValue, new CharStringCommand(12, 2));
        charStringCommandMap.put(Key.AND.hashValue, new CharStringCommand(12, 3));
        charStringCommandMap.put(Key.OR.hashValue, new CharStringCommand(12, 4));
        charStringCommandMap.put(Key.NOT.hashValue, new CharStringCommand(12, 5));
        charStringCommandMap.put(Key.SEAC.hashValue, new CharStringCommand(12, 6));
        charStringCommandMap.put(Key.SBW.hashValue, new CharStringCommand(12, 7));
        charStringCommandMap.put(Key.ABS.hashValue, new CharStringCommand(12, 9));
        charStringCommandMap.put(Key.ADD.hashValue, new CharStringCommand(12, 10));
        charStringCommandMap.put(Key.SUB.hashValue, new CharStringCommand(12, 11));
        charStringCommandMap.put(Key.DIV.hashValue, new CharStringCommand(12, 12));
        charStringCommandMap.put(Key.NEG.hashValue, new CharStringCommand(12, 14));
        charStringCommandMap.put(Key.EQ.hashValue, new CharStringCommand(12, 15));
        charStringCommandMap.put(Key.CALLOTHERSUBR.hashValue, new CharStringCommand(12, 16));
        charStringCommandMap.put(Key.POP.hashValue, new CharStringCommand(12, 17));
        charStringCommandMap.put(Key.DROP.hashValue, new CharStringCommand(12, 18));
        charStringCommandMap.put(Key.PUT.hashValue, new CharStringCommand(12, 20));
        charStringCommandMap.put(Key.GET.hashValue, new CharStringCommand(12, 21));
        charStringCommandMap.put(Key.IFELSE.hashValue, new CharStringCommand(12, 22));
        charStringCommandMap.put(Key.RANDOM.hashValue, new CharStringCommand(12, 23));
        charStringCommandMap.put(Key.MUL.hashValue, new CharStringCommand(12, 24));
        charStringCommandMap.put(Key.SQRT.hashValue, new CharStringCommand(12, 26));
        charStringCommandMap.put(Key.DUP.hashValue, new CharStringCommand(12, 27));
        charStringCommandMap.put(Key.EXCH.hashValue, new CharStringCommand(12, 28));
        charStringCommandMap.put(Key.INDEX.hashValue, new CharStringCommand(12, 29));
        charStringCommandMap.put(Key.ROLL.hashValue, new CharStringCommand(12, 30));
        charStringCommandMap.put(Key.SETCURRENTPOINT.hashValue, new CharStringCommand(12, 33));
        charStringCommandMap.put(Key.HFLEX.hashValue, new CharStringCommand(12, 34));
        charStringCommandMap.put(Key.FLEX.hashValue, new CharStringCommand(12, 35));
        charStringCommandMap.put(Key.HFLEX1.hashValue, new CharStringCommand(12, 36));
        charStringCommandMap.put(Key.FLEX1.hashValue, new CharStringCommand(12, 37));
        return charStringCommandMap;
    }

    private CharStringCommand(Key key) {
        this.type1KeyWord = Type1KeyWord.valueOfKey(key.hashValue);
        this.type2KeyWord = Type2KeyWord.valueOfKey(key.hashValue);
    }

    private CharStringCommand(int b0, int b1) {
        this.type1KeyWord = Type1KeyWord.valueOfKey(b0, b1);
        this.type2KeyWord = Type2KeyWord.valueOfKey(b0, b1);
    }

    public static CharStringCommand getInstance(int b0) {
        CharStringCommand command = CHAR_STRING_COMMANDS.get(b0);
        return command != null ? command : COMMAND_UNKNOWN;
    }

    public static CharStringCommand getInstance(int b0, int b1) {
        CharStringCommand command = CHAR_STRING_COMMANDS.get(CharStringCommand.getKeyHashValue(b0, b1));
        return command != null ? command : COMMAND_UNKNOWN;
    }

    public static CharStringCommand getInstance(int[] values) {
        if (values.length == 1) {
            return CharStringCommand.getInstance(values[0]);
        }
        if (values.length == 2) {
            return CharStringCommand.getInstance(values[0], values[1]);
        }
        return COMMAND_UNKNOWN;
    }

    private static int getKeyHashValue(int b0, int b1) {
        Type1KeyWord type1Key = Type1KeyWord.valueOfKey(b0, b1);
        if (type1Key != null) {
            return type1Key.key.hashValue;
        }
        Type2KeyWord type2Key = Type2KeyWord.valueOfKey(b0, b1);
        if (type2Key != null) {
            return type2Key.key.hashValue;
        }
        return 99;
    }

    public Type1KeyWord getType1KeyWord() {
        return this.type1KeyWord;
    }

    public Type2KeyWord getType2KeyWord() {
        return this.type2KeyWord;
    }

    public String toString() {
        String str = this.type2KeyWord != null ? this.type2KeyWord.toString() : (this.type1KeyWord != null ? this.type1KeyWord.toString() : "unknown command");
        return str + '|';
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type1KeyWord, this.type2KeyWord});
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        CharStringCommand that = (CharStringCommand)object;
        return that.type1KeyWord == this.type1KeyWord && that.type2KeyWord == this.type2KeyWord;
    }

    public static enum Key {
        HSTEM(1),
        VSTEM(3),
        VMOVETO(4),
        RLINETO(5),
        HLINETO(6),
        VLINETO(7),
        RRCURVETO(8),
        CLOSEPATH(9),
        CALLSUBR(10),
        RET(11),
        ESCAPE(12),
        DOTSECTION(12, 0),
        VSTEM3(12, 1),
        HSTEM3(12, 2),
        AND(12, 3),
        OR(12, 4),
        NOT(12, 5),
        SEAC(12, 6),
        SBW(12, 7),
        ABS(12, 9),
        ADD(12, 10),
        SUB(12, 11),
        DIV(12, 12),
        NEG(12, 14),
        EQ(12, 15),
        CALLOTHERSUBR(12, 16),
        POP(12, 17),
        DROP(12, 18),
        PUT(12, 20),
        GET(12, 21),
        IFELSE(12, 22),
        RANDOM(12, 23),
        MUL(12, 24),
        SQRT(12, 26),
        DUP(12, 27),
        EXCH(12, 28),
        INDEX(12, 29),
        ROLL(12, 30),
        SETCURRENTPOINT(12, 33),
        HFLEX(12, 34),
        FLEX(12, 35),
        HFLEX1(12, 36),
        FLEX1(12, 37),
        HSBW(13),
        ENDCHAR(14),
        HSTEMHM(18),
        HINTMASK(19),
        CNTRMASK(20),
        RMOVETO(21),
        HMOVETO(22),
        VSTEMHM(23),
        RCURVELINE(24),
        RLINECURVE(25),
        VVCURVETO(26),
        HHCURVETO(27),
        SHORTINT(28),
        CALLGSUBR(29),
        VHCURVETO(30),
        HVCURVETO(31);

        private final int hashValue;
        private static final Map<Integer, Key> BY_KEY;

        private Key(int b0) {
            this.hashValue = b0;
        }

        private Key(int b0, int b1) {
            this.hashValue = (b0 << 4) + b1;
        }

        public static Key valueOfKey(int b0) {
            return BY_KEY.get(b0);
        }

        public static Key valueOfKey(int b0, int b1) {
            return BY_KEY.get((b0 << 4) + b1);
        }

        static {
            BY_KEY = new HashMap<Integer, Key>();
            for (Key e : Key.values()) {
                BY_KEY.put(e.hashValue, e);
            }
        }
    }

    public static enum Type1KeyWord {
        HSTEM(Key.HSTEM),
        VSTEM(Key.VSTEM),
        VMOVETO(Key.VMOVETO),
        RLINETO(Key.RLINETO),
        HLINETO(Key.HLINETO),
        VLINETO(Key.VLINETO),
        RRCURVETO(Key.RRCURVETO),
        CLOSEPATH(Key.CLOSEPATH),
        CALLSUBR(Key.CALLSUBR),
        RET(Key.RET),
        ESCAPE(Key.ESCAPE),
        DOTSECTION(Key.DOTSECTION),
        VSTEM3(Key.VSTEM3),
        HSTEM3(Key.HSTEM3),
        SEAC(Key.SEAC),
        SBW(Key.SBW),
        DIV(Key.DIV),
        CALLOTHERSUBR(Key.CALLOTHERSUBR),
        POP(Key.POP),
        SETCURRENTPOINT(Key.SETCURRENTPOINT),
        HSBW(Key.HSBW),
        ENDCHAR(Key.ENDCHAR),
        RMOVETO(Key.RMOVETO),
        HMOVETO(Key.HMOVETO),
        VHCURVETO(Key.VHCURVETO),
        HVCURVETO(Key.HVCURVETO);

        final Key key;
        private static final Map<Key, Type1KeyWord> BY_KEY;

        private Type1KeyWord(Key key) {
            this.key = key;
        }

        public static Type1KeyWord valueOfKey(int b0) {
            return BY_KEY.get((Object)Key.valueOfKey(b0));
        }

        public static Type1KeyWord valueOfKey(int b0, int b1) {
            return BY_KEY.get((Object)Key.valueOfKey(b0, b1));
        }

        public static Type1KeyWord valueOfKey(Key key) {
            return BY_KEY.get((Object)key);
        }

        static {
            BY_KEY = new EnumMap<Key, Type1KeyWord>(Key.class);
            for (Type1KeyWord e : Type1KeyWord.values()) {
                BY_KEY.put(e.key, e);
            }
        }
    }

    public static enum Type2KeyWord {
        HSTEM(Key.HSTEM),
        VSTEM(Key.VSTEM),
        VMOVETO(Key.VMOVETO),
        RLINETO(Key.RLINETO),
        HLINETO(Key.HLINETO),
        VLINETO(Key.VLINETO),
        RRCURVETO(Key.RRCURVETO),
        CALLSUBR(Key.CALLSUBR),
        RET(Key.RET),
        ESCAPE(Key.ESCAPE),
        AND(Key.AND),
        OR(Key.OR),
        NOT(Key.NOT),
        ABS(Key.ABS),
        ADD(Key.ADD),
        SUB(Key.SUB),
        DIV(Key.DIV),
        NEG(Key.NEG),
        EQ(Key.EQ),
        DROP(Key.DROP),
        PUT(Key.PUT),
        GET(Key.GET),
        IFELSE(Key.IFELSE),
        RANDOM(Key.RANDOM),
        MUL(Key.MUL),
        SQRT(Key.SQRT),
        DUP(Key.DUP),
        EXCH(Key.EXCH),
        INDEX(Key.INDEX),
        ROLL(Key.ROLL),
        HFLEX(Key.HFLEX),
        FLEX(Key.FLEX),
        HFLEX1(Key.HFLEX1),
        FLEX1(Key.FLEX1),
        ENDCHAR(Key.ENDCHAR),
        HSTEMHM(Key.HSTEMHM),
        HINTMASK(Key.HINTMASK),
        CNTRMASK(Key.CNTRMASK),
        RMOVETO(Key.RMOVETO),
        HMOVETO(Key.HMOVETO),
        VSTEMHM(Key.VSTEMHM),
        RCURVELINE(Key.RCURVELINE),
        RLINECURVE(Key.RLINECURVE),
        VVCURVETO(Key.VVCURVETO),
        HHCURVETO(Key.HHCURVETO),
        SHORTINT(Key.SHORTINT),
        CALLGSUBR(Key.CALLGSUBR),
        VHCURVETO(Key.VHCURVETO),
        HVCURVETO(Key.HVCURVETO);

        final Key key;
        private static final Map<Key, Type2KeyWord> BY_KEY;

        private Type2KeyWord(Key key) {
            this.key = key;
        }

        public static Type2KeyWord valueOfKey(int b0) {
            return BY_KEY.get((Object)Key.valueOfKey(b0));
        }

        public static Type2KeyWord valueOfKey(int b0, int b1) {
            return BY_KEY.get((Object)Key.valueOfKey(b0, b1));
        }

        public static Type2KeyWord valueOfKey(Key key) {
            return BY_KEY.get((Object)key);
        }

        static {
            BY_KEY = new EnumMap<Key, Type2KeyWord>(Key.class);
            for (Type2KeyWord e : Type2KeyWord.values()) {
                BY_KEY.put(e.key, e);
            }
        }
    }
}

