/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.LocalTables;
import ucar.nc2.util.TableParser;

public class KmaLocalTables
extends LocalTables {
    private static final String tablePath = "resources/grib2/local/kma-ver5.txt";
    private static boolean debug = false;
    private static KmaLocalTables single;

    public static KmaLocalTables getCust(Grib2Table table) {
        if (single == null) {
            single = new KmaLocalTables(table);
        }
        return single;
    }

    private KmaLocalTables(Grib2Table grib2Table) {
        super(grib2Table);
        grib2Table.setPath(tablePath);
        this.initLocalTable();
    }

    protected void initLocalTable() {
        ClassLoader cl = KmaLocalTables.class.getClassLoader();
        try (InputStream is = cl.getResourceAsStream(tablePath);){
            if (is == null) {
                throw new IllegalStateException("Cant find resources/grib2/local/kma-ver5.txt");
            }
            List<TableParser.Record> recs = TableParser.readTable(is, "41,112,124i,136i,148i,160", 1000);
            for (TableParser.Record record : recs) {
                String name = (String)record.get(0);
                int disc = (Integer)record.get(2);
                int cat = (Integer)record.get(3);
                int param = (Integer)record.get(4);
                String unit = (String)record.get(5);
                Grib2Parameter s2 = new Grib2Parameter(disc, cat, param, name, unit, null, null);
                this.local.put(KmaLocalTables.makeHash(disc, cat, param), s2);
                if (!debug) continue;
                System.out.printf(" %s%n", s2);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void main(String[] arg) {
        KmaLocalTables t2 = new KmaLocalTables(new Grib2Table("KMA", 40, -1, -1, -1, -1, null, Grib2Table.Type.kma));
    }
}

