/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gco;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.xml.NilReason;
import org.apache.sis.xml.bind.gco.GO_Integer;
import org.apache.sis.xml.bind.gco.GO_UnlimitedInteger;
import org.apache.sis.xml.bind.gco.UnlimitedInteger;

@XmlType(name="MultiplicityRange_Type", propOrder={"lower", "upper"})
public final class MultiplicityRange {
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_Integer.class)
    public Integer lower;
    @XmlElement(required=true)
    @XmlJavaTypeAdapter(value=GO_UnlimitedInteger.class)
    public UnlimitedInteger upper;

    public MultiplicityRange() {
    }

    private MultiplicityRange(NumberRange<Integer> range) {
        if (range != null) {
            this.lower = (Integer)range.getMinValue();
            if (this.lower == null) {
                this.lower = NilReason.UNKNOWN.createNilObject(Integer.class);
            } else if (!range.isMinIncluded()) {
                this.lower = Math.incrementExact(this.lower);
            }
            this.upper = new UnlimitedInteger((Integer)range.getMaxValue(), range.isMaxIncluded());
        } else {
            this.lower = 0;
            this.upper = new UnlimitedInteger();
        }
    }

    static MultiplicityRange wrap(NumberRange<Integer> range) {
        return range != null ? new MultiplicityRange(range) : null;
    }

    NumberRange<Integer> value() {
        Integer h2;
        if (this.lower != null && this.upper != null && ((h2 = this.upper.value()) != null || this.upper.isInfinite())) {
            return new NumberRange<Integer>(Integer.class, this.lower, true, h2, true);
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.value());
    }
}

