/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.iso;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.DefaultInternationalString;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.UnknownNameException;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.iso.AbstractFactory;
import org.apache.sis.util.iso.DefaultLocalName;
import org.apache.sis.util.iso.DefaultMemberName;
import org.apache.sis.util.iso.DefaultNameSpace;
import org.apache.sis.util.iso.DefaultScopedName;
import org.apache.sis.util.iso.DefaultTypeName;
import org.apache.sis.util.iso.TypeNames;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.Identifier;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;
import org.opengis.util.LocalName;
import org.opengis.util.MemberName;
import org.opengis.util.NameFactory;
import org.opengis.util.NameSpace;
import org.opengis.util.TypeName;

public class DefaultNameFactory
extends AbstractFactory
implements NameFactory {
    static final String SEPARATOR_KEY = "separator";
    static final String HEAD_SEPARATOR_KEY = "separator.head";
    private final WeakHashSet<GenericName> pool = new WeakHashSet<GenericName>(GenericName.class);
    private volatile transient TypeNames typeNames;
    private static final DefaultNameFactory INSTANCE = new DefaultNameFactory();

    public static DefaultNameFactory provider() {
        return INSTANCE;
    }

    @Override
    public InternationalString createInternationalString(Map<Locale, String> strings) {
        ArgumentChecks.ensureNonNull("strings", strings);
        switch (strings.size()) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)30));
            }
            case 1: {
                return new SimpleInternationalString(strings.values().iterator().next());
            }
        }
        return new DefaultInternationalString(strings);
    }

    private static String getString(Map<String, ?> properties, String key) {
        Object value;
        if (properties != null && (value = properties.get(key)) != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public NameSpace createNameSpace(GenericName name, Map<String, ?> properties) {
        boolean isEmpty;
        String headSeparator;
        ArgumentChecks.ensureNonNull("name", name);
        String separator = DefaultNameFactory.getString(properties, SEPARATOR_KEY);
        if (separator == null) {
            separator = ":";
        }
        if ((headSeparator = DefaultNameFactory.getString(properties, HEAD_SEPARATOR_KEY)) == null) {
            headSeparator = separator;
        }
        if ((isEmpty = separator.isEmpty()) || headSeparator.isEmpty()) {
            throw new IllegalArgumentException(Errors.format((short)32, isEmpty ? SEPARATOR_KEY : HEAD_SEPARATOR_KEY));
        }
        return DefaultNameSpace.forName(name.toFullyQualifiedName(), headSeparator, separator);
    }

    @Override
    public TypeName createTypeName(NameSpace scope, CharSequence name) throws UnknownNameException {
        return this.pool.unique(new DefaultTypeName(scope, name));
    }

    public TypeName createTypeName(NameSpace scope, CharSequence name, Type javaType) {
        return this.pool.unique(new DefaultTypeName(scope, name, javaType));
    }

    public MemberName createMemberName(NameSpace scope, CharSequence name, TypeName attributeType) {
        return this.pool.unique(new DefaultMemberName(scope, name, attributeType));
    }

    @Override
    public LocalName createLocalName(NameSpace scope, CharSequence name) {
        if (scope instanceof DefaultNameSpace) {
            return ((DefaultNameSpace)scope).local(name, null);
        }
        return this.pool.unique(new DefaultLocalName(scope, name));
    }

    @Override
    public GenericName createGenericName(NameSpace scope, CharSequence ... parsedNames) {
        ArgumentChecks.ensureNonEmpty("parsedNames", parsedNames);
        if (parsedNames.length == 1) {
            return this.createLocalName(scope, parsedNames[0]);
        }
        return this.pool.unique(new DefaultScopedName(scope, Arrays.asList(parsedNames)));
    }

    @Override
    public GenericName parseGenericName(NameSpace scope, CharSequence name) {
        int upper;
        String separator = DefaultNameSpace.getSeparator(scope, false);
        int s2 = separator.length();
        ArrayList<String> names = new ArrayList<String>();
        int lower = 0;
        String string = name.toString();
        while ((upper = string.indexOf(separator, lower)) >= 0) {
            names.add(string.substring(lower, upper));
            lower = upper + s2;
        }
        names.add(string.substring(lower));
        if (names.size() == 1) {
            return this.createLocalName(scope, name);
        }
        return this.createGenericName(scope, (CharSequence[])names.toArray(String[]::new));
    }

    public GenericName[] toGenericNames(Object value) throws ClassCastException {
        Object[] values;
        if (value == null) {
            return null;
        }
        GenericName name = this.toGenericName(value);
        if (name != null) {
            return new GenericName[]{name};
        }
        if (value instanceof Object[]) {
            values = (Object[])value;
            if (values instanceof GenericName[]) {
                return (GenericName[])values;
            }
        } else if (value instanceof Collection) {
            values = ((Collection)value).toArray();
        } else {
            throw new ClassCastException(Errors.format((short)42, "value", value.getClass()));
        }
        GenericName[] names = new GenericName[values.length];
        for (int i = 0; i < values.length; ++i) {
            value = values[i];
            if (value == null) continue;
            name = this.toGenericName(value);
            if (name == null) {
                throw new ClassCastException(Errors.format((short)42, Strings.toIndexed("value", i), value.getClass()));
            }
            names[i] = name;
        }
        return names;
    }

    private GenericName toGenericName(Object value) {
        if (value instanceof GenericName) {
            return (GenericName)value;
        }
        if (value instanceof Identifier) {
            return this.parseGenericName(null, ((Identifier)value).getCode());
        }
        if (value instanceof CharSequence) {
            return this.parseGenericName(null, (CharSequence)value);
        }
        if (value instanceof Class) {
            return this.toTypeName((Class)value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeName toTypeName(Class<?> valueClass) {
        if (!TypeNames.isValid(valueClass)) {
            return null;
        }
        TypeNames mapper = this.typeNames;
        if (mapper == null) {
            TypeNames c = new TypeNames(this);
            DefaultNameFactory defaultNameFactory = this;
            synchronized (defaultNameFactory) {
                mapper = this.typeNames;
                if (mapper == null) {
                    this.typeNames = mapper = c;
                }
            }
        }
        return mapper.toTypeName(this, valueClass);
    }
}

