/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.wkt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.ProbeResult;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.base.Capability;
import org.apache.sis.storage.base.StoreMetadata;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.wkt.FirstKeywordPeek;
import org.apache.sis.storage.wkt.Store;
import org.apache.sis.util.Version;

@StoreMetadata(formatName="WKT", fileSuffixes={"prj"}, capabilities={Capability.READ})
public final class StoreProvider
extends URIDataStore.Provider {
    public static final String NAME = "WKT";
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.storage.wkt");

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public ProbeResult probeContent(StorageConnector connector) throws DataStoreException {
        return Peek.INSTANCE.probeContent(this, connector);
    }

    @Override
    public DataStore open(StorageConnector connector) throws DataStoreException {
        return new Store(this, connector);
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    static final class Peek
    extends FirstKeywordPeek {
        static final Peek INSTANCE = new Peek();
        static final int MIN_LENGTH = 6;
        private final Set<String> keywords;

        private Peek() {
            super(14);
            HashSet<String> s2 = new HashSet<String>(22);
            s2.add("GeodeticCRS");
            s2.add("GeodCRS");
            s2.add("GeogCS");
            s2.add("GeocCS");
            s2.add("VerticalCRS");
            s2.add("VertCRS");
            s2.add("Vert_CS");
            s2.add("TimeCRS");
            s2.add("ImageCRS");
            s2.add("EngineeringCRS");
            s2.add("EngCRS");
            s2.add("Local_CS");
            s2.add("CompoundCRS");
            s2.add("Compd_CS");
            s2.add("ProjectedCRS");
            s2.add("ProjCRS");
            s2.add("ProjCS");
            s2.add("Fitted_CS");
            s2.add("BoundCRS");
            this.keywords = s2;
        }

        final Set<String> keywords() {
            return Collections.unmodifiableSet(this.keywords);
        }

        @Override
        protected boolean isPostKeyword(int c) {
            return c == 91 || c == 40;
        }

        @Override
        protected ProbeResult forKeyword(char[] keyword, int length) {
            if (length >= 6) {
                int pos = length;
                int version = 1;
                keyword[0] = (char)(keyword[0] & 0xFFDF);
                int n = --pos;
                keyword[n] = (char)(keyword[n] & 0xFFDF);
                int n2 = --pos;
                keyword[n2] = (char)(keyword[n2] & 0xFFDF);
                if (keyword[n2] == 'R') {
                    int n3 = --pos;
                    keyword[n3] = (char)(keyword[n3] & 0xFFDF);
                    version = 2;
                }
                while (--pos != 0) {
                    if (keyword[pos] == '_') continue;
                    int n4 = pos;
                    keyword[n4] = (char)(keyword[n4] | 0x20);
                }
                if (this.keywords.contains(String.valueOf(keyword, 0, length))) {
                    return new ProbeResult(true, null, Version.valueOf(version));
                }
            }
            return ProbeResult.UNSUPPORTED_STORAGE;
        }
    }
}

