/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.esri;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.image.PixelIterator;
import org.apache.sis.image.SequenceType;
import org.apache.sis.io.stream.ChannelDataOutput;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStoreReferencingException;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.storage.esri.AsciiGridStore;
import org.apache.sis.storage.esri.AsciiGridStoreProvider;
import org.apache.sis.storage.internal.WritableResourceSupport;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.StringBuilders;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.TransformException;

final class WritableStore
extends AsciiGridStore
implements WritableGridCoverageResource {
    private final String lineSeparator = System.lineSeparator();
    private ChannelDataOutput output;

    public WritableStore(AsciiGridStoreProvider provider, StorageConnector connector) throws DataStoreException {
        super(provider, connector, false);
        if (!super.canReadOrWrite(false)) {
            this.output = connector.commit(ChannelDataOutput.class, "ASCII Grid");
        }
    }

    @Override
    boolean canReadOrWrite(boolean write) {
        return write || super.canReadOrWrite(write);
    }

    private static double distanceFromIntegers(MathTransform gridToCRS) throws TransformException {
        Matrix m4 = MathTransforms.getMatrix(gridToCRS.inverse());
        if (m4 != null && Matrices.isAffine(m4)) {
            int last = m4.getNumCol() - 1;
            double sum = 0.0;
            for (int j = 0; j < last; ++j) {
                double e = m4.getElement(j, last);
                sum += Math.abs(Math.rint(e) - e);
            }
            return sum;
        }
        return Double.NaN;
    }

    private static SequenceType getAffineCoefficients(Map<String, Object> header, GridGeometry gg, WritableResourceSupport h2) throws DataStoreException {
        String xll = "XLLCORNER";
        String yll = "YLLCORNER";
        MathTransform gridToCRS = gg.getGridToCRS(PixelInCell.CELL_CORNER);
        try {
            MathTransform alternative = gg.getGridToCRS(PixelInCell.CELL_CENTER);
            if (WritableStore.distanceFromIntegers(alternative) < WritableStore.distanceFromIntegers(gridToCRS)) {
                gridToCRS = alternative;
                xll = "XLLCENTER";
                yll = "YLLCENTER";
            }
        }
        catch (TransformException e) {
            throw new DataStoreReferencingException(h2.canNotWrite(), e);
        }
        AffineTransform at = h2.getAffineTransform2D(gg.getExtent(), gridToCRS);
        if (at.getShearX() != 0.0 || at.getShearY() != 0.0) {
            throw new IncompatibleResourceException(h2.rotationNotSupported("ASCII Grid"));
        }
        double scaleX = at.getScaleX();
        double scaleY = -at.getScaleY();
        double x = at.getTranslateX();
        double y = at.getTranslateY();
        if (!(scaleX > 0.0) || !(scaleY > 0.0)) {
            throw new IncompatibleResourceException(h2.canNotWrite());
        }
        header.put(xll, x);
        header.put(yll, y -= scaleY * (double)((Integer)header.get("NROWS")).intValue());
        if (scaleX == scaleY) {
            header.put("CELLSIZE", scaleX);
        } else {
            header.put(CELLSIZES[0], scaleX);
            header.put(CELLSIZES[1], scaleY);
        }
        return SequenceType.LINEAR;
    }

    private void writeHeader(Map<String, Object> header, ChannelDataOutput out) throws IOException {
        String text;
        int maxKeyLength = 0;
        int maxValLength = 0;
        for (Map.Entry<String, Object> entry : header.entrySet()) {
            text = entry.getValue().toString();
            entry.setValue(text);
            maxValLength = Math.max(maxValLength, text.length());
            maxKeyLength = Math.max(maxKeyLength, entry.getKey().length());
        }
        for (Map.Entry<String, Object> entry : header.entrySet()) {
            text = entry.getKey();
            WritableStore.write(text, out);
            WritableStore.write(CharSequences.spaces(maxKeyLength - text.length() + 1), out);
            text = (String)entry.getValue();
            WritableStore.write(CharSequences.spaces(maxValLength - text.length()), out);
            WritableStore.write(text, out);
            WritableStore.write(this.lineSeparator, out);
        }
    }

    @Override
    public synchronized void write(GridCoverage coverage, WritableGridCoverageResource.Option ... options) throws DataStoreException {
        WritableResourceSupport h2 = new WritableResourceSupport(this, options);
        boolean band = false;
        try {
            int width;
            if (this.output == null && !h2.replace(this.input().input)) {
                coverage = h2.update(coverage);
            }
            RenderedImage data = coverage.render(null);
            LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
            header.put("NCOLS", data.getWidth());
            header.put("NROWS", data.getHeight());
            SequenceType order = WritableStore.getAffineCoefficients(header, coverage.getGridGeometry(), h2);
            ChannelDataOutput out = this.output != null ? this.output : h2.channel(this.input().input);
            Number nodataValue = this.setCoverage(coverage, data, 0);
            header.put("NODATA_VALUE", nodataValue);
            this.writeHeader(header, out);
            float nodataAsFloat = nodataValue.floatValue();
            double nodataAsDouble = nodataValue.doubleValue();
            StringBuilder buffer = new StringBuilder();
            PixelIterator it = new PixelIterator.Builder().setIteratorOrder(order).create(data);
            int dataType = it.getDataType().toDataBufferType();
            int remaining = width = it.getDomain().width;
            while (it.next()) {
                switch (dataType) {
                    case 5: {
                        double value = it.getSampleDouble(0);
                        if (Double.isNaN(value)) {
                            value = nodataAsDouble;
                        }
                        buffer.append(value);
                        StringBuilders.trimFractionalPart(buffer);
                        break;
                    }
                    case 4: {
                        float value = it.getSampleFloat(0);
                        if (Float.isNaN(value)) {
                            value = nodataAsFloat;
                        }
                        buffer.append(value);
                        StringBuilders.trimFractionalPart(buffer);
                        break;
                    }
                    default: {
                        buffer.append(it.getSample(0));
                    }
                }
                WritableStore.write(buffer, out);
                buffer.setLength(0);
                if (--remaining != 0) {
                    out.writeByte(32);
                    continue;
                }
                WritableStore.write(this.lineSeparator, out);
                remaining = width;
            }
            out.flush();
            this.writePRJ();
            if (this.output != null) {
                this.output = null;
                out.channel.close();
            }
        }
        catch (IOException e) {
            this.closeOnError(e);
            throw new DataStoreException(e);
        }
    }

    private static void write(CharSequence text, ChannelDataOutput out) throws IOException {
        int length = text.length();
        out.ensureBufferAccepts(length);
        for (int i = 0; i < length; ++i) {
            out.buffer.put((byte)text.charAt(i));
        }
    }

    @Override
    public synchronized void close() throws DataStoreException {
        this.listeners.close();
        ChannelDataOutput out = this.output;
        this.output = null;
        if (out != null) {
            try {
                out.channel.close();
            }
            catch (IOException e) {
                throw new DataStoreException(e);
            }
        }
        super.close();
    }
}

