/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.aggregate;

import java.time.Duration;
import java.time.Instant;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.util.ExtentSelector;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.aggregate.AggregatedResource;
import org.apache.sis.util.internal.Strings;

public final class MergeStrategy {
    private static final MergeStrategy SELECT_BY_TIME = new MergeStrategy(null);
    private final Duration timeGranularity;

    private MergeStrategy(Duration timeGranularity) {
        this.timeGranularity = timeGranularity;
    }

    public static MergeStrategy selectByTimeThenArea(Duration timeGranularity) {
        return timeGranularity != null ? new MergeStrategy(timeGranularity) : SELECT_BY_TIME;
    }

    final Integer apply(GridGeometry request, GridGeometry[] candidates) {
        ExtentSelector<Integer> selector = new ExtentSelector<Integer>(request.getGeographicExtent().orElse(null), request.getTemporalExtent());
        if (this.timeGranularity != null) {
            selector.setTimeGranularity(this.timeGranularity);
            selector.alternateOrdering = true;
        }
        for (int i = 0; i < candidates.length; ++i) {
            GridGeometry candidate = candidates[i];
            if (candidate == null) continue;
            Instant[] t2 = candidate.getTemporalExtent();
            int n = t2.length;
            selector.evaluate(candidate.getGeographicExtent().orElse(null), n == 0 ? null : t2[0], n == 0 ? null : t2[n - 1], i);
        }
        return (Integer)selector.best();
    }

    public Resource apply(Resource resource) {
        if (resource instanceof AggregatedResource) {
            return ((AggregatedResource)((Object)resource)).apply(this);
        }
        return resource;
    }

    public String toString() {
        return Strings.toString(this.getClass(), "algo", "selectByTimeThenArea", "timeGranularity", this.timeGranularity);
    }
}

