/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;

@XmlTransient
public class AxisOrderReversal
extends AbstractProvider {
    private static final long serialVersionUID = 7027181359241386097L;
    private static final ParameterDescriptorGroup PARAMETERS = ((ParameterBuilder)((ParameterBuilder)AxisOrderReversal.builder().addIdentifier("9843")).addName("Axis order reversal (2D)")).createGroup(new GeneralParameterDescriptor[0]);
    private transient MathTransform transform;
    private final int size;

    public AxisOrderReversal() {
        this(PARAMETERS, 3);
    }

    AxisOrderReversal(ParameterDescriptorGroup parameters, int size) {
        super(Conversion.class, parameters, CoordinateSystem.class, false, CoordinateSystem.class, false);
        this.size = size;
    }

    @Override
    public synchronized MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup values) {
        if (this.transform == null) {
            MatrixSIS m4 = Matrices.createZero(this.size, this.size);
            m4.setElement(0, 1, 1.0);
            m4.setElement(1, 0, 1.0);
            for (int i = 2; i < this.size; ++i) {
                m4.setElement(i, i, 1.0);
            }
            this.transform = MathTransforms.linear(m4);
        }
        return this.transform;
    }
}

