/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.measure.Latitude;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.FactoryException;

public class SatelliteTracking
extends NormalizedProjection {
    private static final long serialVersionUID = 859940667477896653L;
    private final double cos_i;
    private final double sin_i;
    private final double cos2_i;
    private final double p2_on_p1;
    private final double n;
    private final double s0;
    private final boolean isConic;

    static Initializer initializer(OperationMethod method, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> roles = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        roles.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, org.apache.sis.referencing.operation.provider.SatelliteTracking.CENTRAL_MERIDIAN);
        roles.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, org.apache.sis.referencing.operation.provider.SatelliteTracking.LATITUDE_OF_ORIGIN);
        return new Initializer(method, parameters, roles, null);
    }

    public SatelliteTracking(OperationMethod method, Parameters parameters) {
        this(SatelliteTracking.initializer(method, parameters));
    }

    private SatelliteTracking(Initializer initializer) {
        super(initializer, null);
        double \u03c60 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.SatelliteTracking.LATITUDE_OF_ORIGIN));
        double \u03c61 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_1));
        double \u03c62 = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_2));
        double i = Math.toRadians(initializer.getAndStore(org.apache.sis.referencing.operation.provider.SatelliteTracking.SATELLITE_ORBIT_INCLINATION));
        this.p2_on_p1 = initializer.getAndStore(org.apache.sis.referencing.operation.provider.SatelliteTracking.SATELLITE_ORBITAL_PERIOD) / initializer.getAndStore(org.apache.sis.referencing.operation.provider.SatelliteTracking.ASCENDING_NODE_PERIOD);
        this.sin_i = Math.sin(i);
        this.cos_i = Math.cos(i);
        this.cos2_i = this.cos_i * this.cos_i;
        this.isConic = Math.abs(\u03c62 + \u03c61) > 1.5706706731410455E-9;
        double cos\u03c61 = Math.cos(\u03c61);
        double cos2_\u03c61 = cos\u03c61 * cos\u03c61;
        MatrixSIS denormalize = this.context.getMatrix(ContextualParameters.MatrixRole.DENORMALIZATION);
        if (this.isConic) {
            double sin\u03c61 = Math.sin(\u03c61);
            double L0 = this.L(Math.sin(\u03c60), org.apache.sis.referencing.operation.provider.SatelliteTracking.LATITUDE_OF_ORIGIN);
            double L1 = this.L(sin\u03c61, org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            double F1 = this.F(cos2_\u03c61, org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            if (Math.abs(\u03c62 - \u03c61) < 1.5706706731410455E-9) {
                this.n = sin\u03c61 * (this.p2_on_p1 * (2.0 * this.cos2_i - cos2_\u03c61) - this.cos_i) / (this.p2_on_p1 * cos2_\u03c61 - this.cos_i);
            } else {
                double cos\u03c62 = Math.cos(\u03c62);
                double F2 = this.F(cos\u03c62 * cos\u03c62, org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_2);
                double L2 = this.L(Math.sin(\u03c62), org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_2);
                this.n = (F2 - F1) / (L2 - L1);
            }
            this.s0 = F1 - this.n * L1;
            double \u03c1f = cos\u03c61 * Math.sin(F1) / this.n;
            double \u03c10 = \u03c1f / Math.sin(this.n * L0 + this.s0);
            if (!Double.isFinite(\u03c1f) || \u03c1f == 0.0) {
                throw this.invalid(org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            }
            MatrixSIS normalize = this.context.getMatrix(ContextualParameters.MatrixRole.NORMALIZATION);
            normalize.convertAfter(0, this.n, null);
            denormalize.convertBefore(0, \u03c1f, null);
            denormalize.convertBefore(1, -\u03c1f, \u03c10);
        } else {
            this.s0 = Double.NaN;
            this.n = Double.NaN;
            double cotF = Math.sqrt(cos2_\u03c61 - this.cos2_i) / (this.p2_on_p1 * cos2_\u03c61 - this.cos_i);
            denormalize.convertBefore(0, cos\u03c61, null);
            denormalize.convertBefore(1, cos\u03c61 * cotF, null);
            if (!Double.isFinite(cotF) || cotF == 0.0) {
                throw this.invalid(org.apache.sis.referencing.operation.provider.SatelliteTracking.STANDARD_PARALLEL_1);
            }
        }
    }

    @Override
    public MathTransform createMapProjection(MathTransformFactory factory) throws FactoryException {
        if (this.isConic) {
            return this.completeWithWraparound(factory);
        }
        return super.createMapProjection(factory);
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"i", "P\u2082\u2215P\u2081"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.cos_i < 0.7853981633974483 ? Math.acos(this.cos_i) : Math.asin(this.sin_i), this.p2_on_p1};
    }

    private double F(double cos2_\u03c6, ParameterDescriptor<Double> source) {
        double F = Math.atan((this.p2_on_p1 * cos2_\u03c6 - this.cos_i) / Math.sqrt(cos2_\u03c6 - this.cos2_i));
        if (Double.isFinite(F)) {
            return F;
        }
        throw this.invalid(source);
    }

    private double L(double sin\u03c6, ParameterDescriptor<Double> source) {
        double \u03bbp = -Math.asin(sin\u03c6 / this.sin_i);
        double L = Math.atan(Math.tan(\u03bbp) * this.cos_i) - this.p2_on_p1 * \u03bbp;
        if (Double.isFinite(L)) {
            return L;
        }
        throw this.invalid(source);
    }

    private InvalidParameterValueException invalid(ParameterDescriptor<Double> source) {
        String name = source.getName().getCode();
        double value = this.context.doubleValue(source);
        double limit = Math.abs(this.context.doubleValue(org.apache.sis.referencing.operation.provider.SatelliteTracking.SATELLITE_ORBIT_INCLINATION));
        return new InvalidParameterValueException(Errors.format((short)166, name, -limit, limit, new Latitude(value)), name, value);
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws ProjectionException {
        double \u03c6 = srcPts[srcOff + 1];
        double sin\u03c6_sini = Math.sin(\u03c6) / this.sin_i;
        double \u03bbpm = -Math.asin(sin\u03c6_sini);
        double tan\u03bbp = Math.tan(\u03bbpm);
        double \u03bbt = Math.atan(tan\u03bbp * this.cos_i);
        double x = srcPts[srcOff];
        double y = \u03bbt - this.p2_on_p1 * \u03bbpm;
        if (this.isConic) {
            \u03bbpm = this.n * y + this.s0;
            if ((Double.doubleToRawLongBits(\u03bbpm) ^ Double.doubleToRawLongBits(this.n)) < 0L) {
                \u03bbpm = Double.NaN;
            }
            double i\u03c1 = Math.sin(\u03bbpm);
            y = Math.cos(x) / i\u03c1;
            x = Math.sin(x) / i\u03c1;
        }
        if (dstPts != null) {
            dstPts[dstOff] = x;
            dstPts[dstOff + 1] = y;
        }
        if (!derivate) {
            return null;
        }
        Matrix2 d = new Matrix2();
        d.m11 = Math.cos(\u03c6) / this.sin_i / Math.sqrt(1.0 - sin\u03c6_sini * sin\u03c6_sini) * (this.p2_on_p1 - (1.0 + tan\u03bbp * tan\u03bbp) * this.cos_i / (1.0 + \u03bbt * \u03bbt));
        if (this.isConic) {
            double d\u03c1_d\u03c6 = -this.n / Math.tan(\u03bbpm);
            d.m00 = y;
            d.m10 = -x;
            d.m01 = x * d\u03c1_d\u03c6 * d.m11;
            d.m11 *= y * d\u03c1_d\u03c6;
        }
        return d;
    }

    @Override
    protected void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff) throws ProjectionException {
        double \u0394\u03bbp;
        double x = srcPts[srcOff];
        double L = srcPts[srcOff + 1];
        if (this.isConic) {
            double \u03c1 = Math.copySign(Math.hypot(x, L), this.n);
            x = Math.atan(x / L);
            L = (Math.asin(1.0 / \u03c1) - this.s0) / this.n;
        }
        double ic = 1.0 / this.cos2_i;
        double pc = this.p2_on_p1 * this.cos_i;
        double \u03bbp = -1.5707963267948966;
        int iter = 18;
        do {
            if (--iter < 0) {
                throw new ProjectionException(Resources.format((short)46));
            }
            double A2 = Math.tan(L + this.p2_on_p1 * \u03bbp) / this.cos_i;
            double A22 = A2 * A2;
            \u0394\u03bbp = (Math.atan(A2) - \u03bbp) / (1.0 - pc * ((A22 + ic) / (A22 + 1.0)));
            \u03bbp += \u0394\u03bbp;
        } while (Math.abs(\u0394\u03bbp) >= 1.5706706731410455E-9);
        dstPts[dstOff] = x;
        dstPts[dstOff + 1] = -Math.asin(Math.sin(\u03bbp) * this.sin_i);
    }
}

