/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.sis.referencing.factory.sql.AuthorityCodes;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.system.ReferenceQueueConsumer;
import org.apache.sis.util.Disposable;
import org.apache.sis.util.logging.Logging;

final class CloseableReference
extends WeakReference<AuthorityCodes>
implements Disposable {
    private final EPSGDataAccess factory;
    private final Statement[] statements;

    CloseableReference(AuthorityCodes ref, EPSGDataAccess factory, Statement[] statements) {
        super(ref, ReferenceQueueConsumer.QUEUE);
        this.statements = statements;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws SQLException {
        SQLException exception = null;
        EPSGDataAccess ePSGDataAccess = this.factory;
        synchronized (ePSGDataAccess) {
            int i = this.statements.length;
            while (--i >= 0) {
                Statement s2 = this.statements[i];
                this.statements[i] = null;
                if (s2 == null) continue;
                try {
                    s2.close();
                }
                catch (SQLException e) {
                    if (exception == null) {
                        exception = e;
                        continue;
                    }
                    exception.addSuppressed(e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void dispose() {
        try {
            this.close();
        }
        catch (SQLException exception) {
            Logging.unexpectedException(EPSGDataAccess.LOGGER, AuthorityCodes.class, "close", exception);
        }
    }
}

