/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.MeasurementParseException;
import javax.measure.spi.SystemOfUnits;
import org.apache.sis.math.Fraction;
import org.apache.sis.measure.AbstractUnit;
import org.apache.sis.measure.ConventionalUnit;
import org.apache.sis.measure.SystemUnit;
import org.apache.sis.measure.UnitDimension;
import org.apache.sis.measure.Units;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.logging.Logging;

final class UnitRegistry
implements SystemOfUnits,
Serializable {
    private static final long serialVersionUID = -84557361079506390L;
    static final byte PREFIXABLE = 1;
    static final byte SI = 2;
    static final byte ACCEPTED = 4;
    static final byte CGS = 8;
    static final byte IMPERIAL = 16;
    static final byte OTHER = 32;
    private static final Map<Object, Object> HARD_CODED = new HashMap<Object, Object>(256);
    private static final WeakValueHashMap<Object, Object> USER_DEFINED = new WeakValueHashMap(Object.class, UnitRegistry::hashCodeOrdered, UnitRegistry::equalsOrdered);
    final String name;
    private final int includes;
    private transient Set<Unit<?>> units;

    private static int hashCodeOrdered(Object key) {
        if (key instanceof UnitDimension) {
            return ((UnitDimension)key).hashCodeOrdered();
        }
        if (key instanceof Map) {
            return UnitDimension.hashCodeOrdered((Map)key);
        }
        return key.hashCode();
    }

    private static boolean equalsOrdered(Object key, Object other) {
        if (key instanceof UnitDimension) {
            if (other instanceof UnitDimension) {
                return ((UnitDimension)key).equalsOrdered((UnitDimension)other);
            }
        } else if (key instanceof Map && other instanceof Map) {
            return UnitDimension.equalsOrdered((Map)key, (Map)other);
        }
        return key.equals(other);
    }

    static void init(Map<UnitDimension, Fraction> components, UnitDimension dim) {
        assert (!Units.initialized) : dim.symbol;
        if (HARD_CODED.put(components, dim) != null) {
            throw new AssertionError(dim.symbol);
        }
    }

    static <Q extends Quantity<Q>> SystemUnit<Q> init(SystemUnit<Q> unit) {
        assert (!Units.initialized) : unit;
        String symbol = unit.getSymbol();
        int existed = HARD_CODED.put(unit.dimension, unit) == null ? 0 : 1;
        existed |= HARD_CODED.put(unit.quantity, unit) == null ? 0 : 2;
        if (symbol != null) {
            existed |= HARD_CODED.put(symbol, unit) == null ? 0 : 4;
        }
        if (unit.epsg != 0) {
            existed |= HARD_CODED.put(unit.epsg, unit) == null ? 0 : 8;
        }
        assert (UnitRegistry.filter(existed, unit, symbol) == 0) : unit;
        return unit;
    }

    private static int filter(int existed, SystemUnit<?> unit, String s2) {
        if ("cd".equals(s2) || "Hz".equals(s2) || "Bq".equals(s2)) {
            existed &= 0xFFFFFFFE;
        }
        if (unit.dimension.isDimensionless()) {
            existed &= 0xFFFFFFFC;
        }
        return s2 == null || s2.isEmpty() ? 0 : existed;
    }

    static <Q extends Quantity<Q>> ConventionalUnit<Q> init(ConventionalUnit<Q> unit) {
        assert (!Units.initialized) : unit;
        if (HARD_CODED.put(unit.getSymbol(), unit) == null && (unit.epsg == 0 || HARD_CODED.put(unit.epsg, unit) == null)) {
            return unit;
        }
        throw new AssertionError(unit);
    }

    static void alias(Unit<?> unit, Comparable<?> alias) {
        assert (!Units.initialized) : unit;
        if (HARD_CODED.put(alias, unit) != null) {
            throw new AssertionError(unit);
        }
    }

    static Object putIfAbsent(Object key, Object value) {
        assert (Units.initialized) : value;
        Object previous = HARD_CODED.get(key);
        if (previous == null) {
            previous = USER_DEFINED.putIfAbsent(key, value);
        }
        return previous;
    }

    static Object get(Object key) {
        Object value = HARD_CODED.get(key);
        if (value == null) {
            value = USER_DEFINED.get(key);
        }
        return value;
    }

    UnitRegistry(String name, int includes) {
        this.name = name;
        this.includes = includes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <Q extends Quantity<Q>> Unit<Q> getUnit(Class<Q> type) {
        return Units.get(type);
    }

    @Override
    public Unit<?> getUnit(String symbols) {
        try {
            return Units.valueOf(symbols);
        }
        catch (MeasurementParseException e) {
            Logging.ignorableException(AbstractUnit.LOGGER, UnitRegistry.class, "getUnit", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Unit<?>> getUnits() {
        if (Units.initialized) {
            UnitRegistry unitRegistry = this;
            synchronized (unitRegistry) {
                if (this.units == null) {
                    this.units = new HashSet();
                    for (Object value : HARD_CODED.values()) {
                        if (!(value instanceof AbstractUnit)) continue;
                        AbstractUnit unit = (AbstractUnit)value;
                        if ((unit.scope & this.includes) == 0) continue;
                        this.units.add(unit);
                    }
                    this.units = Collections.unmodifiableSet(this.units);
                }
            }
        }
        return this.units;
    }

    public Set<Unit<?>> getUnits(Dimension dimension) {
        ArgumentChecks.ensureNonNull("dimension", dimension);
        HashSet filtered = new HashSet();
        for (Unit<?> unit : this.getUnits()) {
            if (!dimension.equals(unit.getDimension())) continue;
            filtered.add(unit);
        }
        return filtered;
    }
}

