/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Objects;
import javax.measure.Unit;
import org.apache.sis.measure.RangeFormat;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.CheckedContainer;
import org.apache.sis.util.internal.Strings;

public class Range<E extends Comparable<? super E>>
implements CheckedContainer<E>,
Formattable,
Emptiable,
Serializable {
    private static final long serialVersionUID = 603508245068333284L;
    final Class<E> elementType;
    final E minValue;
    final E maxValue;
    final boolean isMinIncluded;
    final boolean isMaxIncluded;

    public Range(Range<E> range) {
        this.elementType = range.elementType;
        this.minValue = range.minValue;
        this.isMinIncluded = range.isMinIncluded;
        this.maxValue = range.maxValue;
        this.isMaxIncluded = range.isMaxIncluded;
        assert (this.validate()) : this.elementType;
    }

    public Range(Class<E> elementType, E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        ArgumentChecks.ensureNonNull("elementType", elementType);
        this.elementType = elementType;
        this.minValue = minValue;
        this.isMinIncluded = isMinIncluded && minValue != null;
        this.maxValue = maxValue;
        boolean bl = this.isMaxIncluded = isMaxIncluded && maxValue != null;
        assert (this.validate()) : elementType;
    }

    Range<E> create(E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        return new Range<E>(this.elementType, minValue, isMinIncluded, maxValue, isMaxIncluded);
    }

    Range<E>[] newArray(int length) {
        return new Range[length];
    }

    Unit<?> unit() {
        return null;
    }

    private boolean validate() {
        ArgumentChecks.ensureCanCast("minValue", this.elementType, this.minValue);
        ArgumentChecks.ensureCanCast("maxValue", this.elementType, this.maxValue);
        return Comparable.class.isAssignableFrom(this.elementType);
    }

    @Override
    public Class<E> getElementType() {
        return this.elementType;
    }

    public E getMinValue() {
        return this.minValue;
    }

    public boolean isMinIncluded() {
        return this.isMinIncluded;
    }

    public E getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxIncluded() {
        return this.isMaxIncluded;
    }

    @Override
    public final boolean isEmpty() {
        if (this.minValue == null || this.maxValue == null) {
            return false;
        }
        int c = this.minValue.compareTo(this.maxValue);
        if (c < 0) {
            return false;
        }
        if (c != 0) {
            return !Range.isNaN(this.minValue);
        }
        if (!this.isMinIncluded || !this.isMaxIncluded) {
            return true;
        }
        return Range.isNaN(this.minValue);
    }

    private static boolean isNaN(Object value) {
        if (value instanceof Double) {
            return ((Double)value).isNaN();
        }
        if (value instanceof Float) {
            return ((Float)value).isNaN();
        }
        return false;
    }

    public boolean isBounded() {
        return this.minValue != null && this.maxValue != null;
    }

    public boolean contains(E value) {
        int c;
        if (value == null) {
            return false;
        }
        if (this.minValue != null) {
            c = this.minValue.compareTo(value);
            if (this.isMinIncluded ? c > 0 : c >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            c = this.maxValue.compareTo(value);
            if (this.isMaxIncluded ? c < 0 : c <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean contains(Range<? extends E> range) {
        return this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) <= 0 && this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) >= 0;
    }

    public boolean intersects(Range<? extends E> range) {
        return this.compareMinTo(range.maxValue, range.isMaxIncluded ? 0 : 1) <= 0 && this.compareMaxTo(range.minValue, range.isMinIncluded ? 0 : -1) >= 0;
    }

    public Range<E> intersect(Range<E> range) {
        if (range.isEmpty()) {
            return range;
        }
        if (this.isEmpty()) {
            return this;
        }
        Range<E> min2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) < 0 ? range : this;
        Range<E> max = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) > 0 ? range : this;
        Range<E> intersect = min2 == max ? min2 : this.create(min2.minValue, min2.isMinIncluded, max.maxValue, max.isMaxIncluded);
        assert (intersect.isEmpty() == !this.intersects(range)) : intersect;
        return intersect;
    }

    public Range<E> union(Range<E> range) {
        if (range.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return range;
        }
        Range<E> min2 = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) > 0 ? range : this;
        Range<E> max = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) < 0 ? range : this;
        Range<E> union = min2 == max ? min2 : this.create(min2.minValue, min2.isMinIncluded, max.maxValue, max.isMaxIncluded);
        assert (union.contains(min2)) : min2;
        assert (union.contains(max)) : max;
        return union;
    }

    public Range<E>[] subtract(Range<E> range) {
        Range<E> subtract;
        if (!this.intersects(range)) {
            subtract = this;
        } else {
            boolean clipMax;
            boolean clipMin = this.compareMinTo(range.minValue, range.isMinIncluded ? 0 : -1) >= 0;
            boolean bl = clipMax = this.compareMaxTo(range.maxValue, range.isMaxIncluded ? 0 : 1) <= 0;
            if (clipMin) {
                if (clipMax) {
                    assert (range.contains(this)) : range;
                    return this.newArray(0);
                }
                subtract = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
            } else {
                if (!clipMax) {
                    Range<E>[] array = this.newArray(2);
                    array[0] = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
                    array[1] = this.create(range.maxValue, !range.isMaxIncluded, this.maxValue, this.isMaxIncluded);
                    return array;
                }
                subtract = this.create(this.minValue, this.isMinIncluded, range.minValue, !range.isMinIncluded);
            }
        }
        assert (this.contains(subtract)) : subtract;
        assert (!subtract.intersects(range)) : subtract;
        Range<E>[] array = this.newArray(1);
        array[0] = subtract;
        return array;
    }

    private int compareMinTo(E value, int position) {
        if (this.minValue == null) {
            return value == null ? 0 : -1;
        }
        if (value == null) {
            return -position;
        }
        int c = this.minValue.compareTo(value);
        if (c != 0) {
            return c;
        }
        if (!this.isMinIncluded) {
            ++position;
        }
        return position;
    }

    private int compareMaxTo(E value, int position) {
        if (this.maxValue == null) {
            return value == null ? 0 : 1;
        }
        if (value == null) {
            return -position;
        }
        int c = this.maxValue.compareTo(value);
        if (c != 0) {
            return c;
        }
        if (!this.isMaxIncluded) {
            --position;
        }
        return position;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            Range other = (Range)object;
            if (Objects.equals(this.elementType, other.elementType)) {
                if (this.isEmpty()) {
                    return other.isEmpty();
                }
                return Objects.equals(this.minValue, other.minValue) && Objects.equals(this.maxValue, other.maxValue) && this.isMinIncluded == other.isMinIncluded && this.isMaxIncluded == other.isMaxIncluded;
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = this.elementType.hashCode();
        if (!this.isEmpty()) {
            hash = 13 * hash + Objects.hashCode(this.minValue);
            hash = 13 * hash + Objects.hashCode(this.maxValue);
            hash += this.isMinIncluded ? 17 : 37;
            hash += this.isMaxIncluded ? 1231 : 1237;
        }
        return hash ^ 0x265140E4;
    }

    private static boolean isCompact(Comparable<?> value, boolean ifNull) {
        if (value == null) {
            return ifNull;
        }
        long n = ((Number)((Object)value)).longValue();
        return n >= 0L && n < 10L;
    }

    public String toString() {
        String symbol;
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(20);
        if (this.minValue != null && this.minValue.equals(this.maxValue)) {
            buffer.append('{').append(this.minValue).append('}');
        } else {
            buffer.append(this.isMinIncluded ? (char)'[' : '(');
            if (this.minValue == null) {
                buffer.append("\u2212\u221e");
            } else {
                buffer.append(this.minValue);
            }
            if (Numbers.isInteger(this.elementType) && Range.isCompact(this.minValue, false) && Range.isCompact(this.maxValue, true)) {
                buffer.append('\u2026');
            } else {
                buffer.append(" \u2026 ");
            }
            if (this.maxValue == null) {
                buffer.append('\u221e');
            } else {
                buffer.append(this.maxValue);
            }
            buffer.append(this.isMaxIncluded ? (char)']' : ')');
        }
        Unit<?> unit = this.unit();
        if (unit != null && (symbol = unit.toString()) != null && !symbol.isEmpty()) {
            if (Character.isLetterOrDigit(symbol.codePointAt(0))) {
                buffer.append(' ');
            }
            buffer.append(symbol);
        }
        return buffer.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        String value;
        if (precision == 0) {
            value = "";
        } else {
            RangeFormat format = new RangeFormat(formatter.locale(), this.elementType);
            format.setAlternateForm((flags & 4) != 0);
            value = format.format(this, new StringBuffer(), null).toString();
        }
        Strings.formatTo(formatter, flags, width, precision, value);
    }
}

