/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.resources.Errors;

public class MeasurementRange<E extends Number>
extends NumberRange<E> {
    private static final long serialVersionUID = -3532903747339978756L;
    private final Unit<?> unit;

    public static MeasurementRange<Float> create(float minValue, boolean isMinIncluded, float maxValue, boolean isMaxIncluded, Unit<?> unit) {
        Float max;
        Float min2;
        return MeasurementRange.unique(new MeasurementRange<Float>(Float.class, min2, isMinIncluded, Objects.equals(min2 = MeasurementRange.valueOf("minValue", minValue, Float.NEGATIVE_INFINITY), max = MeasurementRange.valueOf("maxValue", maxValue, Float.POSITIVE_INFINITY)) ? min2 : max, isMaxIncluded, unit));
    }

    public static MeasurementRange<Double> create(double minValue, boolean isMinIncluded, double maxValue, boolean isMaxIncluded, Unit<?> unit) {
        Double max;
        Double min2;
        return MeasurementRange.unique(new MeasurementRange<Double>(Double.class, min2, isMinIncluded, Objects.equals(min2 = MeasurementRange.valueOf("minValue", minValue, Double.NEGATIVE_INFINITY), max = MeasurementRange.valueOf("maxValue", maxValue, Double.POSITIVE_INFINITY)) ? min2 : max, isMaxIncluded, unit));
    }

    public static MeasurementRange<Double> createGreaterThan(double minValue, Unit<?> unit) {
        return MeasurementRange.unique(new MeasurementRange<Object>((Class<Object>)Double.class, MeasurementRange.valueOf("minValue", minValue, Double.NEGATIVE_INFINITY), false, null, false, unit));
    }

    public static MeasurementRange<?> createBestFit(Number minValue, boolean isMinIncluded, Number maxValue, boolean isMaxIncluded, Unit<?> unit) {
        boolean isCacheable;
        Class<? extends Number> type = Numbers.widestClass(Numbers.narrowestClass(minValue), Numbers.narrowestClass(maxValue));
        if (type == null) {
            return null;
        }
        Number min2 = Numbers.cast(minValue, type);
        Number max = Numbers.cast(maxValue, type);
        boolean bl = isCacheable = MeasurementRange.isCacheable(min2) && MeasurementRange.isCacheable(max);
        if (isCacheable && Objects.equals(min2, max)) {
            max = min2;
        }
        MeasurementRange<Number> range = new MeasurementRange<Number>(type, min2, isMinIncluded, max, isMaxIncluded, unit);
        if (isCacheable) {
            range = MeasurementRange.unique(range);
        }
        return range;
    }

    public MeasurementRange(Range<E> range, Unit<?> unit) {
        super(range);
        this.unit = unit;
    }

    public MeasurementRange(Class<E> type, ValueRange range, Unit<?> unit) throws IllegalArgumentException {
        super(type, range);
        this.unit = unit;
    }

    public MeasurementRange(Class<E> type, E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded, Unit<?> unit) {
        super(type, minValue, isMinIncluded, maxValue, isMaxIncluded);
        this.unit = unit;
    }

    private MeasurementRange(Class<E> type, Range<? extends Number> range, Unit<?> unit) {
        super(type, range);
        this.unit = unit;
    }

    @Override
    Range<E> create(E minValue, boolean isMinIncluded, E maxValue, boolean isMaxIncluded) {
        return new MeasurementRange<E>(this.elementType, minValue, isMinIncluded, maxValue, isMaxIncluded, this.unit);
    }

    @Override
    public Unit<?> unit() {
        return this.unit;
    }

    public MeasurementRange<E> convertTo(Unit<?> targetUnit) throws IncommensurableException {
        return this.convertAndCast(this.elementType, targetUnit);
    }

    @Override
    public <N extends Number> MeasurementRange<N> castTo(Class<N> type) {
        if (this.elementType == type) {
            return this;
        }
        return new MeasurementRange<N>(type, this, this.unit);
    }

    private <N extends E> Range<N> convert(Range<N> range) throws IllegalArgumentException {
        if (range instanceof MeasurementRange) {
            try {
                return ((MeasurementRange)range).convertAndCast(range.elementType, this.unit);
            }
            catch (IncommensurableException e) {
                throw new IllegalArgumentException(Errors.format((short)66, ((MeasurementRange)range).unit, this.unit), e);
            }
        }
        return range;
    }

    @Override
    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> range, Class<N> type) throws IllegalArgumentException {
        if (range instanceof MeasurementRange) {
            try {
                return ((MeasurementRange)range).convertAndCast(type, this.unit);
            }
            catch (IncommensurableException e) {
                throw new IllegalArgumentException(Errors.format((short)66, ((MeasurementRange)range).unit, this.unit), e);
            }
        }
        return new MeasurementRange<N>(type, range, this.unit);
    }

    @Override
    private <N extends Number> MeasurementRange<N> convertAndCast(Class<N> type, Unit<?> targetUnit) throws IncommensurableException {
        UnitConverter converter;
        if (targetUnit == null || targetUnit.equals(this.unit)) {
            if (this.elementType == type) {
                return this;
            }
            targetUnit = this.unit;
        } else if (this.unit != null && !(converter = this.unit.getConverterToAny(targetUnit)).isIdentity()) {
            double maximum;
            boolean minInc = this.isMinIncluded;
            boolean maxInc = this.isMaxIncluded;
            double minimum = converter.convert(this.getMinDouble());
            if (minimum > (maximum = converter.convert(this.getMaxDouble()))) {
                double td = minimum;
                minimum = maximum;
                maximum = td;
                boolean tb = minInc;
                minInc = maxInc;
                maxInc = tb;
            }
            if (Numbers.isInteger(type)) {
                minInc &= minimum == (minimum = Math.floor(minimum));
                double d = maximum;
                maximum = Math.ceil(maximum);
                maxInc &= d == maximum;
            }
            return new MeasurementRange<N>(type, Numbers.cast(minimum, type), minInc, Numbers.cast(maximum, type), maxInc, targetUnit);
        }
        return new MeasurementRange<N>(type, this, targetUnit);
    }

    @Override
    final Range<E>[] newArray(int length) {
        return new MeasurementRange[length];
    }

    @Override
    public boolean contains(Range<? extends E> range) throws IllegalArgumentException {
        return super.contains(this.convert(range));
    }

    @Override
    public boolean intersects(Range<? extends E> range) throws IllegalArgumentException {
        return super.intersects(this.convert(range));
    }

    @Override
    public Range<E> intersect(Range<E> range) throws IllegalArgumentException {
        return super.intersect(this.convert(range));
    }

    @Override
    public Range<E> union(Range<E> range) throws IllegalArgumentException {
        return super.union(this.convert(range));
    }

    @Override
    public Range<E>[] subtract(Range<E> range) throws IllegalArgumentException {
        return super.subtract(this.convert(range));
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Objects.equals(this.unit, ((MeasurementRange)object).unit);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Objects.hashCode(this.unit);
    }
}

